/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.execution;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.execution.CompletableFutureExecutionFlow;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.execution.ImperativeExecutionFlow;
import io.micronaut.core.execution.ImperativeExecutionFlowImpl;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Internal
final class CompletableFutureExecutionFlowImpl
implements CompletableFutureExecutionFlow<Object> {
    private CompletionStage<Object> stage;

    CompletableFutureExecutionFlowImpl(CompletionStage<Object> stage) {
        this.stage = stage;
    }

    @Override
    public <R> ExecutionFlow<R> flatMap(Function<? super Object, ? extends ExecutionFlow<? extends R>> transformer) {
        ImperativeExecutionFlow<Object> completedFlow = this.tryComplete();
        if (completedFlow != null) {
            return completedFlow.flatMap(transformer);
        }
        this.stage = this.stage.thenCompose(value -> {
            if (value != null) {
                return ((ExecutionFlow)transformer.apply(value)).toCompletableFuture();
            }
            return CompletableFuture.completedFuture(null);
        });
        return this;
    }

    @Override
    public <R> ExecutionFlow<R> then(Supplier<? extends ExecutionFlow<? extends R>> supplier) {
        this.stage = this.stage.thenCompose(value -> ((ExecutionFlow)supplier.get()).toCompletableFuture());
        return this;
    }

    @Override
    public <R> ExecutionFlow<R> map(Function<? super Object, ? extends R> function) {
        this.stage = this.stage.thenApply(function);
        return this;
    }

    @Override
    public ExecutionFlow<Object> onErrorResume(Function<? super Throwable, ? extends ExecutionFlow<?>> fallback) {
        ImperativeExecutionFlow<Object> completedFlow = this.tryComplete();
        if (completedFlow != null) {
            return completedFlow.onErrorResume(fallback);
        }
        this.stage = this.stage.exceptionallyCompose(throwable -> {
            if (throwable instanceof CompletionException) {
                CompletionException completionException = (CompletionException)throwable;
                throwable = completionException.getCause();
            }
            return ((ExecutionFlow)fallback.apply((Throwable)throwable)).toCompletableFuture();
        });
        return this;
    }

    @Override
    public ExecutionFlow<Object> putInContext(String key, Object value) {
        return this;
    }

    @Override
    public void onComplete(BiConsumer<? super Object, Throwable> fn) {
        ImperativeExecutionFlow<Object> completedFlow = this.tryComplete();
        if (completedFlow != null) {
            completedFlow.onComplete(fn);
            return;
        }
        this.stage.handle((o, throwable) -> {
            if (throwable instanceof CompletionException) {
                CompletionException completionException = (CompletionException)throwable;
                throwable = completionException.getCause();
            }
            fn.accept(o, (Throwable)throwable);
            return null;
        });
    }

    @Override
    @Nullable
    public ImperativeExecutionFlow<Object> tryComplete() {
        CompletableFuture<Object> completableFuture = this.stage.toCompletableFuture();
        if (completableFuture.isDone()) {
            try {
                return new ImperativeExecutionFlowImpl(completableFuture.getNow(null), null);
            }
            catch (Throwable throwable) {
                if (throwable instanceof CompletionException) {
                    CompletionException completionException = (CompletionException)throwable;
                    throwable = completionException.getCause();
                }
                return new ImperativeExecutionFlowImpl(null, throwable);
            }
        }
        return null;
    }

    @Override
    public CompletableFuture<Object> toCompletableFuture() {
        return this.stage.toCompletableFuture();
    }
}

