/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.type;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.TypeVariableResolver;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public interface ReturnType<T>
extends TypeVariableResolver,
AnnotationMetadataProvider {
    public Class<T> getType();

    default public Argument<T> asArgument() {
        Collection<Argument<?>> values = this.getTypeVariables().values();
        return Argument.of(this.getType(), values.toArray(new Argument[0]));
    }

    default public boolean isSuspended() {
        return false;
    }

    default public boolean isReactive() {
        return Publishers.isConvertibleToPublisher(this.getType());
    }

    default public boolean isCompletable() {
        return Publishers.isCompletable(this.getType());
    }

    default public boolean isSingleResult() {
        if (this.isSpecifiedSingle()) {
            return true;
        }
        if (this.isReactive()) {
            Class<T> returnType = this.getType();
            return Publishers.isSingle(returnType);
        }
        return true;
    }

    default public boolean isSpecifiedSingle() {
        AnnotationMetadata annotationMetadata = this.getAnnotationMetadata();
        return annotationMetadata.hasStereotype((Class<? extends Annotation>)SingleResult.class) && annotationMetadata.booleanValue(SingleResult.NAME).orElse(true) != false;
    }

    default public boolean isAsync() {
        Class<T> type = this.getType();
        return CompletionStage.class.isAssignableFrom(type);
    }

    default public boolean isAsyncOrReactive() {
        return this.isAsync() || this.isReactive();
    }

    default public boolean isVoid() {
        Class<T> javaReturnType = this.getType();
        if (javaReturnType == Void.TYPE) {
            return true;
        }
        if (this.isCompletable()) {
            return true;
        }
        if (this.isReactive() || this.isAsync()) {
            return this.getFirstTypeVariable().filter(arg -> arg.getType() == Void.class).isPresent();
        }
        return false;
    }

    default public boolean isOptional() {
        Class<T> type = this.getType();
        return type == Optional.class;
    }

    public static <T1> ReturnType<T1> of(final Class<T1> type, final Argument<?> ... typeArguments) {
        final LinkedHashMap argumentMap = new LinkedHashMap(typeArguments.length);
        for (Argument<?> argument : typeArguments) {
            argumentMap.put(argument.getName(), argument);
        }
        return new ReturnType<T1>(){

            @Override
            public Class<T1> getType() {
                return type;
            }

            @Override
            public Argument[] getTypeParameters() {
                return typeArguments;
            }

            @Override
            public Map<String, Argument<?>> getTypeVariables() {
                return argumentMap;
            }
        };
    }
}

