/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.annotation;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import java.lang.annotation.Annotation;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;

public class AnnotationValueBuilder<T extends Annotation> {
    private final String annotationName;
    private final Map<CharSequence, Object> values = new HashMap<CharSequence, Object>(5);
    private final RetentionPolicy retentionPolicy;

    @Internal
    AnnotationValueBuilder(String annotationName) {
        this(annotationName, RetentionPolicy.RUNTIME);
    }

    @Internal
    AnnotationValueBuilder(String annotationName, RetentionPolicy retentionPolicy) {
        this.annotationName = annotationName;
        this.retentionPolicy = retentionPolicy != null ? retentionPolicy : RetentionPolicy.RUNTIME;
    }

    @Internal
    AnnotationValueBuilder(Class<?> annotation) {
        this(annotation.getName());
    }

    @Internal
    AnnotationValueBuilder(AnnotationValue<T> value, RetentionPolicy retentionPolicy) {
        this.annotationName = value.getAnnotationName();
        this.values.putAll(value.getValues());
        this.retentionPolicy = retentionPolicy != null ? retentionPolicy : RetentionPolicy.RUNTIME;
    }

    @NonNull
    public AnnotationValue<T> build() {
        return new AnnotationValue(this.annotationName, this.values, this.retentionPolicy);
    }

    public AnnotationValueBuilder<T> value(int i) {
        return this.member("value", i);
    }

    public AnnotationValueBuilder<T> values(int ... ints) {
        return this.member("value", ints);
    }

    public AnnotationValueBuilder<T> value(long i) {
        return this.member("value", i);
    }

    public AnnotationValueBuilder<T> values(long ... longs) {
        return this.member("value", longs);
    }

    public AnnotationValueBuilder<T> value(@Nullable String str) {
        return this.member("value", str);
    }

    public AnnotationValueBuilder<T> values(String ... strings) {
        return this.member("value", strings);
    }

    public AnnotationValueBuilder<T> value(boolean bool) {
        return this.member("value", bool);
    }

    public AnnotationValueBuilder<T> value(@Nullable Enum<?> enumObj) {
        return this.member("value", enumObj);
    }

    public AnnotationValueBuilder<T> values(Enum<?> ... enumObjs) {
        return this.member("value", enumObjs);
    }

    public AnnotationValueBuilder<T> value(@Nullable Class<?> type) {
        return this.member("value", type);
    }

    public AnnotationValueBuilder<T> values(Class<?> ... types) {
        return this.member("value", types);
    }

    public AnnotationValueBuilder<T> values(AnnotationClassValue<?> ... types) {
        return this.member("value", types);
    }

    public AnnotationValueBuilder<T> value(@Nullable AnnotationValue<?> annotation) {
        return this.member("value", annotation);
    }

    public AnnotationValueBuilder<T> values(AnnotationValue<?> ... annotations) {
        return this.member("value", annotations);
    }

    public AnnotationValueBuilder<T> member(String name, int i) {
        this.values.put(name, i);
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, int ... ints) {
        if (ints != null) {
            this.values.put(name, ints);
        }
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, long i) {
        this.values.put(name, i);
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, long ... longs) {
        if (longs != null) {
            this.values.put(name, longs);
        }
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, String str) {
        if (str != null) {
            this.values.put(name, str);
        }
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, String ... strings) {
        if (strings != null) {
            this.values.put(name, strings);
        }
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, boolean bool) {
        this.values.put(name, bool);
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, @Nullable Enum<?> enumObj) {
        if (enumObj != null) {
            this.values.put(name, enumObj);
        }
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, Enum<?> ... enumObjs) {
        if (enumObjs != null) {
            this.values.put(name, enumObjs);
        }
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, @Nullable Class<?> type) {
        if (type != null) {
            this.values.put(name, new AnnotationClassValue(type));
        }
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, Class<?> ... types) {
        if (types != null) {
            AnnotationClassValue[] classValues = new AnnotationClassValue[types.length];
            for (int i = 0; i < types.length; ++i) {
                Class<?> type = types[i];
                classValues[i] = new AnnotationClassValue(type);
            }
            this.values.put(name, classValues);
        }
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, @Nullable AnnotationValue<?> annotation) {
        if (annotation != null) {
            this.values.put(name, annotation);
        }
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, AnnotationValue<?> ... annotations) {
        if (annotations != null) {
            this.values.put(name, annotations);
        }
        return this;
    }

    public AnnotationValueBuilder<T> member(String name, AnnotationClassValue<?> ... classValues) {
        if (classValues != null) {
            this.values.put(name, classValues);
        }
        return this;
    }
}

