/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.liquibase;

import io.micronaut.context.ApplicationContext;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.liquibase.LiquibaseConfigurationProperties;
import io.micronaut.scheduling.annotation.Async;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.inject.Singleton;
import javax.sql.DataSource;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.OfflineConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AbstractLiquibaseMigration {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLiquibaseMigration.class);
    final ApplicationContext applicationContext;
    final ResourceAccessor resourceAccessor;

    AbstractLiquibaseMigration(ApplicationContext applicationContext, ResourceAccessor resourceAccessor) {
        this.applicationContext = applicationContext;
        this.resourceAccessor = resourceAccessor;
    }

    void run(LiquibaseConfigurationProperties config, DataSource dataSource) {
        if (config.isEnabled()) {
            if (config.isAsync()) {
                this.migrateAsync(config, dataSource);
            } else {
                this.migrate(config, dataSource);
            }
        }
    }

    @Async(value="io")
    void migrateAsync(LiquibaseConfigurationProperties config, DataSource dataSource) {
        this.migrate(config, dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrate(LiquibaseConfigurationProperties config, DataSource dataSource) {
        Connection connection;
        try {
            connection = dataSource.getConnection();
        }
        catch (SQLException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Migration failed! Could not connect to the datasource.", (Throwable)e);
            }
            this.applicationContext.close();
            return;
        }
        Liquibase liquibase = null;
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info("Running migrations for database with qualifier [{}]", (Object)config.getNameQualifier());
            }
            liquibase = this.createLiquibase(connection, config);
            this.generateRollbackFile(liquibase, config);
            this.performUpdate(liquibase, config);
        }
        catch (LiquibaseException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Migration failed! Liquibase encountered an exception.", (Throwable)e);
            }
            this.applicationContext.close();
        }
        finally {
            block19: {
                Database database = null;
                if (liquibase != null) {
                    database = liquibase.getDatabase();
                }
                if (database != null) {
                    try {
                        database.close();
                    }
                    catch (DatabaseException e) {
                        if (!LOG.isWarnEnabled()) break block19;
                        LOG.warn("Error closing the connection after the migration.", (Throwable)e);
                    }
                }
            }
        }
    }

    private void performUpdate(Liquibase liquibase, LiquibaseConfigurationProperties config) throws LiquibaseException {
        LabelExpression labelExpression = new LabelExpression(config.getLabels());
        Contexts contexts = new Contexts(config.getContexts());
        if (config.isTestRollbackOnUpdate()) {
            if (config.getTag() != null) {
                liquibase.updateTestingRollback(config.getTag(), contexts, labelExpression);
            } else {
                liquibase.updateTestingRollback(contexts, labelExpression);
            }
        } else if (config.getTag() != null) {
            liquibase.update(config.getTag(), contexts, labelExpression);
        } else {
            liquibase.update(contexts, labelExpression);
        }
    }

    private void generateRollbackFile(Liquibase liquibase, LiquibaseConfigurationProperties config) throws LiquibaseException {
        if (config.getRollbackFile() != null) {
            String outputEncoding = ((GlobalConfiguration)LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class)).getOutputEncoding();
            try (FileOutputStream fileOutputStream = new FileOutputStream(config.getRollbackFile());
                 OutputStreamWriter output = new OutputStreamWriter((OutputStream)fileOutputStream, outputEncoding);){
                Contexts contexts = new Contexts(config.getContexts());
                LabelExpression labelExpression = new LabelExpression(config.getLabels());
                if (config.getTag() != null) {
                    liquibase.futureRollbackSQL(config.getTag(), contexts, labelExpression, (Writer)output);
                } else {
                    liquibase.futureRollbackSQL(contexts, labelExpression, (Writer)output);
                }
            }
            catch (IOException e) {
                throw new LiquibaseException("Unable to generate rollback file.", (Throwable)e);
            }
        }
    }

    private Liquibase createLiquibase(Connection connection, LiquibaseConfigurationProperties config) throws LiquibaseException {
        String changeLog = config.getChangeLog();
        Database database = this.createDatabase(connection, this.resourceAccessor, config);
        Liquibase liquibase = new Liquibase(changeLog, this.resourceAccessor, database);
        if (config.getParameters() != null) {
            for (Map.Entry<String, String> entry : config.getParameters().entrySet()) {
                liquibase.setChangeLogParameter(entry.getKey(), (Object)entry.getValue());
            }
        }
        if (config.isDropFirst()) {
            liquibase.dropAll();
        }
        this.applicationContext.registerSingleton(Liquibase.class, (Object)liquibase, Qualifiers.byName((String)config.getNameQualifier()), false);
        return liquibase;
    }

    private Database createDatabase(Connection connection, ResourceAccessor resourceAccessor, LiquibaseConfigurationProperties config) throws DatabaseException {
        String liquibaseSchema;
        JdbcConnection liquibaseConnection;
        if (connection == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Null connection returned by liquibase datasource. Using offline unknown database");
            }
            liquibaseConnection = new OfflineConnection("offline:unknown", resourceAccessor);
        } else {
            liquibaseConnection = new JdbcConnection(connection);
        }
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)liquibaseConnection);
        String defaultSchema = config.getDefaultSchema();
        if (StringUtils.isNotEmpty((CharSequence)defaultSchema)) {
            if (database.supportsSchemas()) {
                database.setDefaultSchemaName(defaultSchema);
            } else if (database.supportsCatalogs()) {
                database.setDefaultCatalogName(defaultSchema);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(liquibaseSchema = config.getLiquibaseSchema()))) {
            if (database.supportsSchemas()) {
                database.setLiquibaseSchemaName(liquibaseSchema);
            } else if (database.supportsCatalogs()) {
                database.setLiquibaseCatalogName(liquibaseSchema);
            }
        }
        if (StringUtils.trimToNull((String)config.getLiquibaseTablespace()) != null && database.supportsTablespaces()) {
            database.setLiquibaseTablespaceName(config.getLiquibaseTablespace());
        }
        if (StringUtils.trimToNull((String)config.getDatabaseChangeLogTable()) != null) {
            database.setDatabaseChangeLogTableName(config.getDatabaseChangeLogTable());
        }
        if (StringUtils.trimToNull((String)config.getDatabaseChangeLogLockTable()) != null) {
            database.setDatabaseChangeLogLockTableName(config.getDatabaseChangeLogLockTable());
        }
        return database;
    }
}

