/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.ssl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.http.ssl.ClientAuthentication;
import io.micronaut.http.ssl.ServerSslConfiguration;
import io.micronaut.http.ssl.SslBuilder;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.http.ssl.SslConfigurationException;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Optional;
import javax.inject.Singleton;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;

@Singleton
@Internal
public class NettyServerSslBuilder
extends SslBuilder<SslContext> {
    public NettyServerSslBuilder(ServerSslConfiguration ssl, ResourceResolver resourceResolver) {
        super((SslConfiguration)ssl, resourceResolver);
    }

    public ServerSslConfiguration getSslConfiguration() {
        return (ServerSslConfiguration)this.ssl;
    }

    public Optional<SslContext> build() {
        if (!this.ssl.isEnabled()) {
            return Optional.empty();
        }
        if (this.ssl.buildSelfSigned()) {
            try {
                SelfSignedCertificate ssc = new SelfSignedCertificate();
                return Optional.of(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build());
            }
            catch (CertificateException | SSLException e) {
                throw new SslConfigurationException("Encountered an error while building a self signed certificate", (Throwable)e);
            }
        }
        SslContextBuilder sslBuilder = SslContextBuilder.forServer((KeyManagerFactory)this.getKeyManagerFactory()).trustManager(this.getTrustManagerFactory());
        if (this.ssl.getProtocols().isPresent()) {
            sslBuilder.protocols((String[])this.ssl.getProtocols().get());
        }
        if (this.ssl.getCiphers().isPresent()) {
            sslBuilder = sslBuilder.ciphers(Arrays.asList((Object[])this.ssl.getCiphers().get()));
        }
        if (this.ssl.getClientAuthentication().isPresent()) {
            ClientAuthentication clientAuth = (ClientAuthentication)this.ssl.getClientAuthentication().get();
            if (clientAuth == ClientAuthentication.NEED) {
                sslBuilder = sslBuilder.clientAuth(ClientAuth.REQUIRE);
            } else if (clientAuth == ClientAuthentication.WANT) {
                sslBuilder = sslBuilder.clientAuth(ClientAuth.OPTIONAL);
            }
        }
        try {
            return Optional.of(sslBuilder.build());
        }
        catch (SSLException ex) {
            throw new SslConfigurationException("An error occurred while setting up SSL", (Throwable)ex);
        }
    }
}

