/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.async.subscriber.CompletionAwareSubscriber;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.Writable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.StreamUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.filter.FilterChain;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.hateos.JsonError;
import io.micronaut.http.hateos.Link;
import io.micronaut.http.multipart.PartData;
import io.micronaut.http.multipart.StreamingFileUpload;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.netty.content.HttpContentUtil;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.micronaut.http.server.binding.RequestArgumentSatisfier;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.InternalServerException;
import io.micronaut.http.server.netty.DefaultHttpContentProcessor;
import io.micronaut.http.server.netty.DelegateStreamedHttpResponse;
import io.micronaut.http.server.netty.HttpContentProcessor;
import io.micronaut.http.server.netty.HttpContentSubscriberFactory;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.async.ContextCompletionAwareSubscriber;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.multipart.NettyPartData;
import io.micronaut.http.server.netty.multipart.NettyStreamingFileUpload;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseTypeHandler;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseTypeHandlerRegistry;
import io.micronaut.http.server.netty.types.files.NettyStreamedFileCustomizableResponseType;
import io.micronaut.http.server.netty.types.files.NettySystemFileCustomizableResponseType;
import io.micronaut.http.server.types.files.FileCustomizableResponseType;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.inject.MethodReference;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.runtime.http.codec.TextPlainCodec;
import io.micronaut.scheduling.executor.ExecutorSelector;
import io.micronaut.web.router.BasicObjectRouteMatch;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.UriRouteMatch;
import io.micronaut.web.router.exceptions.DuplicateRouteException;
import io.micronaut.web.router.exceptions.UnsatisfiedRouteException;
import io.micronaut.web.router.qualifier.ConsumesMediaTypeQualifier;
import io.micronaut.web.router.resource.StaticResourceResolver;
import io.micronaut.websocket.annotation.OnMessage;
import io.micronaut.websocket.annotation.OnOpen;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.ReplaySubject;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
class RoutingInBoundHandler
extends SimpleChannelInboundHandler<HttpRequest<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingInBoundHandler.class);
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe).*$", 2);
    private final Router router;
    private final ExecutorSelector executorSelector;
    private final StaticResourceResolver staticResourceResolver;
    private final ExecutorService ioExecutor;
    private final BeanLocator beanLocator;
    private final NettyHttpServerConfiguration serverConfiguration;
    private final RequestArgumentSatisfier requestArgumentSatisfier;
    private final MediaTypeCodecRegistry mediaTypeCodecRegistry;
    private final NettyCustomizableResponseTypeHandlerRegistry customizableResponseTypeHandlerRegistry;

    RoutingInBoundHandler(BeanLocator beanLocator, Router router, MediaTypeCodecRegistry mediaTypeCodecRegistry, NettyCustomizableResponseTypeHandlerRegistry customizableResponseTypeHandlerRegistry, StaticResourceResolver staticResourceResolver, NettyHttpServerConfiguration serverConfiguration, RequestArgumentSatisfier requestArgumentSatisfier, ExecutorSelector executorSelector, ExecutorService ioExecutor) {
        this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        this.customizableResponseTypeHandlerRegistry = customizableResponseTypeHandlerRegistry;
        this.beanLocator = beanLocator;
        this.staticResourceResolver = staticResourceResolver;
        this.ioExecutor = ioExecutor;
        this.executorSelector = executorSelector;
        this.router = router;
        this.requestArgumentSatisfier = requestArgumentSatisfier;
        this.serverConfiguration = serverConfiguration;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        NettyHttpRequest request;
        super.channelInactive(ctx);
        if (ctx.channel().isWritable()) {
            ctx.flush();
        }
        if ((request = NettyHttpRequest.remove(ctx)) != null) {
            request.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        try {
            IdleStateEvent idleStateEvent;
            IdleState state;
            if (evt instanceof IdleStateEvent && (state = (idleStateEvent = (IdleStateEvent)evt).state()) == IdleState.ALL_IDLE) {
                ctx.close();
            }
        }
        finally {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        NettyHttpRequest nettyHttpRequest = NettyHttpRequest.remove(ctx);
        RouteMatch errorRoute = null;
        if (nettyHttpRequest == null) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Micronaut Server Error - No request state present. Cause: " + cause.getMessage(), cause);
            }
            ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR));
            return;
        }
        RouteMatch<?> originalRoute = nettyHttpRequest.getMatchedRoute();
        Class declaringType = null;
        if (originalRoute instanceof MethodExecutionHandle) {
            declaringType = ((MethodExecutionHandle)originalRoute).getDeclaringType();
        }
        if (cause instanceof UnsatisfiedRouteException) {
            if (declaringType != null) {
                errorRoute = this.router.route(declaringType, HttpStatus.BAD_REQUEST).orElse(null);
            }
            if (errorRoute == null) {
                errorRoute = this.router.route(HttpStatus.BAD_REQUEST).orElse(null);
            }
        } else if (cause instanceof HttpStatusException) {
            HttpStatusException statusException = (HttpStatusException)cause;
            if (declaringType != null) {
                errorRoute = this.router.route(declaringType, statusException.getStatus()).orElse(null);
            }
            if (errorRoute == null) {
                errorRoute = this.router.route(statusException.getStatus()).orElse(null);
            }
        }
        if (errorRoute == null) {
            if (declaringType != null) {
                errorRoute = this.router.route(declaringType, cause).orElse(null);
            }
            if (errorRoute == null) {
                errorRoute = this.router.route(cause).orElse(null);
            }
        }
        if (errorRoute != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found matching exception handler for exception [{}]: {}", (Object)cause.getMessage(), (Object)errorRoute);
            }
            errorRoute = this.requestArgumentSatisfier.fulfillArgumentRequirements(errorRoute, (HttpRequest)nettyHttpRequest, false);
            MediaType defaultResponseMediaType = errorRoute.getProduces().stream().findFirst().orElse(MediaType.APPLICATION_JSON_TYPE);
            try {
                Object result = errorRoute.execute();
                MutableHttpResponse response = this.errorResultToResponse(result);
                MethodBasedRouteMatch methodBasedRoute = (MethodBasedRouteMatch)errorRoute;
                response.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, (Object)errorRoute);
                AtomicReference requestReference = new AtomicReference(nettyHttpRequest);
                Flowable<MutableHttpResponse<?>> routePublisher = this.buildRoutePublisher(methodBasedRoute.getDeclaringType(), methodBasedRoute.getReturnType().getType(), requestReference, Flowable.just((Object)response));
                Flowable<? extends MutableHttpResponse<?>> filteredPublisher = this.filterPublisher(requestReference, (Publisher<MutableHttpResponse<?>>)routePublisher, (ExecutorService)ctx.channel().eventLoop());
                this.subscribeToResponsePublisher(ctx, defaultResponseMediaType, requestReference, filteredPublisher);
                if (this.serverConfiguration.isLogHandledExceptions()) {
                    this.logException(cause);
                }
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Exception occurred executing error handler. Falling back to default error handling: " + e.getMessage(), e);
                }
                this.writeDefaultErrorResponse(ctx, nettyHttpRequest, e);
            }
        } else {
            Optional exceptionHandler = this.beanLocator.findBean(ExceptionHandler.class, Qualifiers.byTypeArguments((Class[])new Class[]{cause.getClass(), Object.class}));
            if (exceptionHandler.isPresent()) {
                ExceptionHandler handler = (ExceptionHandler)exceptionHandler.get();
                MediaType defaultResponseMediaType = MediaType.fromType(exceptionHandler.getClass()).orElse(MediaType.APPLICATION_JSON_TYPE);
                try {
                    Object result = handler.handle((HttpRequest)nettyHttpRequest, cause);
                    AtomicReference requestReference = new AtomicReference(nettyHttpRequest);
                    MutableHttpResponse response = this.errorResultToResponse(result);
                    Flowable<MutableHttpResponse<?>> routePublisher = this.buildRoutePublisher(handler.getClass(), result != null ? result.getClass() : HttpResponse.class, requestReference, Flowable.just((Object)response));
                    Flowable<? extends MutableHttpResponse<?>> filteredPublisher = this.filterPublisher(requestReference, (Publisher<MutableHttpResponse<?>>)routePublisher, (ExecutorService)ctx.channel().eventLoop());
                    this.subscribeToResponsePublisher(ctx, defaultResponseMediaType, requestReference, filteredPublisher);
                    if (this.serverConfiguration.isLogHandledExceptions()) {
                        this.logException(cause);
                    }
                }
                catch (Throwable e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Exception occurred executing error handler. Falling back to default error handling.");
                    }
                    this.writeDefaultErrorResponse(ctx, nettyHttpRequest, e);
                }
            } else {
                this.writeDefaultErrorResponse(ctx, nettyHttpRequest, cause);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest<?> request) {
        MediaType contentType;
        RouteMatch route;
        void var8_11;
        NettyHttpRequest nettyHttpRequest;
        io.netty.handler.codec.http.HttpRequest nativeRequest;
        DecoderResult decoderResult;
        ctx.channel().config().setAutoRead(false);
        HttpMethod httpMethod = request.getMethod();
        String requestPath = request.getPath();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Matching route {} - {}", (Object)httpMethod, (Object)requestPath);
        }
        if ((decoderResult = (nativeRequest = (nettyHttpRequest = (NettyHttpRequest)request).getNativeRequest()).decoderResult()).isFailure()) {
            Throwable throwable = decoderResult.cause();
            HttpStatus status = throwable instanceof TooLongFrameException ? HttpStatus.REQUEST_ENTITY_TOO_LARGE : HttpStatus.BAD_REQUEST;
            this.handleStatusError(ctx, request, nettyHttpRequest, (MutableHttpResponse<Object>)HttpResponse.status((HttpStatus)status), status.getReason());
            return;
        }
        Optional optional = Optional.empty();
        List uriRoutes = (List)this.router.find(httpMethod, (CharSequence)requestPath).filter(match -> match.test((Object)request)).collect(StreamUtils.minAll(Comparator.comparingInt(match -> match.getVariableValues().size()), Collectors.toList()));
        if (uriRoutes.size() > 1) {
            throw new DuplicateRouteException(requestPath, uriRoutes);
        }
        if (uriRoutes.size() == 1) {
            UriRouteMatch establishedRoute = (UriRouteMatch)uriRoutes.get(0);
            request.setAttribute((CharSequence)HttpAttributes.ROUTE, (Object)establishedRoute.getRoute());
            request.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, (Object)establishedRoute);
            request.setAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, (Object)establishedRoute.getRoute().getUriMatchTemplate().toString());
            Optional<UriRouteMatch> optional2 = Optional.of(establishedRoute);
        }
        if (!var8_11.isPresent()) {
            Set existingRoutes;
            if (LOG.isDebugEnabled()) {
                LOG.debug("No matching route found for URI {} and method {}", (Object)request.getUri(), (Object)httpMethod);
            }
            if (!(existingRoutes = this.router.findAny((CharSequence)request.getUri().toString()).map(UriRouteMatch::getHttpMethod).collect(Collectors.toSet())).isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Method not allowed for URI {} and method {}", (Object)request.getUri(), (Object)httpMethod);
                }
                this.handleStatusError(ctx, request, nettyHttpRequest, (MutableHttpResponse<Object>)HttpResponse.notAllowed(existingRoutes), "Method [" + httpMethod + "] not allowed. Allowed methods: " + existingRoutes);
                return;
            }
            Optional<? extends FileCustomizableResponseType> optionalFile = this.matchFile(requestPath);
            if (optionalFile.isPresent()) {
                route = new BasicObjectRouteMatch((Object)optionalFile.get());
            } else {
                Optional statusRoute = this.router.route(HttpStatus.NOT_FOUND);
                if (!statusRoute.isPresent()) {
                    this.emitDefaultNotFoundResponse(ctx, request);
                    return;
                }
                route = (RouteMatch)statusRoute.get();
            }
        } else {
            route = (RouteMatch)var8_11.get();
        }
        if (!route.accept(contentType = (MediaType)request.getContentType().orElse(null))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Matched route is not a supported media type: {}", (Object)contentType);
            }
            this.handleStatusError(ctx, request, nettyHttpRequest, (MutableHttpResponse<Object>)HttpResponse.status((HttpStatus)HttpStatus.UNSUPPORTED_MEDIA_TYPE), "Unsupported Media Type: " + contentType);
            return;
        }
        if (LOG.isDebugEnabled()) {
            if (route instanceof MethodBasedRouteMatch) {
                LOG.debug("Matched route {} - {} to controller {}", new Object[]{httpMethod, requestPath, route.getDeclaringType()});
            } else {
                LOG.debug("Matched route {} - {}", (Object)httpMethod, (Object)requestPath);
            }
        }
        if (!route.isAnnotationPresent(OnMessage.class) && !route.isAnnotationPresent(OnOpen.class)) {
            this.handleRouteMatch(route, nettyHttpRequest, ctx);
            return;
        }
        this.handleStatusError(ctx, request, nettyHttpRequest, (MutableHttpResponse<Object>)HttpResponse.status((HttpStatus)HttpStatus.BAD_REQUEST), "Not a WebSocket request");
    }

    private void handleStatusError(ChannelHandlerContext ctx, HttpRequest<?> request, NettyHttpRequest nettyHttpRequest, MutableHttpResponse<Object> defaultResponse, String message) {
        Optional statusRoute = this.router.route(defaultResponse.status());
        if (statusRoute.isPresent()) {
            RouteMatch routeMatch = (RouteMatch)statusRoute.get();
            this.handleRouteMatch(routeMatch, nettyHttpRequest, ctx);
        } else {
            if (HttpMethod.permitsRequestBody((HttpMethod)request.getMethod())) {
                JsonError error = this.newError(request, message);
                defaultResponse.body((Object)error);
            }
            AtomicReference requestReference = new AtomicReference(request);
            Flowable<? extends MutableHttpResponse<?>> responsePublisher = this.filterPublisher(requestReference, (Publisher<MutableHttpResponse<?>>)Flowable.just(defaultResponse), (ExecutorService)ctx.channel().eventLoop());
            this.subscribeToResponsePublisher(ctx, MediaType.APPLICATION_JSON_TYPE, requestReference, responsePublisher);
        }
    }

    private Optional<? extends FileCustomizableResponseType> matchFile(String path) {
        Optional optionalUrl = this.staticResourceResolver.resolve(path);
        if (optionalUrl.isPresent()) {
            try {
                File file;
                URL url = (URL)optionalUrl.get();
                if (url.getProtocol().equals("file") && (file = Paths.get(url.toURI()).toFile()).exists() && !file.isDirectory() && file.canRead()) {
                    return Optional.of(new NettySystemFileCustomizableResponseType(file));
                }
                return Optional.of(new NettyStreamedFileCustomizableResponseType(url));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private void emitDefaultNotFoundResponse(ChannelHandlerContext ctx, HttpRequest<?> request) {
        MutableHttpResponse<Object> res = this.newNotFoundError(request);
        AtomicReference requestReference = new AtomicReference(request);
        Flowable<? extends MutableHttpResponse<?>> responsePublisher = this.filterPublisher(requestReference, (Publisher<MutableHttpResponse<?>>)Flowable.just(res), (ExecutorService)ctx.channel().eventLoop());
        this.subscribeToResponsePublisher(ctx, MediaType.APPLICATION_JSON_TYPE, requestReference, responsePublisher);
    }

    private MutableHttpResponse<Object> newNotFoundError(HttpRequest<?> request) {
        JsonError error = this.newError(request, "Page Not Found");
        return HttpResponse.notFound().body((Object)error);
    }

    private JsonError newError(HttpRequest<?> request, String message) {
        URI uri = request.getUri();
        return (JsonError)new JsonError(message).link(Link.SELF, Link.of((URI)uri));
    }

    private MutableHttpResponse errorResultToResponse(Object result) {
        MutableHttpResponse response;
        if (result == null) {
            response = HttpResponse.serverError();
        } else if (result instanceof HttpResponse) {
            response = (MutableHttpResponse)result;
        } else {
            response = HttpResponse.serverError().body(result);
            MediaType.fromType(result.getClass()).ifPresent(arg_0 -> ((MutableHttpResponse)response).contentType(arg_0));
        }
        return response;
    }

    private void handleRouteMatch(RouteMatch<?> route, NettyHttpRequest<?> request, ChannelHandlerContext context) {
        request.setMatchedRoute(route);
        route = this.requestArgumentSatisfier.fulfillArgumentRequirements(route, request, false);
        request.setMatchedRoute(route);
        io.netty.handler.codec.http.HttpRequest nativeRequest = request.getNativeRequest();
        if (!route.isExecutable() && HttpMethod.permitsRequestBody((HttpMethod)request.getMethod()) && nativeRequest instanceof StreamedHttpRequest) {
            Optional contentType = request.getContentType();
            HttpContentProcessor processor = contentType.flatMap(type -> this.beanLocator.findBean(HttpContentSubscriberFactory.class, (Qualifier)new ConsumesMediaTypeQualifier(type))).map(factory -> factory.build(request)).orElse(new DefaultHttpContentProcessor(request, this.serverConfiguration));
            processor.subscribe(this.buildSubscriber(request, context, route));
        } else {
            context.read();
            route = this.prepareRouteForExecution(route, request);
            route.execute();
        }
    }

    private Subscriber<Object> buildSubscriber(final NettyHttpRequest request, final ChannelHandlerContext context, final RouteMatch<?> finalRoute) {
        return new CompletionAwareSubscriber<Object>(){
            RouteMatch<?> routeMatch;
            AtomicBoolean executed;
            ConcurrentHashMap<Integer, LongAdder> partPositions;
            ConcurrentHashMap<String, ReplaySubject> subjects;
            ConcurrentHashMap<Integer, ReplaySubject> childSubjects;
            ConcurrentHashMap<Integer, StreamingFileUpload> streamingUploads;
            ConversionService conversionService;
            Subscription s;
            {
                this.routeMatch = finalRoute;
                this.executed = new AtomicBoolean(false);
                this.partPositions = new ConcurrentHashMap();
                this.subjects = new ConcurrentHashMap();
                this.childSubjects = new ConcurrentHashMap();
                this.streamingUploads = new ConcurrentHashMap();
                this.conversionService = ConversionService.SHARED;
            }

            protected void doOnSubscribe(Subscription subscription) {
                this.s = subscription;
                subscription.request(1L);
            }

            protected void doOnNext(Object message) {
                boolean executed = this.executed.get();
                if (message instanceof ByteBufHolder) {
                    if (message instanceof HttpData) {
                        String name;
                        Optional requiredInput;
                        HttpData data = (HttpData)message;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Received HTTP Data for request [{}]: {}", (Object)request, message);
                        }
                        if ((requiredInput = this.routeMatch.getRequiredInput(name = data.getName())).isPresent()) {
                            String argumentName;
                            Supplier<Object> value;
                            Argument argument = (Argument)requiredInput.get();
                            if (Publishers.isConvertibleToPublisher((Class)argument.getType())) {
                                Optional converted;
                                Integer dataKey = System.identityHashCode(data);
                                Argument typeVariable = argument.getFirstTypeVariable().orElse(argument);
                                Class typeVariableType = typeVariable.getType();
                                ReplaySubject namedSubject = this.subjects.computeIfAbsent(name, key -> ReplaySubject.create());
                                if (Publishers.isConvertibleToPublisher((Class)typeVariableType)) {
                                    this.childSubjects.computeIfAbsent(dataKey, key -> {
                                        ReplaySubject childSubject = ReplaySubject.create();
                                        Flowable flowable = childSubject.toFlowable(BackpressureStrategy.BUFFER);
                                        if (StreamingFileUpload.class.isAssignableFrom(typeVariableType) && data instanceof FileUpload) {
                                            namedSubject.onNext((Object)new NettyStreamingFileUpload((FileUpload)data, RoutingInBoundHandler.this.serverConfiguration.getMultipart(), RoutingInBoundHandler.this.ioExecutor, flowable));
                                        } else {
                                            namedSubject.onNext((Object)flowable);
                                        }
                                        return childSubject;
                                    });
                                }
                                ReplaySubject subject = this.childSubjects.getOrDefault(dataKey, namedSubject);
                                if (data.refCnt() <= 1) {
                                    data.retain();
                                }
                                boolean partialUpload = true;
                                if (Publishers.isConvertibleToPublisher((Class)typeVariableType)) {
                                    typeVariable = typeVariable.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
                                } else if (StreamingFileUpload.class.isAssignableFrom(typeVariableType)) {
                                    typeVariable = Argument.of(PartData.class);
                                } else if (!ClassUtils.isJavaLangType((Class)typeVariableType)) {
                                    partialUpload = false;
                                }
                                Object part = data;
                                if (data instanceof FileUpload) {
                                    FileUpload fileUpload = (FileUpload)data;
                                    if (partialUpload) {
                                        this.partPositions.putIfAbsent(dataKey, new LongAdder());
                                        LongAdder position = this.partPositions.get(dataKey);
                                        position.add(fileUpload.length());
                                        part = new NettyPartData(fileUpload, position.longValue());
                                    }
                                    if (StreamingFileUpload.class.isAssignableFrom(argument.getType())) {
                                        this.streamingUploads.computeIfAbsent(dataKey, key -> new NettyStreamingFileUpload(fileUpload, RoutingInBoundHandler.this.serverConfiguration.getMultipart(), RoutingInBoundHandler.this.ioExecutor, subject.toFlowable(BackpressureStrategy.BUFFER)));
                                    }
                                }
                                if ((converted = this.conversionService.convert(part, typeVariable)).isPresent()) {
                                    subject.onNext(converted.get());
                                }
                                if (data.isCompleted() && partialUpload) {
                                    subject.onComplete();
                                }
                                value = () -> {
                                    if (this.streamingUploads.containsKey(dataKey)) {
                                        return this.streamingUploads.get(dataKey);
                                    }
                                    return namedSubject.toFlowable(BackpressureStrategy.BUFFER);
                                };
                            } else {
                                value = () -> {
                                    if (data.refCnt() > 0) {
                                        return data;
                                    }
                                    return null;
                                };
                            }
                            if (!executed && !this.routeMatch.isSatisfied(argumentName = argument.getName())) {
                                this.routeMatch = this.routeMatch.fulfill(Collections.singletonMap(argumentName, value.get()));
                            }
                        } else {
                            request.addContent((ByteBufHolder)data);
                            this.s.request(1L);
                        }
                    } else {
                        Optional body;
                        Argument argument;
                        String bodyArgumentName;
                        Optional bodyArgument;
                        request.addContent((ByteBufHolder)message);
                        if (!this.routeMatch.isExecutable() && message instanceof LastHttpContent && (bodyArgument = this.routeMatch.getBodyArgument()).isPresent() && this.routeMatch.isRequiredInput(bodyArgumentName = (argument = (Argument)bodyArgument.get()).getName()) && (body = request.getBody()).isPresent()) {
                            this.routeMatch = this.routeMatch.fulfill(Collections.singletonMap(bodyArgumentName, body.get()));
                        }
                    }
                } else {
                    request.setBody(message);
                }
                if (!executed) {
                    if (this.routeMatch.isExecutable() && this.subjects.isEmpty() && this.childSubjects.isEmpty() || message instanceof LastHttpContent) {
                        this.executeRoute();
                    } else {
                        this.s.request(1L);
                    }
                }
            }

            protected void doOnError(Throwable t) {
                try {
                    this.s.cancel();
                    RoutingInBoundHandler.this.exceptionCaught(context, t);
                }
                catch (Exception e) {
                    RoutingInBoundHandler.this.writeDefaultErrorResponse(context, request, e);
                }
            }

            protected void doOnComplete() {
                this.subjects.forEachValue(0L, subject -> {
                    if (!subject.hasComplete()) {
                        subject.onComplete();
                    }
                });
                this.executeRoute();
            }

            private void executeRoute() {
                if (this.executed.compareAndSet(false, true)) {
                    try {
                        this.routeMatch = RoutingInBoundHandler.this.prepareRouteForExecution(this.routeMatch, request);
                        this.routeMatch.execute();
                    }
                    catch (Exception e) {
                        context.pipeline().fireExceptionCaught((Throwable)e);
                    }
                }
            }
        };
    }

    private RouteMatch<?> prepareRouteForExecution(RouteMatch<?> route, NettyHttpRequest<?> request) {
        ChannelHandlerContext context = request.getChannelHandlerContext();
        Object executor = route instanceof MethodBasedRouteMatch ? (ExecutorService)this.executorSelector.select((MethodReference)((MethodBasedRouteMatch)route)).orElse(context.channel().eventLoop()) : context.channel().eventLoop();
        route = route.decorate(arg_0 -> this.lambda$prepareRouteForExecution$7(request, context, (ExecutorService)executor, arg_0));
        return route;
    }

    private Flowable<MutableHttpResponse<?>> buildRoutePublisher(Class<?> declaringType, Class<?> javaReturnType, AtomicReference<HttpRequest<?>> requestReference, Flowable<MutableHttpResponse<?>> routePublisher) {
        routePublisher = routePublisher.switchIfEmpty((Publisher)Flowable.create(emitter -> {
            Object response;
            HttpRequest httpRequest = (HttpRequest)requestReference.get();
            if (javaReturnType != Void.TYPE) {
                Optional statusRoute = Optional.empty();
                if (declaringType != null) {
                    statusRoute = this.router.route(declaringType, HttpStatus.NOT_FOUND);
                }
                if (!statusRoute.isPresent()) {
                    statusRoute = this.router.route(HttpStatus.NOT_FOUND);
                }
                if (statusRoute.isPresent()) {
                    RouteMatch newRoute = (RouteMatch)statusRoute.get();
                    this.requestArgumentSatisfier.fulfillArgumentRequirements(newRoute, httpRequest, true);
                    if (newRoute.isExecutable()) {
                        try {
                            Object result = newRoute.execute();
                            response = this.messageToResponse(newRoute, result);
                        }
                        catch (Throwable e) {
                            emitter.onError((Throwable)new InternalServerException("Error executing status route [" + newRoute + "]: " + e.getMessage(), e));
                            return;
                        }
                    } else {
                        response = this.newNotFoundError(httpRequest);
                    }
                    response.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, (Object)statusRoute);
                } else {
                    response = this.newNotFoundError(httpRequest);
                }
            } else {
                response = HttpResponse.ok();
            }
            try {
                emitter.onNext(response);
                emitter.onComplete();
            }
            catch (Throwable e) {
                emitter.onError((Throwable)new InternalServerException("Error executing Error route [" + response.getStatus() + "]: " + e.getMessage(), e));
            }
        }, (BackpressureStrategy)BackpressureStrategy.ERROR));
        return routePublisher;
    }

    private void subscribeToResponsePublisher(final ChannelHandlerContext context, MediaType defaultResponseMediaType, final AtomicReference<HttpRequest<?>> requestReference, Flowable<? extends MutableHttpResponse<?>> finalPublisher) {
        finalPublisher = finalPublisher.map(response -> {
            Optional specifiedMediaType = response.getContentType();
            MediaType responseMediaType = specifiedMediaType.orElse(defaultResponseMediaType);
            this.applyConfiguredHeaders(response.getHeaders());
            Optional responseBody = response.getBody();
            if (responseBody.isPresent()) {
                Optional registeredCodec;
                Object body = responseBody.get();
                Optional<NettyCustomizableResponseTypeHandler> typeHandler = this.customizableResponseTypeHandlerRegistry.findTypeHandler(body.getClass());
                if (typeHandler.isPresent()) {
                    NettyCustomizableResponseTypeHandler th = typeHandler.get();
                    this.setBodyContent((MutableHttpResponse)response, new NettyCustomizableResponseTypeHandlerInvoker(th, body));
                    return response;
                }
                if (specifiedMediaType.isPresent() && (registeredCodec = this.mediaTypeCodecRegistry.findCodec(responseMediaType, body.getClass())).isPresent()) {
                    MediaTypeCodec codec = (MediaTypeCodec)registeredCodec.get();
                    return this.encodeBodyWithCodec((MutableHttpResponse<?>)response, body, codec, responseMediaType, context, requestReference);
                }
                registeredCodec = this.mediaTypeCodecRegistry.findCodec(defaultResponseMediaType, body.getClass());
                if (registeredCodec.isPresent()) {
                    MediaTypeCodec codec = (MediaTypeCodec)registeredCodec.get();
                    return this.encodeBodyWithCodec((MutableHttpResponse<?>)response, body, codec, responseMediaType, context, requestReference);
                }
                TextPlainCodec defaultCodec = new TextPlainCodec(this.serverConfiguration.getDefaultCharset());
                return this.encodeBodyWithCodec((MutableHttpResponse<?>)response, body, (MediaTypeCodec)defaultCodec, responseMediaType, context, requestReference);
            }
            return response;
        });
        finalPublisher.subscribe((Subscriber)new ContextCompletionAwareSubscriber<MutableHttpResponse<?>>(context){

            @Override
            protected void onComplete(MutableHttpResponse<?> message) {
                RoutingInBoundHandler.this.writeFinalNettyResponse(message, requestReference, context);
            }

            @Override
            protected void doOnError(Throwable t) {
                super.doOnError(t);
            }
        });
    }

    private void writeFinalNettyResponse(MutableHttpResponse<?> message, AtomicReference<HttpRequest<?>> requestReference, ChannelHandlerContext context) {
        Optional customizableTypeBody;
        NettyMutableHttpResponse nettyHttpResponse = (NettyMutableHttpResponse)message;
        FullHttpResponse nettyResponse = nettyHttpResponse.getNativeResponse();
        HttpRequest<?> httpRequest = requestReference.get();
        HttpHeaders nettyHeaders = nettyResponse.headers();
        if (!nettyHeaders.contains((CharSequence)HttpHeaderNames.CONNECTION)) {
            HttpStatus status = nettyHttpResponse.status();
            if (status.getCode() > 299 || !httpRequest.getHeaders().isKeepAlive()) {
                nettyHeaders.add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            } else {
                nettyHeaders.add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            }
        }
        if (!nettyHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) && !nettyHeaders.contains((CharSequence)HttpHeaderNames.TRANSFER_ENCODING)) {
            nettyHeaders.add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        }
        if ((customizableTypeBody = message.getBody(NettyCustomizableResponseTypeHandlerInvoker.class)).isPresent()) {
            NettyCustomizableResponseTypeHandlerInvoker handler = (NettyCustomizableResponseTypeHandlerInvoker)customizableTypeBody.get();
            handler.invoke(httpRequest, nettyHttpResponse, context);
        } else {
            context.writeAndFlush((Object)nettyResponse);
            context.read();
        }
    }

    private MutableHttpResponse<?> encodeBodyWithCodec(MutableHttpResponse<?> response, Object body, MediaTypeCodec codec, MediaType mediaType, ChannelHandlerContext context, AtomicReference<HttpRequest<?>> requestReference) {
        ByteBuf byteBuf = this.encodeBodyAsByteBuf(body, codec, context, requestReference);
        int len = byteBuf.readableBytes();
        MutableHttpHeaders headers = response.getHeaders();
        if (!headers.contains("Content-Type")) {
            headers.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)mediaType);
        }
        headers.remove((CharSequence)"Content-Length");
        headers.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(len));
        this.setBodyContent(response, byteBuf);
        return response;
    }

    private MutableHttpResponse<?> setBodyContent(MutableHttpResponse response, Object bodyContent) {
        MutableHttpResponse res = response.body(bodyContent);
        return res;
    }

    private ByteBuf encodeBodyAsByteBuf(Object body, MediaTypeCodec codec, ChannelHandlerContext context, AtomicReference<HttpRequest<?>> requestReference) {
        ByteBuf byteBuf;
        if (body instanceof ByteBuf) {
            byteBuf = (ByteBuf)body;
        } else if (body instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)body;
            Object nativeBuffer = byteBuffer.asNativeBuffer();
            byteBuf = nativeBuffer instanceof ByteBuf ? (ByteBuf)nativeBuffer : Unpooled.wrappedBuffer((java.nio.ByteBuffer)byteBuffer.asNioBuffer());
        } else if (body instanceof byte[]) {
            byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])body));
        } else if (body instanceof Writable) {
            byteBuf = context.alloc().ioBuffer(128);
            ByteBufOutputStream outputStream = new ByteBufOutputStream(byteBuf);
            Writable writable = (Writable)body;
            try {
                writable.writeTo((OutputStream)outputStream, requestReference.get().getCharacterEncoding());
            }
            catch (IOException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(e.getMessage());
                }
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Encoding emitted response object [{}] using codec: {}", body, (Object)codec);
            }
            byteBuf = (ByteBuf)codec.encode(body, (ByteBufferFactory)new NettyByteBufferFactory(context.alloc())).asNativeBuffer();
        }
        return byteBuf;
    }

    private Flowable<?> buildResultEmitter(ChannelHandlerContext context, RouteMatch<?> finalRoute, AtomicReference<HttpRequest<?>> requestReference, boolean isReactiveReturnType, boolean isSingleResult) {
        Flowable resultEmitter;
        block5: {
            if (isReactiveReturnType) {
                try {
                    if (isSingleResult) {
                        resultEmitter = Flowable.defer(() -> {
                            RouteMatch routeMatch = !finalRoute.isExecutable() ? this.requestArgumentSatisfier.fulfillArgumentRequirements(finalRoute, (HttpRequest)requestReference.get(), true) : finalRoute;
                            Object result = routeMatch.execute();
                            return (Publisher)Publishers.convertPublisher((Object)result, Publisher.class);
                        });
                        break block5;
                    }
                    resultEmitter = Flowable.create(emitter -> {
                        RouteMatch routeMatch = !finalRoute.isExecutable() ? this.requestArgumentSatisfier.fulfillArgumentRequirements(finalRoute, (HttpRequest)requestReference.get(), true) : finalRoute;
                        Object result = routeMatch.execute();
                        MutableHttpResponse chunkedResponse = HttpResponse.ok((Object)result);
                        chunkedResponse.header((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (CharSequence)HttpHeaderValues.CHUNKED);
                        emitter.onNext((Object)chunkedResponse);
                        emitter.onComplete();
                    }, (BackpressureStrategy)BackpressureStrategy.ERROR);
                }
                catch (Throwable e) {
                    resultEmitter = Flowable.error((Throwable)new InternalServerException("Error executing route [" + finalRoute + "]: " + e.getMessage(), e));
                }
            } else {
                resultEmitter = Flowable.create(emitter -> {
                    Object result;
                    HttpRequest httpRequest = (HttpRequest)requestReference.get();
                    RouteMatch routeMatch = finalRoute;
                    if (!routeMatch.isExecutable()) {
                        routeMatch = this.requestArgumentSatisfier.fulfillArgumentRequirements(routeMatch, httpRequest, true);
                    }
                    try {
                        result = routeMatch.execute();
                    }
                    catch (Throwable e) {
                        emitter.onError(e);
                        return;
                    }
                    if (result == null || result instanceof Optional && !((Optional)result).isPresent()) {
                        emitter.onComplete();
                    } else {
                        if (result instanceof Writable) {
                            ByteBuf byteBuf = context.alloc().ioBuffer(128);
                            ByteBufOutputStream outputStream = new ByteBufOutputStream(byteBuf);
                            Writable writable = (Writable)result;
                            writable.writeTo((OutputStream)outputStream, ((HttpRequest)requestReference.get()).getCharacterEncoding());
                            emitter.onNext((Object)byteBuf);
                        } else {
                            emitter.onNext(result);
                        }
                        emitter.onComplete();
                    }
                }, (BackpressureStrategy)BackpressureStrategy.ERROR);
            }
        }
        return resultEmitter;
    }

    private MutableHttpResponse<?> messageToResponse(RouteMatch<?> finalRoute, Object message) {
        MutableHttpResponse response;
        if (message instanceof HttpResponse) {
            response = (MutableHttpResponse)ConversionService.SHARED.convert(message, NettyMutableHttpResponse.class).orElseThrow(() -> new InternalServerException("Emitted response is not mutable"));
        } else if (message instanceof HttpStatus) {
            response = HttpResponse.status((HttpStatus)((HttpStatus)message));
        } else {
            MethodBasedRouteMatch rm;
            HttpStatus status = HttpStatus.OK;
            if (finalRoute instanceof MethodBasedRouteMatch && (rm = (MethodBasedRouteMatch)finalRoute).hasAnnotation(Status.class)) {
                status = rm.getValue(Status.class, HttpStatus.class).orElse(null);
            }
            response = status != null ? HttpResponse.status((HttpStatus)status).body(message) : HttpResponse.ok((Object)message);
        }
        return response;
    }

    private boolean isResponsePublisher(ReturnType<?> genericReturnType, Class<?> javaReturnType) {
        return Publishers.isConvertibleToPublisher(javaReturnType) && genericReturnType.getFirstTypeVariable().map(arg -> HttpResponse.class.isAssignableFrom(arg.getType())).orElse(false) != false;
    }

    private Flowable<? extends MutableHttpResponse<?>> filterPublisher(final AtomicReference<HttpRequest<?>> requestReference, Publisher<MutableHttpResponse<?>> routePublisher, ExecutorService executor) {
        Publisher finalPublisher;
        final ArrayList<HttpServerFilter> filters = new ArrayList<HttpServerFilter>(this.router.findFilters(requestReference.get()));
        if (!filters.isEmpty()) {
            Publisher resultingPublisher;
            filters.add((req, chain) -> routePublisher);
            final AtomicInteger integer = new AtomicInteger();
            final int len = filters.size();
            ServerFilterChain filterChain = new ServerFilterChain(){

                public Publisher<MutableHttpResponse<?>> proceed(HttpRequest<?> request) {
                    int pos = integer.incrementAndGet();
                    if (pos > len) {
                        throw new IllegalStateException("The FilterChain.proceed(..) method should be invoked exactly once per filter execution. The method has instead been invoked multiple times by an erroneous filter definition.");
                    }
                    HttpFilter httpFilter = (HttpFilter)filters.get(pos);
                    return httpFilter.doFilter(requestReference.getAndSet(request), (FilterChain)this);
                }
            };
            HttpFilter httpFilter = (HttpFilter)filters.get(0);
            finalPublisher = resultingPublisher = httpFilter.doFilter(requestReference.get(), (FilterChain)filterChain);
        } else {
            finalPublisher = routePublisher;
        }
        if (finalPublisher instanceof Flowable) {
            return ((Flowable)finalPublisher).subscribeOn(Schedulers.from((Executor)executor));
        }
        return Flowable.fromPublisher(finalPublisher).subscribeOn(Schedulers.from((Executor)executor));
    }

    private void streamHttpContentChunkByChunk(ChannelHandlerContext context, NettyHttpRequest<?> request, FullHttpResponse nativeResponse, final MediaType mediaType, Publisher<Object> publisher) {
        final NettyByteBufferFactory byteBufferFactory = new NettyByteBufferFactory(context.alloc());
        final boolean isJson = mediaType.getExtension().equals("json");
        Publisher httpContentPublisher = Publishers.map(publisher, (Function)new Function<Object, HttpContent>(){
            boolean first = true;

            @Override
            public HttpContent apply(Object message) {
                DefaultHttpContent httpContent;
                if (message instanceof ByteBuf) {
                    httpContent = new DefaultHttpContent((ByteBuf)message);
                } else if (message instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)message;
                    Object nativeBuffer = byteBuffer.asNativeBuffer();
                    httpContent = nativeBuffer instanceof ByteBuf ? new DefaultHttpContent((ByteBuf)nativeBuffer) : new DefaultHttpContent(Unpooled.copiedBuffer((java.nio.ByteBuffer)byteBuffer.asNioBuffer()));
                } else if (message instanceof byte[]) {
                    httpContent = new DefaultHttpContent(Unpooled.copiedBuffer((byte[])((byte[])message)));
                } else if (message instanceof HttpContent) {
                    httpContent = (HttpContent)message;
                } else {
                    MediaTypeCodec codec = (MediaTypeCodec)RoutingInBoundHandler.this.mediaTypeCodecRegistry.findCodec(mediaType, message.getClass()).orElse(new TextPlainCodec(RoutingInBoundHandler.this.serverConfiguration.getDefaultCharset()));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Encoding emitted response object [{}] using codec: {}", message, (Object)codec);
                    }
                    ByteBuffer encoded = codec.encode(message, (ByteBufferFactory)byteBufferFactory);
                    httpContent = new DefaultHttpContent((ByteBuf)encoded.asNativeBuffer());
                }
                if (!isJson || this.first) {
                    this.first = false;
                    return httpContent;
                }
                return HttpContentUtil.prefixComma((HttpContent)httpContent);
            }
        });
        if (isJson && !Publishers.isSingle(publisher.getClass())) {
            httpContentPublisher = Flowable.concat((Publisher)Flowable.fromCallable(HttpContentUtil::openBracket), (Publisher)httpContentPublisher, (Publisher)Flowable.fromCallable(HttpContentUtil::closeBracket));
        }
        if (mediaType.equals((Object)MediaType.TEXT_EVENT_STREAM_TYPE)) {
            httpContentPublisher = Publishers.onComplete((Publisher)httpContentPublisher, () -> {
                CompletableFuture future = new CompletableFuture();
                if ((request == null || !request.getHeaders().isKeepAlive()) && context.channel().isOpen()) {
                    context.pipeline().writeAndFlush((Object)new DefaultLastHttpContent()).addListener(f -> {
                        if (f.isSuccess()) {
                            future.complete(null);
                        } else {
                            future.completeExceptionally(f.cause());
                        }
                    });
                }
                return future;
            });
        }
        httpContentPublisher = Publishers.then((Publisher)httpContentPublisher, httpContent -> context.read());
        DelegateStreamedHttpResponse streamedResponse = new DelegateStreamedHttpResponse((io.netty.handler.codec.http.HttpResponse)nativeResponse, (Publisher<HttpContent>)httpContentPublisher);
        HttpHeaders headers = streamedResponse.headers();
        headers.add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        headers.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mediaType);
        context.writeAndFlush((Object)streamedResponse);
        context.read();
    }

    private void writeDefaultErrorResponse(ChannelHandlerContext ctx, NettyHttpRequest nettyHttpRequest, Throwable cause) {
        this.logException(cause);
        MutableHttpResponse error = HttpResponse.serverError().body((Object)new JsonError("Internal Server Error: " + cause.getMessage()));
        this.subscribeToResponsePublisher(ctx, MediaType.APPLICATION_JSON_TYPE, new AtomicReference(nettyHttpRequest), Flowable.just((Object)error));
    }

    private void logException(Throwable cause) {
        if (cause instanceof IOException && IGNORABLE_ERROR_MESSAGE.matcher(cause.getMessage()).matches()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Swallowed an IOException caused by client connectivity: " + cause.getMessage(), cause);
            }
        } else if (LOG.isErrorEnabled()) {
            LOG.error("Unexpected error occurred: " + cause.getMessage(), cause);
        }
    }

    private void applyConfiguredHeaders(MutableHttpHeaders headers) {
        if (this.serverConfiguration.isDateHeader() && !headers.contains("Date")) {
            headers.date(LocalDateTime.now());
        }
        this.serverConfiguration.getServerHeader().ifPresent(server -> {
            if (!headers.contains("Server")) {
                headers.add((CharSequence)"Server", (CharSequence)server);
            }
        });
    }

    private /* synthetic */ Object lambda$prepareRouteForExecution$7(final NettyHttpRequest request, final ChannelHandlerContext context, ExecutorService executor, RouteMatch finalRoute) {
        Optional generic;
        boolean isStreaming;
        final MediaType defaultResponseMediaType = finalRoute.getProduces().stream().findFirst().orElse(MediaType.APPLICATION_JSON_TYPE);
        ReturnType genericReturnType = finalRoute.getReturnType();
        Class javaReturnType = genericReturnType.getType();
        AtomicReference requestReference = new AtomicReference(request);
        boolean isFuture = CompletableFuture.class.isAssignableFrom(javaReturnType);
        boolean isReactiveReturnType = Publishers.isConvertibleToPublisher((Class)javaReturnType) || isFuture;
        boolean isSingle = isReactiveReturnType && Publishers.isSingle((Class)javaReturnType) || this.isResponsePublisher(genericReturnType, javaReturnType) || isFuture || finalRoute.getAnnotationMetadata().getValue(Produces.class, "single", Boolean.class).orElse(false) != false;
        Flowable<?> resultEmitter = this.buildResultEmitter(context, finalRoute, requestReference, isReactiveReturnType, isSingle);
        Flowable<MutableHttpResponse<?>> routePublisher = resultEmitter.map(message -> {
            RouteMatch routeMatch = finalRoute;
            MutableHttpResponse<?> response = this.messageToResponse(routeMatch, message);
            MutableHttpResponse<?> finalResponse = response;
            HttpStatus status = finalResponse.getStatus();
            if (status.getCode() >= HttpStatus.BAD_REQUEST.getCode()) {
                Class declaringType = ((MethodBasedRouteMatch)routeMatch).getDeclaringType();
                Optional statusRoute = Optional.empty();
                if (declaringType != null) {
                    statusRoute = this.router.route(declaringType, status);
                }
                if (!statusRoute.isPresent()) {
                    statusRoute = this.router.route(status);
                }
                HttpRequest httpRequest = (HttpRequest)requestReference.get();
                if (statusRoute.isPresent()) {
                    routeMatch = (RouteMatch)statusRoute.get();
                    httpRequest.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, (Object)routeMatch);
                    this.requestArgumentSatisfier.fulfillArgumentRequirements(routeMatch, httpRequest, true);
                    if (routeMatch.isExecutable()) {
                        try {
                            Object result = routeMatch.execute();
                            finalResponse = this.messageToResponse(routeMatch, result);
                        }
                        catch (Throwable e) {
                            throw new InternalServerException("Error executing status route [" + routeMatch + "]: " + e.getMessage(), e);
                        }
                    }
                }
            }
            finalResponse.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, (Object)routeMatch);
            return finalResponse;
        });
        routePublisher = this.buildRoutePublisher(finalRoute.getDeclaringType(), javaReturnType, requestReference, routePublisher);
        Flowable filteredPublisher = this.filterPublisher(requestReference, (Publisher<MutableHttpResponse<?>>)routePublisher, executor);
        boolean bl = isStreaming = isReactiveReturnType && !isSingle;
        if (!isStreaming && HttpResponse.class.isAssignableFrom(javaReturnType) && (generic = genericReturnType.getFirstTypeVariable()).isPresent()) {
            Class genericType = ((Argument)generic.get()).getType();
            isStreaming = Publishers.isConvertibleToPublisher((Class)genericType) && !Publishers.isSingle((Class)genericType);
        }
        boolean finalIsStreaming = isStreaming;
        filteredPublisher = filteredPublisher.switchMap(response -> {
            Optional responseBody = response.getBody();
            if (responseBody.isPresent()) {
                Object body = responseBody.get();
                if (finalIsStreaming) {
                    return Flowable.just((Object)response);
                }
                if (Publishers.isConvertibleToPublisher(body)) {
                    Flowable bodyFlowable = (Flowable)Publishers.convertPublisher(body, Flowable.class);
                    Flowable bodyToResponse = bodyFlowable.map(bodyContent -> this.setBodyContent((MutableHttpResponse)response, bodyContent));
                    return bodyToResponse.switchIfEmpty((Publisher)Flowable.just((Object)response));
                }
            }
            return Flowable.just((Object)response);
        });
        if (!isStreaming) {
            this.subscribeToResponsePublisher(context, defaultResponseMediaType, requestReference, filteredPublisher);
        } else {
            filteredPublisher.subscribe((Subscriber)new ContextCompletionAwareSubscriber<MutableHttpResponse<?>>(context){

                @Override
                protected void onComplete(MutableHttpResponse<?> response) {
                    Optional responseBody = response.getBody();
                    Flowable bodyFlowable = responseBody.map(o -> (Flowable)Publishers.convertPublisher((Object)o, Flowable.class)).orElse(Flowable.empty());
                    NettyMutableHttpResponse nettyHttpResponse = (NettyMutableHttpResponse)response;
                    FullHttpResponse nettyResponse = nettyHttpResponse.getNativeResponse();
                    Optional specifiedMediaType = response.getContentType();
                    MediaType responseMediaType = specifiedMediaType.orElse(defaultResponseMediaType);
                    RoutingInBoundHandler.this.applyConfiguredHeaders(response.getHeaders());
                    RoutingInBoundHandler.this.streamHttpContentChunkByChunk(context, request, nettyResponse, responseMediaType, (Publisher<Object>)((Publisher)bodyFlowable));
                }
            });
        }
        return null;
    }

    private static class NettyCustomizableResponseTypeHandlerInvoker {
        final NettyCustomizableResponseTypeHandler handler;
        final Object body;

        NettyCustomizableResponseTypeHandlerInvoker(NettyCustomizableResponseTypeHandler handler, Object body) {
            this.handler = handler;
            this.body = body;
        }

        void invoke(HttpRequest<?> request, NettyMutableHttpResponse response, ChannelHandlerContext channelHandlerContext) {
            this.handler.handle(this.body, request, response, channelHandlerContext);
        }
    }
}

