/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.sdk.v2.service;

import io.micronaut.aws.sdk.v2.service.AWSServiceConfiguration;
import io.micronaut.aws.ua.UserAgentProvider;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Inject;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.client.builder.SdkClientBuilder;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.providers.AwsRegionProviderChain;
import software.amazon.awssdk.utils.builder.SdkBuilder;

public abstract class AwsClientFactory<SB extends AwsSyncClientBuilder<SB, SC> & AwsClientBuilder<SB, SC>, AB extends AwsAsyncClientBuilder<AB, AC> & AwsClientBuilder<AB, AC>, SC, AC extends SdkClient> {
    private static final Logger LOG = LoggerFactory.getLogger(AwsClientFactory.class);
    protected final AwsCredentialsProviderChain credentialsProvider;
    protected final AwsRegionProviderChain regionProvider;
    @Nullable
    protected final AWSServiceConfiguration configuration;
    @Nullable
    protected final UserAgentProvider userAgentProvider;

    @Deprecated
    protected AwsClientFactory(AwsCredentialsProviderChain credentialsProvider, AwsRegionProviderChain regionProvider) {
        this(credentialsProvider, regionProvider, null, null);
    }

    @Deprecated
    protected AwsClientFactory(AwsCredentialsProviderChain credentialsProvider, AwsRegionProviderChain regionProvider, @Nullable UserAgentProvider userAgentProvider) {
        this(credentialsProvider, regionProvider, null, null);
    }

    @Inject
    protected AwsClientFactory(AwsCredentialsProviderChain credentialsProvider, AwsRegionProviderChain regionProvider, @Nullable UserAgentProvider userAgentProvider, @Nullable AWSServiceConfiguration configuration) {
        this.credentialsProvider = credentialsProvider;
        this.regionProvider = regionProvider;
        this.userAgentProvider = userAgentProvider;
        this.configuration = configuration;
    }

    public SB syncBuilder(SdkHttpClient httpClient) {
        AwsSyncClientBuilder sb = (AwsSyncClientBuilder)((SdkClientBuilder)((AwsSyncClientBuilder)((AwsClientBuilder)((AwsSyncClientBuilder)((AwsClientBuilder)((AwsSyncClientBuilder)this.createSyncBuilder().httpClient(httpClient))).region(this.regionProvider.getRegion()))).credentialsProvider((AwsCredentialsProvider)this.credentialsProvider))).overrideConfiguration(conf -> {
            if (this.userAgentProvider != null) {
                String ua = this.userAgentProvider.userAgent();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Setting User-Agent for AWS SDK to {}", (Object)ua);
                }
                conf.putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_SUFFIX, (Object)ua);
            }
        });
        Optional.ofNullable(this.configuration).flatMap(cfg -> Optional.ofNullable(cfg.getEndpointOverride())).ifPresent(o -> ((SdkClientBuilder)sb).endpointOverride(o));
        return (SB)sb;
    }

    public SC syncClient(SB builder) {
        return (SC)((SdkBuilder)builder).build();
    }

    public AB asyncBuilder(SdkAsyncHttpClient httpClient) {
        AwsAsyncClientBuilder ab = (AwsAsyncClientBuilder)((SdkClientBuilder)((AwsAsyncClientBuilder)((AwsClientBuilder)((AwsAsyncClientBuilder)((AwsClientBuilder)((AwsAsyncClientBuilder)this.createAsyncBuilder().httpClient(httpClient))).region(this.regionProvider.getRegion()))).credentialsProvider((AwsCredentialsProvider)this.credentialsProvider))).overrideConfiguration(conf -> {
            if (this.userAgentProvider != null) {
                String ua = this.userAgentProvider.userAgent();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Setting User-Agent for AWS SDK to {}", (Object)ua);
                }
                conf.putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_SUFFIX, (Object)ua);
            }
        });
        Optional.ofNullable(this.configuration).flatMap(cfg -> Optional.ofNullable(cfg.getEndpointOverride())).ifPresent(o -> ((SdkClientBuilder)ab).endpointOverride(o));
        return (AB)ab;
    }

    public AC asyncClient(AB builder) {
        return (AC)((SdkClient)((SdkBuilder)builder).build());
    }

    protected abstract SB createSyncBuilder();

    protected abstract AB createAsyncBuilder();
}

