/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aws.sdk.v2;

import io.micronaut.context.env.Environment;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.utils.StringUtils;

public final class EnvironmentAwsCredentialsProvider
implements AwsCredentialsProvider {
    public static final String ACCESS_KEY_ENV_VAR = "aws.access-key-id";
    public static final String ALTERNATE_ACCESS_KEY_ENV_VAR = "aws.access-key";
    public static final String SECRET_KEY_ENV_VAR = "aws.secret-key";
    public static final String ALTERNATE_SECRET_KEY_ENV_VAR = "aws.secret-access-key";
    public static final String AWS_SESSION_TOKEN_ENV_VAR = "aws.session-token";
    private final Environment environment;

    private EnvironmentAwsCredentialsProvider(Environment environment) {
        this.environment = environment;
    }

    public static EnvironmentAwsCredentialsProvider create(Environment environment) {
        return new EnvironmentAwsCredentialsProvider(environment);
    }

    public AwsCredentials resolveCredentials() {
        String accessKey = (String)this.environment.getProperty(ACCESS_KEY_ENV_VAR, String.class, (Object)((String)this.environment.getProperty(ALTERNATE_ACCESS_KEY_ENV_VAR, String.class, (Object)null)));
        String secretKey = (String)this.environment.getProperty(SECRET_KEY_ENV_VAR, String.class, (Object)((String)this.environment.getProperty(ALTERNATE_SECRET_KEY_ENV_VAR, String.class, (Object)null)));
        accessKey = StringUtils.trim((String)accessKey);
        secretKey = StringUtils.trim((String)secretKey);
        String sessionToken = StringUtils.trim((String)((String)this.environment.getProperty(AWS_SESSION_TOKEN_ENV_VAR, String.class, (Object)null)));
        if (StringUtils.isBlank((CharSequence)accessKey) || StringUtils.isBlank((CharSequence)secretKey)) {
            throw SdkClientException.create((String)"Unable to load AWS credentials from environment (aws.access-key-id (or aws.access-key) and aws.secret-key (or aws.secret-access-key))");
        }
        return sessionToken == null ? AwsBasicCredentials.create((String)accessKey, (String)secretKey) : AwsSessionCredentials.create((String)accessKey, (String)secretKey, (String)sessionToken);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

