/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.std.sourcegen;

import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.codegen.AbstractCodeGenerator;
import io.micronaut.aot.std.sourcegen.MapPropertySourceGenerator;
import io.micronaut.context.env.MapPropertySource;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.env.yaml.YamlPropertySourceLoader;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.scan.DefaultClassPathResourceLoader;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AOTModule(id="yaml.to.java.config", description="Converts YAML configuration files to Java configuration")
public class YamlPropertySourceGenerator
extends AbstractCodeGenerator {
    public static final String ID = "yaml.to.java.config";
    public static final String DESCRIPTION = "Converts YAML configuration files to Java configuration";
    private static final Logger LOGGER = LoggerFactory.getLogger(YamlPropertySourceGenerator.class);
    private final Collection<String> resources;

    public YamlPropertySourceGenerator(Collection<String> resources) {
        this.resources = resources;
    }

    public void generate(@NonNull AOTContext context) {
        YamlPropertySourceLoader loader = new YamlPropertySourceLoader();
        for (String resource : this.resources) {
            this.createMapProperty(loader, context, resource);
        }
    }

    private void createMapProperty(YamlPropertySourceLoader loader, AOTContext context, String resource) {
        Optional optionalSource = loader.load(resource, (ResourceLoader)new DefaultClassPathResourceLoader(((Object)((Object)this)).getClass().getClassLoader()));
        if (optionalSource.isPresent()) {
            LOGGER.info("Converting {} into Java based configuration", (Object)(resource + ".yml"));
            context.registerExcludedResource(resource + ".yml");
            context.registerExcludedResource(resource + ".yaml");
            PropertySource ps = (PropertySource)optionalSource.get();
            if (ps instanceof MapPropertySource) {
                MapPropertySource mps = (MapPropertySource)ps;
                Map values = mps.asMap();
                MapPropertySourceGenerator generator = new MapPropertySourceGenerator(resource, values);
                generator.generate(context);
            } else {
                throw new UnsupportedOperationException("Unknown property source type:" + ps.getClass());
            }
        }
    }
}

