/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.std.sourcegen;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.Option;
import io.micronaut.aot.core.codegen.AbstractCodeGenerator;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.ApplicationContextConfigurer;
import io.micronaut.core.annotation.NonNull;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.lang.model.element.Modifier;

@AOTModule(id="netty.properties", description="Defines some Netty system properties when starting the application which optimize startup times.", options={@Option(key="netty.machine.id", description="The machine id used by Netty. By default, generates a random value at runtime. Set it to a fixed MAC address to override, or use the value 'netty' to disable the optimization and get it at runtime.", sampleValue="random"), @Option(key="netty.process.id", description="The process id to use for Netty. Defaults to a random PID at runtime. Set it to a fixed value (not recommended) or use the value 'netty' to disable the optimization and get it at runtime.", sampleValue="random")})
public class NettyPropertiesSourceGenerator
extends AbstractCodeGenerator {
    public static final String GENERATED_CLASS = "NettyPropertiesAOTContextConfigurer";
    public static final String ID = "netty.properties";
    public static final String DESCRIPTION = "Defines some Netty system properties when starting the application which optimize startup times.";
    public static final String MACHINE_ID = "netty.machine.id";
    public static final String MACHINE_ID_DESCRIPTION = "The machine id used by Netty. By default, generates a random value at runtime. Set it to a fixed MAC address to override, or use the value 'netty' to disable the optimization and get it at runtime.";
    public static final String PROCESS_ID = "netty.process.id";
    public static final String PROCESS_ID_DESCRIPTION = "The process id to use for Netty. Defaults to a random PID at runtime. Set it to a fixed value (not recommended) or use the value 'netty' to disable the optimization and get it at runtime.";
    private static final String RANDOM_VALUE = "random";
    private static final String DEFAULT_NETTY_BEHAVIOR = "netty";

    public void generate(@NonNull AOTContext context) {
        context.registerGeneratedSourceFile(context.javaFile(this.buildConfigurer(context)));
        context.registerServiceImplementation(ApplicationContextConfigurer.class, GENERATED_CLASS);
    }

    private TypeSpec buildConfigurer(AOTContext context) {
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)GENERATED_CLASS).addSuperinterface(ApplicationContextConfigurer.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder configure = MethodSpec.methodBuilder((String)"configure").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(ApplicationContextBuilder.class, "builder", new Modifier[0]);
        NettyPropertiesSourceGenerator.ifOptimizationEnabled(NettyPropertiesSourceGenerator.machineIdOptionOf(context), machineId -> NettyPropertiesSourceGenerator.defineSystemProperty(classBuilder, configure, "io.netty.machineId", machineId, () -> MethodSpec.methodBuilder((String)"randomMacAddress").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns(String.class).addCode(CodeBlock.builder().addStatement("$T rnd = new $T()", new Object[]{Random.class, Random.class}).addStatement("$T sb = new $T()", new Object[]{StringBuilder.class, StringBuilder.class}).beginControlFlow("for (int i = 0; i < 6; i++)", new Object[0]).addStatement("sb.append(String.format(\"%02x\", rnd.nextInt(256)))", new Object[0]).beginControlFlow("if (i < 5)", new Object[0]).addStatement("sb.append(\":\")", new Object[0]).endControlFlow().endControlFlow().addStatement("return sb.toString()", new Object[0]).build()).build()));
        NettyPropertiesSourceGenerator.ifOptimizationEnabled(NettyPropertiesSourceGenerator.pidOf(context), pid -> NettyPropertiesSourceGenerator.defineSystemProperty(classBuilder, configure, "io.netty.processId", pid, () -> MethodSpec.methodBuilder((String)"randomPid").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns(String.class).addStatement("return String.valueOf(new Random().nextInt(65536))", new Object[0]).build()));
        return classBuilder.addMethod(configure.build()).build();
    }

    private static void ifOptimizationEnabled(String option, Consumer<? super String> consumer) {
        if (!DEFAULT_NETTY_BEHAVIOR.equals(option)) {
            consumer.accept(option);
        }
    }

    private static void defineSystemProperty(TypeSpec.Builder clazz, MethodSpec.Builder configure, String name, String value, Supplier<MethodSpec> randomizer) {
        if (RANDOM_VALUE.equals(value)) {
            MethodSpec methodSpec = randomizer.get();
            clazz.addMethod(methodSpec);
            configure.addStatement("System.setProperty($S, $L)", new Object[]{name, methodSpec.name + "()"});
        } else {
            configure.addStatement("System.setProperty($S, $S)", new Object[]{name, value});
        }
    }

    private static String pidOf(AOTContext context) {
        return context.getConfiguration().optionalString(PROCESS_ID, RANDOM_VALUE);
    }

    private static String machineIdOptionOf(AOTContext context) {
        return context.getConfiguration().optionalString(MACHINE_ID, RANDOM_VALUE);
    }
}

