/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.core.config;

import io.micronaut.aot.core.AOTCodeGenerator;
import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.Configuration;
import io.micronaut.aot.core.Runtime;
import io.micronaut.aot.core.config.MetadataUtils;
import io.micronaut.core.annotation.NonNull;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceGeneratorLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceGeneratorLoader.class);
    private static final Comparator<AOTModule> EXECUTION_ORDER = (first, second) -> {
        if (Arrays.asList(first.dependencies()).contains(second.id())) {
            return 1;
        }
        if (Arrays.asList(second.dependencies()).contains(first.id())) {
            return -1;
        }
        return first.id().compareTo(second.id());
    };

    @NonNull
    public static List<AOTCodeGenerator> load(Runtime runtime, AOTContext context) {
        Configuration configuration = context.getConfiguration();
        return SourceGeneratorLoader.sourceGeneratorStream().map(sg -> new Object((AOTCodeGenerator)sg){
            final AOTCodeGenerator generator;
            final AOTModule module;
            final /* synthetic */ AOTCodeGenerator val$sg;
            {
                this.val$sg = aOTCodeGenerator;
                this.generator = this.val$sg;
                this.module = MetadataUtils.findMetadata(this.val$sg.getClass()).orElse(null);
            }
        }).filter(sg -> {
            if (sg.module != null) {
                boolean isEnabledOnRuntime = MetadataUtils.isEnabledOn(runtime, sg.module);
                if (!isEnabledOnRuntime) {
                    LOGGER.debug("Skipping source generator {} as it is not enabled on runtime {}", (Object)sg.generator.getClass().getName(), (Object)runtime);
                    return false;
                }
                boolean isEnabledByConfiguration = configuration.isFeatureEnabled(sg.module.id());
                if (!isEnabledByConfiguration) {
                    LOGGER.debug("Skipping source generator {} as it is not enabled by configuration", (Object)sg.generator.getClass().getName());
                    return false;
                }
                LOGGER.debug("Loading source generator {}", (Object)sg.generator.getClass().getName());
                return true;
            }
            return false;
        }).sorted(Comparator.comparing(f -> f.module, EXECUTION_ORDER)).map(sg -> sg.generator).collect(Collectors.toList());
    }

    @NonNull
    public static List<AOTModule> list(Runtime runtime) {
        return SourceGeneratorLoader.sourceGeneratorStream().map(Object::getClass).map(MetadataUtils::findMetadata).filter(Optional::isPresent).map(Optional::get).filter(aotModule -> MetadataUtils.isEnabledOn(runtime, aotModule)).sorted(EXECUTION_ORDER).collect(Collectors.toList());
    }

    private static Stream<AOTCodeGenerator> sourceGeneratorStream() {
        return StreamSupport.stream(ServiceLoader.load(AOTCodeGenerator.class).spliterator(), false);
    }
}

