/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aot.core.config;

import io.micronaut.aot.core.AOTCodeGenerator;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.Option;
import io.micronaut.aot.core.Runtime;
import java.util.Arrays;
import java.util.Optional;

public class MetadataUtils {
    public static Optional<AOTModule> findMetadata(Class<?> clazz) {
        return Optional.ofNullable(clazz.getAnnotation(AOTModule.class));
    }

    public static Option findOption(Class<?> clazz, String name) {
        return (Option)MetadataUtils.findMetadata(clazz).flatMap(aotModule -> Arrays.stream(aotModule.options()).filter(option -> option.key().equals(name)).findFirst()).orElseThrow(() -> new IllegalArgumentException("No option found with name " + name + " on " + clazz));
    }

    public static String toPropertiesSample(Option option) {
        StringBuilder sb = new StringBuilder();
        String description = option.description();
        if (!description.isEmpty()) {
            sb.append("# ").append(description).append("\n");
        }
        String key = option.key();
        sb.append(key).append(" = ");
        String sampleValue = option.sampleValue();
        sb.append(sampleValue);
        return sb.toString();
    }

    public static boolean isEnabledOn(Runtime runtime, AOTCodeGenerator module) {
        return MetadataUtils.findMetadata(module.getClass()).map(aotModule -> MetadataUtils.isEnabledOn(runtime, aotModule)).orElse(false);
    }

    public static boolean isEnabledOn(Runtime runtime, AOTModule module) {
        return Arrays.asList(module.enabledOn()).contains((Object)runtime);
    }
}

