/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.web.jetty;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jetty.JettyServerThreadPoolMetrics;
import java.util.Collections;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainer;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

public class JettyServerThreadPoolMetricsBinder
implements ApplicationListener<ApplicationReadyEvent> {
    private final MeterRegistry meterRegistry;
    private final Iterable<Tag> tags;

    public JettyServerThreadPoolMetricsBinder(MeterRegistry meterRegistry) {
        this(meterRegistry, Collections.emptyList());
    }

    public JettyServerThreadPoolMetricsBinder(MeterRegistry meterRegistry, Iterable<Tag> tags) {
        this.meterRegistry = meterRegistry;
        this.tags = tags;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        ThreadPool threadPool = this.findThreadPool((ApplicationContext)applicationContext);
        if (threadPool != null) {
            new JettyServerThreadPoolMetrics(threadPool, this.tags).bindTo(this.meterRegistry);
        }
    }

    private ThreadPool findThreadPool(ApplicationContext applicationContext) {
        EmbeddedServletContainer container;
        if (applicationContext instanceof EmbeddedWebApplicationContext && (container = ((EmbeddedWebApplicationContext)applicationContext).getEmbeddedServletContainer()) instanceof JettyEmbeddedServletContainer) {
            return ((JettyEmbeddedServletContainer)container).getServer().getThreadPool();
        }
        return null;
    }
}

