/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.buffer.ByteBufAllocator;
import io.micrometer.shaded.io.netty.buffer.ByteBufHolder;
import io.micrometer.shaded.io.netty.buffer.CompositeByteBuf;
import io.micrometer.shaded.io.netty.buffer.Unpooled;
import io.micrometer.shaded.io.netty.util.IllegalReferenceCountException;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Fuseable;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.FluxOperator;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.ByteBufMono;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Function;

public class ByteBufFlux
extends FluxOperator<ByteBuf, ByteBuf> {
    final ByteBufAllocator alloc;
    static final Function<Object, ByteBuf> bytebufExtractor = o -> {
        if (o instanceof ByteBuf) {
            return (ByteBuf)o;
        }
        if (o instanceof ByteBufHolder) {
            return ((ByteBufHolder)o).content();
        }
        if (o instanceof byte[]) {
            return Unpooled.wrappedBuffer((byte[])o);
        }
        throw new IllegalArgumentException("Object " + o + " of type " + o.getClass() + " cannot be converted to ByteBuf");
    };
    static final int MAX_CHUNK_SIZE = 524288;
    static final Logger log = Loggers.getLogger(ByteBufFlux.class);

    public static ByteBufFlux fromInbound(Publisher<?> source) {
        return ByteBufFlux.fromInbound(source, ByteBufAllocator.DEFAULT);
    }

    public static ByteBufFlux fromInbound(Publisher<?> source, ByteBufAllocator allocator) {
        Objects.requireNonNull(allocator, "allocator");
        return ByteBufFlux.maybeFuse(Flux.from(ReactorNetty.publisherOrScalarMap(source, bytebufExtractor)), allocator);
    }

    public static ByteBufFlux fromString(Publisher<? extends String> source) {
        return ByteBufFlux.fromString(source, Charset.defaultCharset(), ByteBufAllocator.DEFAULT);
    }

    public static ByteBufFlux fromString(Publisher<? extends String> source, Charset charset, ByteBufAllocator allocator) {
        Objects.requireNonNull(allocator, "allocator");
        Objects.requireNonNull(charset, "charset");
        return ByteBufFlux.maybeFuse(Flux.from(ReactorNetty.publisherOrScalarMap(source, s -> {
            ByteBuf buffer = allocator.buffer();
            buffer.writeCharSequence((CharSequence)s, charset);
            return buffer;
        })), allocator);
    }

    public static ByteBufFlux fromPath(Path path) {
        return ByteBufFlux.fromPath(path, 524288);
    }

    public static ByteBufFlux fromPath(Path path, int maxChunkSize) {
        return ByteBufFlux.fromPath(path, maxChunkSize, ByteBufAllocator.DEFAULT);
    }

    public static ByteBufFlux fromPath(Path path, ByteBufAllocator allocator) {
        return ByteBufFlux.fromPath(path, 524288, allocator);
    }

    public static ByteBufFlux fromPath(Path path, int maxChunkSize, ByteBufAllocator allocator) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(allocator, "allocator");
        if (maxChunkSize < 1) {
            throw new IllegalArgumentException("chunk size must be strictly positive, was: " + maxChunkSize);
        }
        return ByteBufFlux.maybeFuse(Flux.generate(() -> FileChannel.open(path, new OpenOption[0]), (fc, sink) -> {
            ByteBuf buf = allocator.buffer();
            try {
                if (buf.writeBytes((ScatteringByteChannel)fc, maxChunkSize) < 0) {
                    buf.release();
                    sink.complete();
                } else {
                    sink.next(buf);
                }
            }
            catch (IOException e) {
                buf.release();
                sink.error(e);
            }
            return fc;
        }, ReactorNetty.fileCloser), allocator);
    }

    public final Flux<ByteBuffer> asByteBuffer() {
        return this.handle((bb, sink) -> {
            try {
                sink.next(bb.nioBuffer());
            }
            catch (IllegalReferenceCountException e) {
                sink.complete();
            }
        });
    }

    public final Flux<byte[]> asByteArray() {
        return this.handle((bb, sink) -> {
            try {
                byte[] bytes = new byte[bb.readableBytes()];
                bb.readBytes(bytes);
                sink.next(bytes);
            }
            catch (IllegalReferenceCountException e) {
                sink.complete();
            }
        });
    }

    public final Flux<InputStream> asInputStream() {
        return this.handle((bb, sink) -> {
            try {
                sink.next(new ByteBufMono.ReleasingInputStream((ByteBuf)bb));
            }
            catch (IllegalReferenceCountException e) {
                sink.complete();
            }
        });
    }

    public final Flux<String> asString() {
        return this.asString(Charset.defaultCharset());
    }

    public final Flux<String> asString(Charset charset) {
        Objects.requireNonNull(charset, "charset");
        return this.handle((bb, sink) -> {
            try {
                sink.next(bb.readCharSequence(bb.readableBytes(), charset).toString());
            }
            catch (IllegalReferenceCountException e) {
                sink.complete();
            }
        });
    }

    public final ByteBufMono aggregate() {
        return Mono.defer(() -> {
            CompositeByteBuf output = this.alloc.compositeBuffer();
            return this.doOnNext(ByteBuf::retain).collectList().doOnDiscard(ByteBuf.class, ByteBufFlux::safeRelease).handle((list, sink) -> {
                block5: {
                    if (!list.isEmpty()) {
                        try {
                            output.addComponents(true, (Iterable<ByteBuf>)list);
                        }
                        catch (IllegalReferenceCountException e) {
                            if (!log.isDebugEnabled()) break block5;
                            log.debug("", e);
                        }
                    }
                }
                if (output.isReadable()) {
                    sink.next(output);
                } else {
                    sink.complete();
                }
            }).doFinally(signalType -> ByteBufFlux.safeRelease(output));
        }).as(ByteBufMono::maybeFuse);
    }

    public final ByteBufMono multicast() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public final ByteBufFlux retain() {
        return ByteBufFlux.maybeFuse(this.doOnNext(ByteBuf::retain), this.alloc);
    }

    ByteBufFlux(Flux<ByteBuf> source, ByteBufAllocator allocator) {
        super(source);
        this.alloc = allocator;
    }

    @Override
    public void subscribe(CoreSubscriber<? super ByteBuf> s) {
        this.source.subscribe(s);
    }

    static ByteBufFlux maybeFuse(Flux<ByteBuf> source, ByteBufAllocator allocator) {
        if (source instanceof Fuseable) {
            return new ByteBufFluxFuseable(source, allocator);
        }
        return new ByteBufFlux(source, allocator);
    }

    static void safeRelease(ByteBuf byteBuf) {
        block3: {
            if (byteBuf.refCnt() > 0) {
                try {
                    byteBuf.release();
                }
                catch (IllegalReferenceCountException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("", e);
                }
            }
        }
    }

    static final class ByteBufFluxFuseable
    extends ByteBufFlux
    implements Fuseable {
        ByteBufFluxFuseable(Flux<ByteBuf> source, ByteBufAllocator allocator) {
            super(source, allocator);
        }
    }
}

