/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.tcp;

import io.micrometer.shaded.io.netty.channel.ChannelOption;
import io.micrometer.shaded.io.netty.util.NetUtil;
import io.micrometer.shaded.reactor.netty.resources.ConnectionProvider;
import io.micrometer.shaded.reactor.netty.tcp.TcpClient;
import io.micrometer.shaded.reactor.netty.tcp.TcpClientConfig;
import io.micrometer.shaded.reactor.netty.transport.AddressUtils;
import java.util.Collections;

final class TcpClientConnect
extends TcpClient {
    final TcpClientConfig config;
    static final int DEFAULT_PORT = System.getenv("PORT") != null ? Integer.parseInt(System.getenv("PORT")) : 12012;

    TcpClientConnect(ConnectionProvider provider) {
        this.config = new TcpClientConfig(provider, Collections.singletonMap(ChannelOption.AUTO_READ, false), () -> AddressUtils.createUnresolved(NetUtil.LOCALHOST.getHostAddress(), DEFAULT_PORT));
    }

    TcpClientConnect(TcpClientConfig config) {
        this.config = config;
    }

    @Override
    public TcpClientConfig configuration() {
        return this.config;
    }

    @Override
    protected TcpClient duplicate() {
        return new TcpClientConnect(new TcpClientConfig(this.config));
    }
}

