/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.client;

import io.micrometer.shaded.reactor.netty.http.HttpDecoderSpec;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientConfiguration;
import io.micrometer.shaded.reactor.netty.tcp.TcpClient;
import java.util.function.Function;

public final class HttpResponseDecoderSpec
extends HttpDecoderSpec<HttpResponseDecoderSpec> {
    public static final boolean DEFAULT_FAIL_ON_MISSING_RESPONSE = false;
    public static final boolean DEFAULT_PARSE_HTTP_AFTER_CONNECT_REQUEST = false;
    boolean failOnMissingResponse = false;
    boolean parseHttpAfterConnectRequest = false;

    @Override
    public HttpResponseDecoderSpec get() {
        return this;
    }

    public HttpResponseDecoderSpec failOnMissingResponse(boolean failOnMissingResponse) {
        this.failOnMissingResponse = failOnMissingResponse;
        return this;
    }

    public HttpResponseDecoderSpec parseHttpAfterConnectRequest(boolean parseHttpAfterConnectRequest) {
        this.parseHttpAfterConnectRequest = parseHttpAfterConnectRequest;
        return this;
    }

    Function<TcpClient, TcpClient> build() {
        HttpResponseDecoderSpec decoder = new HttpResponseDecoderSpec();
        decoder.initialBufferSize = this.initialBufferSize;
        decoder.maxChunkSize = this.maxChunkSize;
        decoder.maxHeaderSize = this.maxHeaderSize;
        decoder.maxInitialLineLength = this.maxInitialLineLength;
        decoder.validateHeaders = this.validateHeaders;
        decoder.failOnMissingResponse = this.failOnMissingResponse;
        decoder.parseHttpAfterConnectRequest = this.parseHttpAfterConnectRequest;
        return tcp -> tcp.bootstrap(b -> HttpClientConfiguration.decoder(b, decoder));
    }
}

