/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Timer;
import io.micrometer.shaded.io.netty.util.internal.PlatformDependent;
import io.micrometer.shaded.reactor.netty.Metrics;
import io.micrometer.shaded.reactor.netty.channel.MeterKey;
import io.micrometer.shaded.reactor.netty.channel.MicrometerChannelMetricsRecorder;
import io.micrometer.shaded.reactor.netty.http.HttpMetricsRecorder;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentMap;

public class MicrometerHttpMetricsRecorder
extends MicrometerChannelMetricsRecorder
implements HttpMetricsRecorder {
    protected final Timer.Builder dataReceivedTimeBuilder;
    protected final ConcurrentMap<MeterKey, Timer> dataReceivedTimeCache = PlatformDependent.newConcurrentHashMap();
    protected final Timer.Builder dataSentTimeBuilder;
    protected final ConcurrentMap<MeterKey, Timer> dataSentTimeCache = PlatformDependent.newConcurrentHashMap();
    protected final Timer.Builder responseTimeBuilder;
    protected final ConcurrentMap<MeterKey, Timer> responseTimeCache = PlatformDependent.newConcurrentHashMap();
    protected final DistributionSummary.Builder dataReceivedBuilder;
    protected final ConcurrentMap<MeterKey, DistributionSummary> dataReceivedCache = PlatformDependent.newConcurrentHashMap();
    protected final DistributionSummary.Builder dataSentBuilder;
    protected final ConcurrentMap<MeterKey, DistributionSummary> dataSentCache = PlatformDependent.newConcurrentHashMap();
    protected final Counter.Builder errorsBuilder;
    protected final ConcurrentMap<MeterKey, Counter> errorsCache = PlatformDependent.newConcurrentHashMap();

    protected MicrometerHttpMetricsRecorder(String name, String protocol) {
        super(name, protocol);
        this.dataReceivedTimeBuilder = Timer.builder((String)(name + ".data.received.time")).description("Time spent in consuming incoming data");
        this.dataSentTimeBuilder = Timer.builder((String)(name + ".data.sent.time")).description("Time spent in sending outgoing data");
        this.responseTimeBuilder = Timer.builder((String)(name + ".response.time")).description("Total time for the request/response");
        this.dataReceivedBuilder = DistributionSummary.builder((String)(name + ".data.received")).baseUnit("bytes").description("Amount of the data received, in bytes");
        this.dataSentBuilder = DistributionSummary.builder((String)(name + ".data.sent")).baseUnit("bytes").description("Amount of the data sent, in bytes");
        this.errorsBuilder = Counter.builder((String)(name + ".errors")).description("Number of errors that occurred");
    }

    @Override
    public void recordDataReceived(SocketAddress remoteAddress, String uri, long bytes) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        DistributionSummary dataReceived = this.dataReceivedCache.computeIfAbsent(new MeterKey(uri, address, null, null), key -> MicrometerHttpMetricsRecorder.filter(this.dataReceivedBuilder.tags(new String[]{"remote.address", address, "uri", uri}).register(Metrics.REGISTRY)));
        if (dataReceived != null) {
            dataReceived.record((double)bytes);
        }
    }

    @Override
    public void recordDataSent(SocketAddress remoteAddress, String uri, long bytes) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        DistributionSummary dataSent = this.dataSentCache.computeIfAbsent(new MeterKey(uri, address, null, null), key -> MicrometerHttpMetricsRecorder.filter(this.dataSentBuilder.tags(new String[]{"remote.address", address, "uri", uri}).register(Metrics.REGISTRY)));
        if (dataSent != null) {
            dataSent.record((double)bytes);
        }
    }

    @Override
    public void incrementErrorsCount(SocketAddress remoteAddress, String uri) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        Counter errors = this.errorsCache.computeIfAbsent(new MeterKey(uri, address, null, null), key -> MicrometerHttpMetricsRecorder.filter(this.errorsBuilder.tags(new String[]{"remote.address", address, "uri", uri}).register(Metrics.REGISTRY)));
        if (errors != null) {
            errors.increment();
        }
    }
}

