/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.core.publisher.SourceProducer;
import io.micrometer.shaded.reactor.util.context.Context;
import java.util.Objects;
import java.util.function.Function;

final class FluxDeferWithContext<T>
extends Flux<T>
implements SourceProducer<T> {
    final Function<Context, ? extends Publisher<? extends T>> supplier;

    FluxDeferWithContext(Function<Context, ? extends Publisher<? extends T>> supplier) {
        this.supplier = Objects.requireNonNull(supplier, "supplier");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Publisher<? extends T> p;
        Context ctx = actual.currentContext();
        try {
            p = Objects.requireNonNull(this.supplier.apply(ctx), "The Publisher returned by the supplier is null");
        }
        catch (Throwable e) {
            Operators.error(actual, Operators.onOperatorError(e, ctx));
            return;
        }
        FluxDeferWithContext.from(p).subscribe(actual);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        return null;
    }
}

