/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.tcp;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.io.netty.channel.EventLoopGroup;
import io.micrometer.shaded.io.netty.handler.ssl.JdkSslContext;
import io.micrometer.shaded.reactor.netty.resources.LoopResources;
import io.micrometer.shaded.reactor.netty.tcp.SslProvider;
import io.micrometer.shaded.reactor.netty.tcp.TcpClient;
import io.micrometer.shaded.reactor.netty.tcp.TcpClientConnect;
import io.micrometer.shaded.reactor.netty.tcp.TcpClientOperator;
import java.util.Objects;
import java.util.function.Supplier;

final class TcpClientRunOn
extends TcpClientOperator {
    final LoopResources loopResources;
    final boolean preferNative;

    TcpClientRunOn(TcpClient client, LoopResources loopResources, boolean preferNative) {
        super(client);
        this.loopResources = Objects.requireNonNull(loopResources, "loopResources");
        this.preferNative = preferNative;
    }

    @Override
    public Bootstrap configure() {
        Bootstrap b;
        Integer maxConnections = (Integer)(b = this.source.configure()).config().attrs().get(TcpClientConnect.MAX_CONNECTIONS);
        TcpClientRunOn.configure(b, this.preferNative, this.loopResources, maxConnections != null && maxConnections != -1);
        return b;
    }

    static void configure(Bootstrap b, boolean preferNative, LoopResources resources, boolean useDelegate) {
        SslProvider sslProvider = SslProvider.findSslSupport(b);
        boolean useNative = preferNative && (sslProvider == null || !(sslProvider.sslContext instanceof JdkSslContext));
        EventLoopGroup elg = resources.onClient(useNative);
        if (useDelegate && elg instanceof Supplier) {
            EventLoopGroup delegate = (EventLoopGroup)((Supplier)((Object)elg)).get();
            ((Bootstrap)b.group(delegate)).channel(resources.onChannel(delegate));
        } else {
            ((Bootstrap)b.group(elg)).channel(resources.onChannel(elg));
        }
    }
}

