/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.resources;

import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.EventLoop;
import io.micrometer.shaded.io.netty.channel.EventLoopGroup;
import io.micrometer.shaded.io.netty.resolver.AddressResolverGroup;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoSink;
import io.micrometer.shaded.reactor.core.scheduler.Schedulers;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.AllocationStrategy;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.Pool;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.PoolBuilder;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.PoolConfig;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.PooledRef;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.PooledRefMetadata;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.decorators.GracefulShutdownInstrumentedPool;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.decorators.InstrumentedPoolDecorators;
import io.micrometer.shaded.reactor.netty.internal.shaded.reactor.pool.introspection.SamplingAllocationStrategy;
import io.micrometer.shaded.reactor.netty.internal.util.MapUtils;
import io.micrometer.shaded.reactor.netty.resources.ColocatedEventLoopGroup;
import io.micrometer.shaded.reactor.netty.resources.ConnectionProvider;
import io.micrometer.shaded.reactor.netty.resources.DelegatingConnectionPoolMetrics;
import io.micrometer.shaded.reactor.netty.resources.MicrometerPooledConnectionProviderMeterRegistrar;
import io.micrometer.shaded.reactor.netty.transport.TransportConfig;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import io.micrometer.shaded.reactor.util.Metrics;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Clock;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public abstract class PooledConnectionProvider<T extends Connection>
implements ConnectionProvider {
    protected static final String CONTEXT_CALLER_EVENTLOOP = "callereventloop";
    final PoolFactory<T> defaultPoolFactory;
    final Map<SocketAddress, PoolFactory<T>> poolFactoryPerRemoteHost = new HashMap<SocketAddress, PoolFactory<T>>();
    final ConcurrentMap<PoolKey, InstrumentedPool<T>> channelPools = new ConcurrentHashMap<PoolKey, InstrumentedPool<T>>();
    final ConnectionProvider.Builder builder;
    final String name;
    final Duration inactivePoolDisposeInterval;
    final Duration poolInactivity;
    final Duration disposeTimeout;
    final Map<SocketAddress, Integer> maxConnections = new HashMap<SocketAddress, Integer>();
    Mono<Void> onDispose;
    static final Logger log = Loggers.getLogger(PooledConnectionProvider.class);

    protected PooledConnectionProvider(ConnectionProvider.Builder builder) {
        this(builder, null);
    }

    PooledConnectionProvider(ConnectionProvider.Builder builder, @Nullable Clock clock) {
        this.builder = builder;
        this.name = builder.name;
        this.inactivePoolDisposeInterval = builder.inactivePoolDisposeInterval;
        this.poolInactivity = builder.poolInactivity;
        this.disposeTimeout = builder.disposeTimeout;
        this.defaultPoolFactory = new PoolFactory(builder, builder.disposeTimeout, clock);
        for (Map.Entry<SocketAddress, ConnectionProvider.ConnectionPoolSpec<?>> entry : builder.confPerRemoteHost.entrySet()) {
            this.poolFactoryPerRemoteHost.put(entry.getKey(), new PoolFactory(entry.getValue(), builder.disposeTimeout));
            this.maxConnections.put(entry.getKey(), entry.getValue().maxConnections);
        }
        this.onDispose = Mono.empty();
        this.scheduleInactivePoolsDisposal();
    }

    @Override
    public final Mono<? extends Connection> acquire(TransportConfig config, ConnectionObserver connectionObserver, @Nullable Supplier<? extends SocketAddress> remote, @Nullable AddressResolverGroup<?> resolverGroup) {
        Objects.requireNonNull(config, "config");
        Objects.requireNonNull(connectionObserver, "connectionObserver");
        Objects.requireNonNull(remote, "remoteAddress");
        Objects.requireNonNull(resolverGroup, "resolverGroup");
        return Mono.create((MonoSink<T> sink) -> {
            EventLoopGroup group;
            SocketAddress remoteAddress = Objects.requireNonNull((SocketAddress)remote.get(), "Remote Address supplier returned null");
            PoolKey holder = new PoolKey(remoteAddress, config.channelHash());
            PoolFactory<T> poolFactory = this.poolFactory(remoteAddress);
            InstrumentedPool pool = MapUtils.computeIfAbsent(this.channelPools, holder, poolKey -> {
                if (log.isDebugEnabled()) {
                    log.debug("Creating a new [{}] client pool [{}] for [{}]", this.name, poolFactory, remoteAddress);
                }
                InstrumentedPool<T> newPool = this.createPool(config, poolFactory, remoteAddress, resolverGroup);
                if (poolFactory.metricsEnabled || config.metricsRecorder() != null) {
                    String id = poolKey.hashCode() + "";
                    if (poolFactory.registrar != null) {
                        poolFactory.registrar.get().registerMetrics(this.name, id, remoteAddress, new DelegatingConnectionPoolMetrics(newPool.metrics()));
                    } else if (Metrics.isInstrumentationAvailable()) {
                        this.registerDefaultMetrics(id, remoteAddress, newPool.metrics());
                    }
                }
                return newPool;
            });
            EventLoop eventLoop = sink.contextView().hasKey(CONTEXT_CALLER_EVENTLOOP) ? (EventLoop)sink.contextView().get(CONTEXT_CALLER_EVENTLOOP) : ((group = config.loopResources().onClient(config.isPreferNative())) instanceof ColocatedEventLoopGroup ? ((ColocatedEventLoopGroup)group).nextInternal() : null);
            Mono mono = pool.acquire(Duration.ofMillis(poolFactory.pendingAcquireTimeout));
            if (eventLoop != null) {
                mono = mono.contextWrite(ctx -> ctx.put(CONTEXT_CALLER_EVENTLOOP, eventLoop));
            }
            mono.subscribe(this.createDisposableAcquire(config, connectionObserver, poolFactory.pendingAcquireTimeout, pool, (MonoSink<Connection>)sink));
        });
    }

    @Override
    public final Mono<Void> disposeLater() {
        return Mono.defer(() -> {
            List pools = this.channelPools.entrySet().stream().map(e -> {
                Pool pool = (Pool)e.getValue();
                SocketAddress remoteAddress = ((PoolKey)e.getKey()).holder;
                String id = ((PoolKey)e.getKey()).hashCode() + "";
                PoolFactory<T> poolFactory = this.poolFactory(remoteAddress);
                if (pool instanceof GracefulShutdownInstrumentedPool) {
                    return ((GracefulShutdownInstrumentedPool)pool).disposeGracefully(this.disposeTimeout).onErrorResume(t -> {
                        log.error("Connection pool for [{}] didn't shut down gracefully", e.getKey(), t);
                        return Mono.fromRunnable(() -> {
                            if (poolFactory.registrar != null) {
                                poolFactory.registrar.get().deRegisterMetrics(this.name, id, remoteAddress);
                            } else if (Metrics.isInstrumentationAvailable()) {
                                this.deRegisterDefaultMetrics(id, remoteAddress);
                            }
                        });
                    });
                }
                return pool.disposeLater().then(Mono.fromRunnable(() -> {
                    if (poolFactory.registrar != null) {
                        poolFactory.registrar.get().deRegisterMetrics(this.name, id, remoteAddress);
                    } else if (Metrics.isInstrumentationAvailable()) {
                        this.deRegisterDefaultMetrics(id, remoteAddress);
                    }
                }));
            }).collect(Collectors.toList());
            if (pools.isEmpty()) {
                return this.onDispose;
            }
            this.channelPools.clear();
            return this.onDispose.and(Mono.when(pools));
        });
    }

    @Override
    public final void disposeWhen(SocketAddress address) {
        List<Map.Entry> toDispose = this.channelPools.entrySet().stream().filter(p -> this.compareAddresses(((PoolKey)p.getKey()).holder, address)).collect(Collectors.toList());
        toDispose.forEach(e -> {
            if (this.channelPools.remove(e.getKey(), e.getValue())) {
                if (log.isDebugEnabled()) {
                    log.debug("ConnectionProvider[name={}]: Disposing pool for [{}]", this.name, ((PoolKey)e.getKey()).holder);
                }
                String id = ((PoolKey)e.getKey()).hashCode() + "";
                PoolFactory<T> poolFactory = this.poolFactory(address);
                ((InstrumentedPool)e.getValue()).disposeLater().then(Mono.fromRunnable(() -> {
                    if (poolFactory.registrar != null) {
                        poolFactory.registrar.get().deRegisterMetrics(this.name, id, address);
                    } else if (Metrics.isInstrumentationAvailable()) {
                        this.deRegisterDefaultMetrics(id, address);
                    }
                })).subscribe();
            }
        });
    }

    @Override
    public final boolean isDisposed() {
        return this.channelPools.isEmpty() || this.channelPools.values().stream().allMatch(Disposable::isDisposed);
    }

    @Override
    public int maxConnections() {
        return this.defaultPoolFactory.maxConnections;
    }

    @Override
    public Map<SocketAddress, Integer> maxConnectionsPerHost() {
        return this.maxConnections;
    }

    @Override
    public ConnectionProvider.Builder mutate() {
        return new ConnectionProvider.Builder(this.builder);
    }

    @Override
    public String name() {
        return this.name;
    }

    public void onDispose(Mono<Void> disposeMono) {
        this.onDispose = this.onDispose.and(disposeMono);
    }

    protected abstract CoreSubscriber<PooledRef<T>> createDisposableAcquire(TransportConfig var1, ConnectionObserver var2, long var3, InstrumentedPool<T> var5, MonoSink<Connection> var6);

    protected abstract InstrumentedPool<T> createPool(TransportConfig var1, PoolFactory<T> var2, SocketAddress var3, AddressResolverGroup<?> var4);

    protected PoolFactory<T> poolFactory(SocketAddress remoteAddress) {
        return this.poolFactoryPerRemoteHost.getOrDefault(remoteAddress, this.defaultPoolFactory);
    }

    protected void registerDefaultMetrics(String id, SocketAddress remoteAddress, InstrumentedPool.PoolMetrics metrics) {
        MicrometerPooledConnectionProviderMeterRegistrar.INSTANCE.registerMetrics(this.name, id, remoteAddress, metrics);
    }

    protected void deRegisterDefaultMetrics(String id, SocketAddress remoteAddress) {
        MicrometerPooledConnectionProviderMeterRegistrar.INSTANCE.deRegisterMetrics(this.name, id, remoteAddress);
    }

    final boolean compareAddresses(SocketAddress origin, SocketAddress target) {
        if (origin.equals(target)) {
            return true;
        }
        if (origin instanceof InetSocketAddress && target instanceof InetSocketAddress) {
            InetSocketAddress isaOrigin = (InetSocketAddress)origin;
            InetSocketAddress isaTarget = (InetSocketAddress)target;
            if (isaOrigin.getPort() == isaTarget.getPort()) {
                InetAddress iaTarget = isaTarget.getAddress();
                return iaTarget != null && iaTarget.isAnyLocalAddress() || Objects.equals(isaOrigin.getHostString(), isaTarget.getHostString());
            }
        }
        return false;
    }

    protected static void logPoolState(Channel channel, InstrumentedPool<? extends Connection> pool, String msg) {
        PooledConnectionProvider.logPoolState(channel, pool, msg, null);
    }

    protected static void logPoolState(Channel channel, InstrumentedPool<? extends Connection> pool, String msg, @Nullable Throwable t) {
        InstrumentedPool.PoolMetrics metrics = pool.metrics();
        log.debug(ReactorNetty.format(channel, "{}, now: {} active connections, {} inactive connections and {} pending acquire requests."), msg, metrics.acquiredSize(), metrics.idleSize(), metrics.pendingAcquireSize(), t == null ? "" : t);
    }

    final void scheduleInactivePoolsDisposal() {
        if (!this.inactivePoolDisposeInterval.isZero()) {
            Schedulers.parallel().schedule(this::disposeInactivePoolsInBackground, this.inactivePoolDisposeInterval.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    final void disposeInactivePoolsInBackground() {
        if (!this.channelPools.isEmpty()) {
            List<Map.Entry> toDispose = this.channelPools.entrySet().stream().filter(p -> ((InstrumentedPool)p.getValue()).metrics().isInactiveForMoreThan(this.poolInactivity)).collect(Collectors.toList());
            toDispose.forEach(e -> {
                if (this.channelPools.remove(e.getKey(), e.getValue())) {
                    if (log.isDebugEnabled()) {
                        log.debug("ConnectionProvider[name={}]: Disposing inactive pool for [{}]", this.name, ((PoolKey)e.getKey()).holder);
                    }
                    ((InstrumentedPool)e.getValue()).dispose();
                }
            });
        }
        this.scheduleInactivePoolsDisposal();
    }

    static final class PoolKey {
        final String fqdn;
        final SocketAddress holder;
        final int pipelineKey;

        PoolKey(SocketAddress holder, int pipelineKey) {
            InetSocketAddress inetSocketAddress;
            String fqdn = null;
            if (holder instanceof InetSocketAddress && !(inetSocketAddress = (InetSocketAddress)holder).isUnresolved()) {
                fqdn = inetSocketAddress.getHostString().toLowerCase();
            }
            this.fqdn = fqdn;
            this.holder = holder;
            this.pipelineKey = pipelineKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PoolKey poolKey = (PoolKey)o;
            return Objects.equals(this.fqdn, poolKey.fqdn) && Objects.equals(this.holder, poolKey.holder) && this.pipelineKey == poolKey.pipelineKey;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + Objects.hashCode(this.fqdn);
            result = 31 * result + Objects.hashCode(this.holder);
            result = 31 * result + this.pipelineKey;
            return result;
        }
    }

    static final class PooledConnectionMetadata
    implements ConnectionProvider.ConnectionMetadata {
        final PooledRefMetadata delegate;

        PooledConnectionMetadata(PooledRefMetadata delegate) {
            this.delegate = delegate;
        }

        @Override
        public int acquireCount() {
            return this.delegate.acquireCount();
        }

        @Override
        public long idleTime() {
            return this.delegate.idleTime();
        }

        @Override
        public long lifeTime() {
            return this.delegate.lifeTime();
        }

        @Override
        public long releaseTimestamp() {
            return this.delegate.releaseTimestamp();
        }

        @Override
        public long allocationTimestamp() {
            return this.delegate.allocationTimestamp();
        }
    }

    protected static final class PoolFactory<T extends Connection> {
        static final double DEFAULT_POOL_GET_PERMITS_SAMPLING_RATE;
        static final double DEFAULT_POOL_RETURN_PERMITS_SAMPLING_RATE;
        final Duration evictionInterval;
        final String leasingStrategy;
        final int maxConnections;
        final long maxIdleTime;
        final long maxLifeTime;
        final boolean metricsEnabled;
        final int pendingAcquireMaxCount;
        final long pendingAcquireTimeout;
        final Supplier<? extends ConnectionProvider.MeterRegistrar> registrar;
        final Clock clock;
        final Duration disposeTimeout;
        final BiFunction<Runnable, Duration, Disposable> pendingAcquireTimer;
        final ConnectionProvider.AllocationStrategy<?> allocationStrategy;
        final BiPredicate<Connection, ConnectionProvider.ConnectionMetadata> evictionPredicate;

        PoolFactory(ConnectionProvider.ConnectionPoolSpec<?> conf, Duration disposeTimeout) {
            this(conf, disposeTimeout, null);
        }

        PoolFactory(ConnectionProvider.ConnectionPoolSpec<?> conf, Duration disposeTimeout, @Nullable Clock clock) {
            this.evictionInterval = conf.evictionInterval;
            this.leasingStrategy = conf.leasingStrategy;
            this.maxConnections = conf.maxConnections;
            this.maxIdleTime = conf.maxIdleTime != null ? conf.maxIdleTime.toMillis() : -1L;
            this.maxLifeTime = conf.maxLifeTime != null ? conf.maxLifeTime.toMillis() : -1L;
            this.metricsEnabled = conf.metricsEnabled;
            this.pendingAcquireMaxCount = conf.pendingAcquireMaxCount == -2 ? 2 * conf.maxConnections : conf.pendingAcquireMaxCount;
            this.pendingAcquireTimeout = conf.pendingAcquireTimeout.toMillis();
            this.registrar = conf.registrar;
            this.clock = clock;
            this.disposeTimeout = disposeTimeout;
            this.pendingAcquireTimer = conf.pendingAcquireTimer;
            this.allocationStrategy = conf.allocationStrategy;
            this.evictionPredicate = conf.evictionPredicate;
        }

        public InstrumentedPool<T> newPool(Publisher<T> allocator, @Nullable AllocationStrategy allocationStrategy, Function<T, Publisher<Void>> destroyHandler, BiPredicate<T, PooledRefMetadata> evictionPredicate) {
            if (this.disposeTimeout != null) {
                return this.newPoolInternal(allocator, destroyHandler, evictionPredicate).buildPoolAndDecorateWith(InstrumentedPoolDecorators::gracefulShutdown);
            }
            return this.newPoolInternal(allocator, destroyHandler, evictionPredicate).buildPool();
        }

        public InstrumentedPool<T> newPool(Publisher<T> allocator, @Nullable AllocationStrategy allocationStrategy, Function<T, Publisher<Void>> destroyHandler, BiPredicate<T, PooledRefMetadata> defaultEvictionPredicate, Function<PoolConfig<T>, InstrumentedPool<T>> poolFactory) {
            if (this.disposeTimeout != null) {
                return this.newPoolInternal(allocator, destroyHandler, defaultEvictionPredicate).build(poolFactory.andThen(InstrumentedPoolDecorators::gracefulShutdown));
            }
            return this.newPoolInternal(allocator, destroyHandler, defaultEvictionPredicate).build(poolFactory);
        }

        PoolBuilder<T, PoolConfig<T>> newPoolInternal(Publisher<T> allocator, Function<T, Publisher<Void>> destroyHandler, BiPredicate<T, PooledRefMetadata> defaultEvictionPredicate) {
            PoolBuilder<Object, PoolConfig<T>> poolBuilder = PoolBuilder.from(allocator).destroyHandler(destroyHandler).maxPendingAcquire(this.pendingAcquireMaxCount).evictInBackground(this.evictionInterval);
            poolBuilder = this.evictionPredicate != null ? poolBuilder.evictionPredicate((poolable, meta) -> this.evictionPredicate.test((Connection)poolable, new PooledConnectionMetadata((PooledRefMetadata)meta))) : poolBuilder.evictionPredicate(defaultEvictionPredicate.or((poolable, meta) -> this.maxIdleTime != -1L && meta.idleTime() >= this.maxIdleTime || this.maxLifeTime != -1L && meta.lifeTime() >= this.maxLifeTime));
            poolBuilder = DEFAULT_POOL_GET_PERMITS_SAMPLING_RATE > 0.0 && DEFAULT_POOL_GET_PERMITS_SAMPLING_RATE <= 1.0 && DEFAULT_POOL_RETURN_PERMITS_SAMPLING_RATE > 0.0 && DEFAULT_POOL_RETURN_PERMITS_SAMPLING_RATE <= 1.0 ? poolBuilder.allocationStrategy(SamplingAllocationStrategy.sizeBetweenWithSampling(0, this.maxConnections, DEFAULT_POOL_GET_PERMITS_SAMPLING_RATE, DEFAULT_POOL_RETURN_PERMITS_SAMPLING_RATE)) : (this.allocationStrategy == null ? poolBuilder.sizeBetween(0, this.maxConnections) : poolBuilder.allocationStrategy(new DelegatingAllocationStrategy((ConnectionProvider.AllocationStrategy<?>)this.allocationStrategy.copy())));
            if (this.pendingAcquireTimer != null) {
                poolBuilder = poolBuilder.pendingAcquireTimer(this.pendingAcquireTimer);
            }
            if (this.clock != null) {
                poolBuilder = poolBuilder.clock(this.clock);
            }
            poolBuilder = "fifo".equals(this.leasingStrategy) ? poolBuilder.idleResourceReuseLruOrder() : poolBuilder.idleResourceReuseMruOrder();
            return poolBuilder;
        }

        @Nullable
        public ConnectionProvider.AllocationStrategy<?> allocationStrategy() {
            return this.allocationStrategy;
        }

        public long maxIdleTime() {
            return this.maxIdleTime;
        }

        public long maxLifeTime() {
            return this.maxLifeTime;
        }

        public String toString() {
            return "PoolFactory{evictionInterval=" + this.evictionInterval + ", leasingStrategy=" + this.leasingStrategy + ", maxConnections=" + this.maxConnections + ", maxIdleTime=" + this.maxIdleTime + ", maxLifeTime=" + this.maxLifeTime + ", metricsEnabled=" + this.metricsEnabled + ", pendingAcquireMaxCount=" + this.pendingAcquireMaxCount + ", pendingAcquireTimeout=" + this.pendingAcquireTimeout + '}';
        }

        static {
            double returnPermitsSamplingRate;
            double getPermitsSamplingRate = Double.parseDouble(System.getProperty("io.micrometer.shaded.reactor.netty.pool.getPermitsSamplingRate", "0"));
            if (getPermitsSamplingRate > 1.0) {
                DEFAULT_POOL_GET_PERMITS_SAMPLING_RATE = 0.0;
                if (log.isWarnEnabled()) {
                    log.warn("Invalid configuration [reactor.netty.pool.getPermitsSamplingRate=" + getPermitsSamplingRate + "], the value must be between 0d and 1d (percentage). SamplingAllocationStrategy in not enabled.");
                }
            } else {
                DEFAULT_POOL_GET_PERMITS_SAMPLING_RATE = getPermitsSamplingRate;
            }
            if ((returnPermitsSamplingRate = Double.parseDouble(System.getProperty("io.micrometer.shaded.reactor.netty.pool.returnPermitsSamplingRate", "0"))) > 1.0) {
                DEFAULT_POOL_RETURN_PERMITS_SAMPLING_RATE = 0.0;
                if (log.isWarnEnabled()) {
                    log.warn("Invalid configuration [reactor.netty.pool.returnPermitsSamplingRate=" + returnPermitsSamplingRate + "], the value must be between 0d and 1d (percentage). SamplingAllocationStrategy is enabled.");
                }
            } else {
                DEFAULT_POOL_RETURN_PERMITS_SAMPLING_RATE = returnPermitsSamplingRate;
            }
        }

        static final class DelegatingAllocationStrategy
        implements AllocationStrategy {
            final ConnectionProvider.AllocationStrategy<?> delegate;

            DelegatingAllocationStrategy(ConnectionProvider.AllocationStrategy<?> delegate) {
                this.delegate = delegate;
            }

            @Override
            public int estimatePermitCount() {
                return this.delegate.estimatePermitCount();
            }

            @Override
            public int getPermits(int desired) {
                return this.delegate.getPermits(desired);
            }

            @Override
            public int permitGranted() {
                return this.delegate.permitGranted();
            }

            @Override
            public int permitMinimum() {
                return this.delegate.permitMinimum();
            }

            @Override
            public int permitMaximum() {
                return this.delegate.permitMaximum();
            }

            @Override
            public void returnPermits(int returned) {
                this.delegate.returnPermits(returned);
            }
        }
    }
}

