/*
 * Copyright 2025 VMware, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.micrometer.prometheus;

import java.lang.annotation.*;

/**
 * This is for internal use only.
 */
@Documented
@Retention(RetentionPolicy.CLASS)
@Target(ElementType.METHOD)
@interface EnsuresNonNullIf {

    /**
     * The list of fields that are non-null after the method returns the given result.
     */
    String[] value();

    /**
     * The return value of the method under which the postcondition holds. The default is
     * set to true, which means the method should return true in case fields are non-null.
     */
    boolean result() default true;

}
