/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.proxy;

import com.googlecode.jmeter.plugins.webdriver.proxy.ProxyHostPort;
import org.openqa.selenium.Proxy;

public class ProxyFactory {
    private static final ProxyFactory INSTANCE = new ProxyFactory();

    public static ProxyFactory getInstance() {
        return INSTANCE;
    }

    private ProxyFactory() {
    }

    public Proxy getManualProxy(ProxyHostPort httpProxy, ProxyHostPort httpsProxy, ProxyHostPort ftpProxy, ProxyHostPort socksProxy, String noProxy) {
        return new Proxy().setProxyType(Proxy.ProxyType.MANUAL).setHttpProxy(httpProxy.toUnifiedForm()).setSslProxy(httpsProxy.toUnifiedForm()).setFtpProxy(ftpProxy.toUnifiedForm()).setSocksProxy(socksProxy.toUnifiedForm()).setNoProxy(noProxy);
    }

    public Proxy getDirectProxy() {
        return new Proxy().setProxyType(Proxy.ProxyType.DIRECT);
    }

    public Proxy getAutodetectProxy() {
        return new Proxy().setProxyType(Proxy.ProxyType.AUTODETECT).setAutodetect(true);
    }

    public Proxy getConfigUrlProxy(String pacUrl) {
        return new Proxy().setProxyType(Proxy.ProxyType.PAC).setProxyAutoconfigUrl(pacUrl);
    }

    public Proxy getSystemProxy() {
        return new Proxy().setProxyType(Proxy.ProxyType.SYSTEM);
    }
}

