/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config.gui;

import com.googlecode.jmeter.plugins.webdriver.config.WebDriverConfig;
import com.googlecode.jmeter.plugins.webdriver.proxy.ProxyType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;

public abstract class WebDriverConfigGui
extends AbstractConfigGui
implements ItemListener {
    private static final long serialVersionUID = 100L;
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getIntegerInstance();
    private static final int PROXY_FIELD_INDENT = 28;
    private static final int DEFAULT_PROXY_PORT = 8080;
    private static final String DEFAULT_NO_PROXY_LIST = "localhost";
    JRadioButton directProxy;
    JRadioButton autoDetectProxy;
    JRadioButton systemProxy;
    JRadioButton manualProxy;
    JRadioButton pacUrlProxy;
    JTextField pacUrl;
    JTextField httpProxyHost;
    JFormattedTextField httpProxyPort;
    JCheckBox useHttpSettingsForAllProtocols;
    JTextField httpsProxyHost;
    JFormattedTextField httpsProxyPort;
    JTextField ftpProxyHost;
    JFormattedTextField ftpProxyPort;
    JTextField socksProxyHost;
    JFormattedTextField socksProxyPort;
    JTextArea noProxyList;
    JCheckBox maximizeBrowser;
    JCheckBox recreateBrowserOnIterationStart;
    JCheckBox devMode;

    public WebDriverConfigGui() {
        this.createGui();
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof WebDriverConfig) {
            WebDriverConfig webDriverConfig = (WebDriverConfig)element;
            if (this.isProxyEnabled()) {
                switch (webDriverConfig.getProxyType()) {
                    case DIRECT: {
                        this.directProxy.setSelected(true);
                        break;
                    }
                    case AUTO_DETECT: {
                        this.autoDetectProxy.setSelected(true);
                        break;
                    }
                    case MANUAL: {
                        this.manualProxy.setSelected(true);
                        break;
                    }
                    case PROXY_PAC: {
                        this.pacUrlProxy.setSelected(true);
                        break;
                    }
                    default: {
                        this.systemProxy.setSelected(true);
                    }
                }
                this.pacUrl.setText(webDriverConfig.getProxyPacUrl());
                this.httpProxyHost.setText(webDriverConfig.getHttpHost());
                this.httpProxyPort.setText(String.valueOf(webDriverConfig.getHttpPort()));
                this.useHttpSettingsForAllProtocols.setSelected(webDriverConfig.isUseHttpSettingsForAllProtocols());
                this.httpsProxyHost.setText(webDriverConfig.getHttpsHost());
                this.httpsProxyPort.setText(String.valueOf(webDriverConfig.getHttpsPort()));
                this.ftpProxyHost.setText(webDriverConfig.getFtpHost());
                this.ftpProxyPort.setText(String.valueOf(webDriverConfig.getFtpPort()));
                this.socksProxyHost.setText(webDriverConfig.getSocksHost());
                this.socksProxyPort.setText(String.valueOf(webDriverConfig.getSocksPort()));
                this.noProxyList.setText(webDriverConfig.getNoProxyHost());
            }
            if (this.isExperimentalEnabled()) {
                this.maximizeBrowser.setSelected(webDriverConfig.isBrowserMaximized());
                this.recreateBrowserOnIterationStart.setSelected(webDriverConfig.isRecreateBrowserOnIterationStart());
                this.devMode.setSelected(webDriverConfig.isDevMode());
            }
        }
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        if (element instanceof WebDriverConfig) {
            WebDriverConfig webDriverConfig = (WebDriverConfig)element;
            if (this.isProxyEnabled()) {
                if (this.directProxy.isSelected()) {
                    webDriverConfig.setProxyType(ProxyType.DIRECT);
                } else if (this.autoDetectProxy.isSelected()) {
                    webDriverConfig.setProxyType(ProxyType.AUTO_DETECT);
                } else if (this.pacUrlProxy.isSelected()) {
                    webDriverConfig.setProxyType(ProxyType.PROXY_PAC);
                } else if (this.manualProxy.isSelected()) {
                    webDriverConfig.setProxyType(ProxyType.MANUAL);
                } else {
                    webDriverConfig.setProxyType(ProxyType.SYSTEM);
                }
                webDriverConfig.setProxyPacUrl(this.pacUrl.getText());
                webDriverConfig.setHttpHost(this.httpProxyHost.getText());
                webDriverConfig.setHttpPort(Integer.parseInt(this.httpProxyPort.getText()));
                webDriverConfig.setUseHttpSettingsForAllProtocols(this.useHttpSettingsForAllProtocols.isSelected());
                webDriverConfig.setHttpsHost(this.httpsProxyHost.getText());
                webDriverConfig.setHttpsPort(Integer.parseInt(this.httpsProxyPort.getText()));
                webDriverConfig.setFtpHost(this.ftpProxyHost.getText());
                webDriverConfig.setFtpPort(Integer.parseInt(this.ftpProxyPort.getText()));
                webDriverConfig.setSocksHost(this.socksProxyHost.getText());
                webDriverConfig.setSocksPort(Integer.parseInt(this.socksProxyPort.getText()));
                webDriverConfig.setNoProxyHost(this.noProxyList.getText());
            }
            if (this.isExperimentalEnabled()) {
                webDriverConfig.setBrowserMaximized(this.maximizeBrowser.isSelected());
                webDriverConfig.setRecreateBrowserOnIterationStart(this.recreateBrowserOnIterationStart.isSelected());
                webDriverConfig.setDevMode(this.devMode.isSelected());
            }
        }
    }

    public void clearGui() {
        super.clearGui();
        if (this.isProxyEnabled()) {
            this.systemProxy.setSelected(true);
            this.pacUrl.setText("");
            this.httpProxyHost.setText("");
            this.httpProxyPort.setText(String.valueOf(8080));
            this.useHttpSettingsForAllProtocols.setSelected(true);
            this.httpsProxyHost.setText("");
            this.httpsProxyPort.setText(String.valueOf(8080));
            this.ftpProxyHost.setText("");
            this.ftpProxyPort.setText(String.valueOf(8080));
            this.socksProxyHost.setText("");
            this.socksProxyPort.setText(String.valueOf(8080));
            this.noProxyList.setText(DEFAULT_NO_PROXY_LIST);
        }
        if (this.isExperimentalEnabled()) {
            this.maximizeBrowser.setSelected(true);
        }
    }

    private void createGui() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel((Container)this.makeTitlePanel(), (String)this.getWikiPage()), "North");
        JTabbedPane tabbedPane = new JTabbedPane();
        if (this.isProxyEnabled()) {
            tabbedPane.add("Proxy", this.createProxyPanel());
        }
        tabbedPane.add(this.browserName(), this.createBrowserPanel());
        if (this.isExperimentalEnabled()) {
            tabbedPane.add("Experimental", this.createExperimentalPanel());
        }
        this.add(tabbedPane, "Center");
    }

    private JPanel createExperimentalPanel() {
        VerticalPanel panel = new VerticalPanel();
        JLabel experimentalLabel = new JLabel("EXPERIMENTAL PROPERTIES - USE AT YOUR DISCRETION");
        experimentalLabel.setFont(new Font("Monospaced", 1, 16));
        panel.add(experimentalLabel);
        this.maximizeBrowser = new JCheckBox("Maximize browser window");
        this.maximizeBrowser.setSelected(true);
        panel.add(this.maximizeBrowser);
        this.recreateBrowserOnIterationStart = new JCheckBox("Create a new Browser at the start of each iteration");
        this.recreateBrowserOnIterationStart.setSelected(false);
        panel.add(this.recreateBrowserOnIterationStart);
        this.devMode = new JCheckBox("Development Mode (keep browser opened on error)");
        this.devMode.setSelected(false);
        panel.add(this.devMode);
        return panel;
    }

    private void createPacUrlProxy(JPanel panel, ButtonGroup group) {
        this.pacUrlProxy = new JRadioButton("Automatic proxy configuration URL");
        group.add(this.pacUrlProxy);
        panel.add(this.pacUrlProxy);
        this.pacUrlProxy.addItemListener(this);
        HorizontalPanel pacUrlPanel = new HorizontalPanel();
        this.pacUrl = new JTextField();
        this.pacUrl.setEnabled(false);
        pacUrlPanel.add((Component)this.pacUrl, "Center");
        pacUrlPanel.setBorder(BorderFactory.createEmptyBorder(0, 28, 0, 0));
        panel.add((Component)pacUrlPanel);
    }

    private void createManualProxy(JPanel panel, ButtonGroup group) {
        this.manualProxy = new JRadioButton("Manual proxy configuration");
        group.add(this.manualProxy);
        panel.add(this.manualProxy);
        this.manualProxy.addItemListener(this);
        VerticalPanel manualPanel = new VerticalPanel();
        manualPanel.setBorder(BorderFactory.createEmptyBorder(0, 28, 0, 0));
        this.httpProxyHost = new JTextField();
        this.httpProxyPort = new JFormattedTextField(NUMBER_FORMAT);
        this.httpProxyPort.setText(String.valueOf(8080));
        manualPanel.add(this.createProxyHostAndPortPanel(this.httpProxyHost, this.httpProxyPort, "HTTP Proxy:"));
        this.useHttpSettingsForAllProtocols = new JCheckBox("Use HTTP proxy server for all protocols");
        this.useHttpSettingsForAllProtocols.setSelected(true);
        this.useHttpSettingsForAllProtocols.setEnabled(false);
        this.useHttpSettingsForAllProtocols.addItemListener(this);
        manualPanel.add(this.useHttpSettingsForAllProtocols);
        this.httpsProxyHost = new JTextField();
        this.httpsProxyPort = new JFormattedTextField(NUMBER_FORMAT);
        this.httpsProxyPort.setText(String.valueOf(8080));
        manualPanel.add(this.createProxyHostAndPortPanel(this.httpsProxyHost, this.httpsProxyPort, "SSL Proxy:"));
        this.ftpProxyHost = new JTextField();
        this.ftpProxyPort = new JFormattedTextField(NUMBER_FORMAT);
        this.ftpProxyPort.setText(String.valueOf(8080));
        manualPanel.add(this.createProxyHostAndPortPanel(this.ftpProxyHost, this.ftpProxyPort, "FTP Proxy:"));
        this.socksProxyHost = new JTextField();
        this.socksProxyPort = new JFormattedTextField(NUMBER_FORMAT);
        this.socksProxyPort.setText(String.valueOf(8080));
        manualPanel.add(this.createProxyHostAndPortPanel(this.socksProxyHost, this.socksProxyPort, "SOCKS Proxy:"));
        manualPanel.add(this.createNoProxyPanel());
        panel.add((Component)manualPanel);
    }

    private JPanel createNoProxyPanel() {
        VerticalPanel noProxyPanel = new VerticalPanel();
        JLabel noProxyListLabel = new JLabel("No Proxy for:");
        noProxyPanel.add(noProxyListLabel);
        this.noProxyList = new JTextArea(3, 10);
        this.noProxyList.setText(DEFAULT_NO_PROXY_LIST);
        this.noProxyList.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.noProxyList.setEnabled(false);
        noProxyPanel.add(this.noProxyList);
        JLabel noProxyExample = new JLabel("Example: .jmeter.org, .com.au, 192.168.1.0/24");
        noProxyPanel.add(noProxyExample);
        return noProxyPanel;
    }

    private JPanel createProxyHostAndPortPanel(JTextField proxyHost, JTextField proxyPort, String label) {
        HorizontalPanel httpPanel = new HorizontalPanel();
        JLabel httpProxyHostLabel = new JLabel(label);
        httpPanel.add(httpProxyHostLabel);
        httpPanel.add(proxyHost);
        proxyHost.setEnabled(false);
        JLabel httpProxyPortLabel = new JLabel("Port:");
        httpPanel.add(httpProxyPortLabel);
        httpPanel.add(proxyPort);
        proxyPort.setEnabled(false);
        return httpPanel;
    }

    private void createSystemProxy(JPanel panel, ButtonGroup group) {
        this.systemProxy = new JRadioButton("Use system proxy settings");
        group.add(this.systemProxy);
        panel.add(this.systemProxy);
    }

    private void createAutoDetectProxy(JPanel panel, ButtonGroup group) {
        this.autoDetectProxy = new JRadioButton("Auto-detect proxy settings for this network");
        group.add(this.autoDetectProxy);
        panel.add(this.autoDetectProxy);
    }

    private void createDirectProxy(JPanel panel, ButtonGroup group) {
        this.directProxy = new JRadioButton("No proxy");
        group.add(this.directProxy);
        panel.add(this.directProxy);
    }

    protected JPanel createProxyPanel() {
        VerticalPanel mainPanel = new VerticalPanel();
        ButtonGroup group = new ButtonGroup();
        this.createDirectProxy((JPanel)mainPanel, group);
        this.createAutoDetectProxy((JPanel)mainPanel, group);
        this.createSystemProxy((JPanel)mainPanel, group);
        this.createManualProxy((JPanel)mainPanel, group);
        this.createPacUrlProxy((JPanel)mainPanel, group);
        this.systemProxy.setSelected(true);
        return mainPanel;
    }

    protected abstract JPanel createBrowserPanel();

    protected abstract String browserName();

    protected abstract String getWikiPage();

    protected boolean isProxyEnabled() {
        return false;
    }

    protected boolean isExperimentalEnabled() {
        return false;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.pacUrlProxy) {
            this.pacUrl.setEnabled(itemEvent.getStateChange() == 1);
        } else if (itemEvent.getSource() == this.manualProxy) {
            this.httpProxyHost.setEnabled(itemEvent.getStateChange() == 1);
            this.httpProxyPort.setEnabled(itemEvent.getStateChange() == 1);
            this.useHttpSettingsForAllProtocols.setEnabled(itemEvent.getStateChange() == 1);
            this.noProxyList.setEnabled(itemEvent.getStateChange() == 1);
            this.enableOtherProtocolsOnlyIfManualProxySelectedAndUseHttpSettingsIsNotSelected();
        } else if (itemEvent.getSource() == this.useHttpSettingsForAllProtocols) {
            this.enableOtherProtocolsOnlyIfManualProxySelectedAndUseHttpSettingsIsNotSelected();
        }
    }

    private void enableOtherProtocolsOnlyIfManualProxySelectedAndUseHttpSettingsIsNotSelected() {
        boolean enabledState = !this.useHttpSettingsForAllProtocols.isSelected() && this.manualProxy.isSelected();
        this.httpsProxyHost.setEnabled(enabledState);
        this.httpsProxyPort.setEnabled(enabledState);
        this.ftpProxyHost.setEnabled(enabledState);
        this.ftpProxyPort.setEnabled(enabledState);
        this.socksProxyHost.setEnabled(enabledState);
        this.socksProxyPort.setEnabled(enabledState);
    }

    static {
        NUMBER_FORMAT.setGroupingUsed(false);
    }
}

