/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config.gui;

import com.googlecode.jmeter.plugins.webdriver.config.FileDetectorOption;
import com.googlecode.jmeter.plugins.webdriver.config.RemoteCapability;
import com.googlecode.jmeter.plugins.webdriver.config.RemoteDriverConfig;
import com.googlecode.jmeter.plugins.webdriver.config.gui.WebDriverConfigGui;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;

public class RemoteDriverConfigGui
extends WebDriverConfigGui
implements ItemListener,
FocusListener {
    private static final long serialVersionUID = 100L;
    JTextField remoteSeleniumGridText;
    JComboBox capabilitiesComboBox;
    JCheckBox headlessEnabled;
    JCheckBox vncEnabled;
    JCheckBox videoEnabled;
    JCheckBox logEnabled;
    JCheckBox maxBrowser;
    JLabel errorMsg;
    private JComboBox fileDetectorsComboBox;

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel((String)"Remote Driver Config");
    }

    public String getLabelResource() {
        return this.getClass().getCanonicalName();
    }

    @Override
    protected JPanel createBrowserPanel() {
        return this.createProfilePanel();
    }

    @Override
    protected String browserName() {
        return "Remote";
    }

    @Override
    protected String getWikiPage() {
        return "RemoteDriverConfig";
    }

    public TestElement createTestElement() {
        RemoteDriverConfig element = new RemoteDriverConfig();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    @Override
    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof RemoteDriverConfig) {
            RemoteDriverConfig config = (RemoteDriverConfig)element;
            this.remoteSeleniumGridText.setText(config.getSeleniumGridUrl());
            this.capabilitiesComboBox.setSelectedItem((Object)config.getCapability());
            this.fileDetectorsComboBox.setSelectedItem((Object)config.getFileDetectorOption());
            this.getHeadlessEnabled().setSelected(config.isHeadlessEnabled());
            this.getVncEnabled().setSelected(config.isVNCEnabled());
            this.getVideoEnabled().setSelected(config.isVideoEnabled());
            this.getLogEnabled().setSelected(config.isLogEnabled());
            this.getMaxBrowser().setSelected(config.isBrowserMaximized());
        }
    }

    public JCheckBox getHeadlessEnabled() {
        return this.headlessEnabled;
    }

    public JCheckBox getVncEnabled() {
        return this.vncEnabled;
    }

    public JCheckBox getVideoEnabled() {
        return this.videoEnabled;
    }

    public JCheckBox getLogEnabled() {
        return this.logEnabled;
    }

    public JCheckBox getMaxBrowser() {
        return this.maxBrowser;
    }

    @Override
    public void modifyTestElement(TestElement element) {
        super.modifyTestElement(element);
        if (element instanceof RemoteDriverConfig) {
            RemoteDriverConfig config = (RemoteDriverConfig)element;
            config.setSeleniumGridUrl(this.remoteSeleniumGridText.getText());
            config.setCapability((RemoteCapability)((Object)this.capabilitiesComboBox.getSelectedItem()));
            config.setFileDetectorOption((FileDetectorOption)((Object)this.fileDetectorsComboBox.getSelectedItem()));
            config.setHeadlessEnabled(this.getHeadlessEnabled().isSelected());
            config.setVNCEnabled(this.getVncEnabled().isSelected());
            config.setVideoEnabled(this.getVideoEnabled().isSelected());
            config.setLogEnabled(this.getLogEnabled().isSelected());
            config.setBrowserMaximize(this.getMaxBrowser().isSelected());
        }
    }

    private JPanel createProfilePanel() {
        VerticalPanel browserPanel = new VerticalPanel();
        VerticalPanel remotePanel = new VerticalPanel();
        JLabel remoteUrlLabel = new JLabel();
        JLabel capabilitiesLabel = new JLabel();
        JLabel headlessEnabledLabel = new JLabel();
        JLabel vncEnabledLabel = new JLabel();
        JLabel videoEnabledLabel = new JLabel();
        JLabel logEnabledLabel = new JLabel();
        JLabel browserMaxLabel = new JLabel();
        JLabel fileDetectorLabel = new JLabel();
        remoteUrlLabel.setText("Selenium Grid URL");
        this.remoteSeleniumGridText = new JTextField();
        this.remoteSeleniumGridText.setEnabled(true);
        this.remoteSeleniumGridText.addFocusListener(this);
        capabilitiesLabel.setText("Capability");
        this.capabilitiesComboBox = new JComboBox<RemoteCapability>(RemoteCapability.values());
        headlessEnabledLabel.setText("Headless");
        this.headlessEnabled = new JCheckBox("Use Chrome headless mode");
        vncEnabledLabel.setText("VNC");
        this.vncEnabled = new JCheckBox("Enable VNC");
        videoEnabledLabel.setText("Video");
        this.videoEnabled = new JCheckBox("Enable Video Recording of scripts");
        logEnabledLabel.setText("Log");
        this.logEnabled = new JCheckBox("Enable Log capturing");
        browserMaxLabel.setText("Browser");
        this.maxBrowser = new JCheckBox("Run browser in maximized window");
        fileDetectorLabel.setText("File detector");
        this.fileDetectorsComboBox = new JComboBox<FileDetectorOption>(FileDetectorOption.values());
        remotePanel.add(remoteUrlLabel);
        remotePanel.add(this.remoteSeleniumGridText);
        this.errorMsg = new JLabel();
        remotePanel.add(this.errorMsg);
        remotePanel.add(capabilitiesLabel);
        remotePanel.add(this.capabilitiesComboBox);
        remotePanel.add(headlessEnabledLabel);
        remotePanel.add(this.headlessEnabled);
        remotePanel.add(vncEnabledLabel);
        remotePanel.add(this.vncEnabled);
        remotePanel.add(videoEnabledLabel);
        remotePanel.add(this.videoEnabled);
        remotePanel.add(logEnabledLabel);
        remotePanel.add(this.logEnabled);
        remotePanel.add(browserMaxLabel);
        remotePanel.add(this.maxBrowser);
        remotePanel.add(fileDetectorLabel);
        remotePanel.add(this.fileDetectorsComboBox);
        this.errorMsg.setForeground(Color.red);
        browserPanel.add((Component)remotePanel);
        return browserPanel;
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.remoteSeleniumGridText.setText("");
        this.capabilitiesComboBox.setSelectedIndex(2);
        this.fileDetectorsComboBox.setSelectedIndex(1);
        this.headlessEnabled.setSelected(false);
        this.vncEnabled.setSelected(false);
        this.videoEnabled.setSelected(false);
        this.logEnabled.setSelected(false);
        this.maxBrowser.setSelected(false);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.remoteSeleniumGridText.equals(e.getComponent()) && !this.isValidUrl(this.remoteSeleniumGridText.getText())) {
            this.errorMsg.setText("The selenium grid URL is malformed");
        } else {
            this.errorMsg.setText("");
        }
    }

    private boolean isValidUrl(String urlStr) {
        try {
            new URL(urlStr);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    @Override
    protected boolean isProxyEnabled() {
        return false;
    }

    @Override
    protected boolean isExperimentalEnabled() {
        return false;
    }
}

