/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config.gui;

import com.googlecode.jmeter.plugins.webdriver.config.InternetExplorerDriverConfig;
import com.googlecode.jmeter.plugins.webdriver.config.gui.WebDriverConfigGui;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;

public class InternetExplorerDriverConfigGui
extends WebDriverConfigGui {
    private static final long serialVersionUID = 100L;
    JTextField ieServicePath;

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel((String)"Internet Explorer Driver Config");
    }

    public String getLabelResource() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof InternetExplorerDriverConfig) {
            InternetExplorerDriverConfig config = (InternetExplorerDriverConfig)element;
            this.ieServicePath.setText(config.getInternetExplorerDriverPath());
        }
    }

    public TestElement createTestElement() {
        InternetExplorerDriverConfig element = new InternetExplorerDriverConfig();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    @Override
    public void modifyTestElement(TestElement element) {
        super.modifyTestElement(element);
        if (element instanceof InternetExplorerDriverConfig) {
            InternetExplorerDriverConfig config = (InternetExplorerDriverConfig)element;
            config.setInternetExplorerDriverPath(this.ieServicePath.getText());
        }
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.ieServicePath.setText("");
    }

    @Override
    protected JPanel createBrowserPanel() {
        return this.createServicePanel();
    }

    @Override
    protected String browserName() {
        return "Internet Explorer";
    }

    @Override
    protected String getWikiPage() {
        return "InternetExplorerConfig";
    }

    private JPanel createServicePanel() {
        VerticalPanel browserPanel = new VerticalPanel();
        HorizontalPanel ieServicePanel = new HorizontalPanel();
        JLabel ieDriverServiceLabel = new JLabel("Path to Internet Explorer Driver");
        ieServicePanel.add(ieDriverServiceLabel);
        this.ieServicePath = new JTextField();
        ieServicePanel.add(this.ieServicePath);
        browserPanel.add((Component)ieServicePanel);
        return browserPanel;
    }

    @Override
    protected boolean isProxyEnabled() {
        return true;
    }

    @Override
    protected boolean isExperimentalEnabled() {
        return true;
    }
}

