/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config.gui;

import com.googlecode.jmeter.plugins.webdriver.config.FirefoxDriverConfig;
import com.googlecode.jmeter.plugins.webdriver.config.gui.WebDriverConfigGui;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.gui.Grid;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;

public class FirefoxDriverConfigGui
extends WebDriverConfigGui
implements ItemListener {
    private static final long serialVersionUID = 100L;
    JTextField userAgentOverrideText;
    JCheckBox legacyCheckbox;
    JCheckBox acceptInsecureCertsCheckbox;
    JCheckBox headlessCheckbox;
    JCheckBox userAgentOverrideCheckbox;
    JCheckBox ntlmOverrideCheckbox;
    private Grid extensions;
    private Grid preferences;

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel((String)"Firefox Driver Config");
    }

    public String getLabelResource() {
        return this.getClass().getCanonicalName();
    }

    @Override
    protected JPanel createBrowserPanel() {
        return this.createProfilePanel();
    }

    @Override
    protected String browserName() {
        return "Firefox";
    }

    @Override
    protected String getWikiPage() {
        return "FirefoxDriverConfig";
    }

    public TestElement createTestElement() {
        FirefoxDriverConfig element = new FirefoxDriverConfig();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    @Override
    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof FirefoxDriverConfig) {
            FirefoxDriverConfig config = (FirefoxDriverConfig)element;
            this.legacyCheckbox.setSelected(config.isLegacy());
            this.acceptInsecureCertsCheckbox.setSelected(config.isAcceptInsecureCerts());
            this.headlessCheckbox.setSelected(config.isHeadless());
            this.userAgentOverrideCheckbox.setSelected(config.isUserAgentOverridden());
            this.userAgentOverrideText.setText(config.getUserAgentOverride());
            this.userAgentOverrideText.setEnabled(config.isUserAgentOverridden());
            JMeterProperty ext = config.getExtensions();
            if (!(ext instanceof NullProperty)) {
                JMeterPluginsUtils.collectionPropertyToTableModelRows((CollectionProperty)((CollectionProperty)ext), (PowerTableModel)this.extensions.getModel());
            }
            JMeterProperty pref = config.getPreferences();
            if (!(ext instanceof NullProperty)) {
                JMeterPluginsUtils.collectionPropertyToTableModelRows((CollectionProperty)((CollectionProperty)pref), (PowerTableModel)this.preferences.getModel());
            }
        }
    }

    @Override
    public void modifyTestElement(TestElement element) {
        super.modifyTestElement(element);
        if (element instanceof FirefoxDriverConfig) {
            FirefoxDriverConfig config = (FirefoxDriverConfig)element;
            config.setLegacy(this.legacyCheckbox.isSelected());
            config.setAcceptInsecureCerts(this.acceptInsecureCertsCheckbox.isSelected());
            config.setHeadless(this.headlessCheckbox.isSelected());
            config.setUserAgentOverridden(this.userAgentOverrideCheckbox.isSelected());
            config.setNtlmSetting(this.ntlmOverrideCheckbox.isSelected());
            if (this.userAgentOverrideCheckbox.isSelected()) {
                config.setUserAgentOverride(this.userAgentOverrideText.getText());
            }
            config.setExtensions(this.extensions.getModel());
            config.setPreferences(this.preferences.getModel());
        }
    }

    private JPanel createProfilePanel() {
        VerticalPanel firefoxPanel = new VerticalPanel();
        this.legacyCheckbox = new JCheckBox("Legacy mode");
        this.legacyCheckbox.setSelected(false);
        this.legacyCheckbox.setEnabled(true);
        firefoxPanel.add(this.legacyCheckbox);
        this.acceptInsecureCertsCheckbox = new JCheckBox("Accept Insecure Certificates");
        this.acceptInsecureCertsCheckbox.setSelected(false);
        this.acceptInsecureCertsCheckbox.setEnabled(true);
        firefoxPanel.add(this.acceptInsecureCertsCheckbox);
        this.headlessCheckbox = new JCheckBox("Headless");
        this.headlessCheckbox.setSelected(false);
        this.headlessCheckbox.setEnabled(true);
        firefoxPanel.add(this.headlessCheckbox);
        this.userAgentOverrideCheckbox = new JCheckBox("Override User Agent");
        this.userAgentOverrideCheckbox.setSelected(false);
        this.userAgentOverrideCheckbox.setEnabled(true);
        this.userAgentOverrideCheckbox.addItemListener(this);
        firefoxPanel.add(this.userAgentOverrideCheckbox);
        this.userAgentOverrideText = new JTextField();
        this.userAgentOverrideText.setEnabled(false);
        firefoxPanel.add(this.userAgentOverrideText);
        this.ntlmOverrideCheckbox = new JCheckBox("Enable NTLM");
        this.ntlmOverrideCheckbox.setSelected(false);
        this.ntlmOverrideCheckbox.setEnabled(true);
        this.ntlmOverrideCheckbox.addItemListener(this);
        firefoxPanel.add(this.ntlmOverrideCheckbox);
        this.extensions = new Grid("Load Extensions", new String[]{"Path to XPI File"}, new Class[]{String.class}, (Object[])new String[]{""});
        firefoxPanel.add((Component)this.extensions);
        this.preferences = new Grid("Set Preferences", new String[]{"Name", "Value"}, new Class[]{String.class, String.class}, (Object[])new String[]{"", ""});
        firefoxPanel.add((Component)this.preferences);
        VerticalPanel browserPanel = new VerticalPanel();
        browserPanel.add((Component)firefoxPanel);
        return browserPanel;
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.headlessCheckbox.setSelected(false);
        this.userAgentOverrideCheckbox.setSelected(false);
        this.userAgentOverrideText.setText("");
        this.ntlmOverrideCheckbox.setSelected(false);
        this.extensions.getModel().clearData();
        this.preferences.getModel().clearData();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.userAgentOverrideCheckbox) {
            this.userAgentOverrideText.setEnabled(this.userAgentOverrideCheckbox.isSelected());
        }
    }

    @Override
    protected boolean isProxyEnabled() {
        return true;
    }

    @Override
    protected boolean isExperimentalEnabled() {
        return true;
    }
}

