/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config.gui;

import com.googlecode.jmeter.plugins.webdriver.config.ChromeDriverConfig;
import com.googlecode.jmeter.plugins.webdriver.config.gui.WebDriverConfigGui;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;

public class ChromeDriverConfigGui
extends WebDriverConfigGui {
    private static final long serialVersionUID = 100L;
    JTextField chromeServicePath;
    JCheckBox androidEnabled;
    private JCheckBox headlessEnabled;
    private JCheckBox insecureCertsEnabled;
    private JCheckBox incognitoEnabled;
    private JCheckBox noSandboxEnabled;
    JTextField additionalArgs;
    JTextField binaryPath;

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel((String)"Chrome Driver Config");
    }

    public String getLabelResource() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof ChromeDriverConfig) {
            ChromeDriverConfig config = (ChromeDriverConfig)element;
            this.chromeServicePath.setText(config.getChromeDriverPath());
            this.androidEnabled.setSelected(config.isAndroidEnabled());
            this.getHeadlessEnabled().setSelected(config.isHeadlessEnabled());
            this.getInsecureCertsEnabled().setSelected(config.isInsecureCertsEnabled());
            this.getIncognitoEnabled().setSelected(config.isIncognitoEnabled());
            this.getNoSandboxEnabled().setSelected(config.isNoSandboxEnabled());
            this.additionalArgs.setText(config.getAdditionalArgs());
            this.binaryPath.setText(config.getBinaryPath());
        }
    }

    public TestElement createTestElement() {
        ChromeDriverConfig element = new ChromeDriverConfig();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    @Override
    public void modifyTestElement(TestElement element) {
        super.modifyTestElement(element);
        if (element instanceof ChromeDriverConfig) {
            ChromeDriverConfig config = (ChromeDriverConfig)element;
            config.setChromeDriverPath(this.chromeServicePath.getText());
            config.setAndroidEnabled(this.androidEnabled.isSelected());
            config.setHeadlessEnabled(this.getHeadlessEnabled().isSelected());
            config.setInsecureCertsEnabled(this.getInsecureCertsEnabled().isSelected());
            config.setIncognitoEnabled(this.getIncognitoEnabled().isSelected());
            config.setNoSandboxEnabled(this.getNoSandboxEnabled().isSelected());
            config.setAdditionalArgs(this.additionalArgs.getText());
            config.setBinaryPath(this.binaryPath.getText());
        }
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.chromeServicePath.setText("");
        this.androidEnabled.setSelected(false);
        this.getHeadlessEnabled().setSelected(false);
        this.getInsecureCertsEnabled().setSelected(false);
        this.getIncognitoEnabled().setSelected(false);
        this.getNoSandboxEnabled().setSelected(false);
        this.additionalArgs.setText("");
        this.binaryPath.setText("");
    }

    @Override
    protected JPanel createBrowserPanel() {
        return this.createServicePanel();
    }

    @Override
    protected String browserName() {
        return "Chrome";
    }

    @Override
    protected String getWikiPage() {
        return "ChromeDriverConfig";
    }

    private JPanel createServicePanel() {
        VerticalPanel browserPanel = new VerticalPanel();
        HorizontalPanel chromeServicePanel = new HorizontalPanel();
        JLabel chromeDriverServiceLabel = new JLabel("Path to Chrome Driver");
        chromeServicePanel.add(chromeDriverServiceLabel);
        this.chromeServicePath = new JTextField();
        chromeServicePanel.add(this.chromeServicePath);
        browserPanel.add((Component)chromeServicePanel);
        HorizontalPanel binaryPathPanel = new HorizontalPanel();
        JLabel binaryPathLabel = new JLabel("Binary path");
        this.binaryPath = new JTextField();
        binaryPathPanel.add(binaryPathLabel);
        binaryPathPanel.add(this.binaryPath);
        browserPanel.add((Component)binaryPathPanel);
        this.androidEnabled = new JCheckBox("Use Chrome on Android");
        browserPanel.add(this.androidEnabled);
        this.headlessEnabled = new JCheckBox("Use Chrome headless mode");
        browserPanel.add(this.getHeadlessEnabled());
        this.insecureCertsEnabled = new JCheckBox("Allow Insecure Certs");
        browserPanel.add(this.getInsecureCertsEnabled());
        this.incognitoEnabled = new JCheckBox("Run in Incognito mode");
        browserPanel.add(this.getIncognitoEnabled());
        this.noSandboxEnabled = new JCheckBox("Run in No sandbox mode");
        browserPanel.add(this.getNoSandboxEnabled());
        HorizontalPanel additionalArgsPanel = new HorizontalPanel();
        JLabel additionalArgsLabel = new JLabel("Additional arguments");
        this.additionalArgs = new JTextField();
        additionalArgsPanel.add(additionalArgsLabel);
        additionalArgsPanel.add(this.additionalArgs);
        browserPanel.add((Component)additionalArgsPanel);
        return browserPanel;
    }

    @Override
    protected boolean isProxyEnabled() {
        return true;
    }

    @Override
    protected boolean isExperimentalEnabled() {
        return true;
    }

    public JCheckBox getHeadlessEnabled() {
        return this.headlessEnabled;
    }

    public JCheckBox getInsecureCertsEnabled() {
        return this.insecureCertsEnabled;
    }

    public JCheckBox getIncognitoEnabled() {
        return this.incognitoEnabled;
    }

    public JCheckBox getNoSandboxEnabled() {
        return this.noSandboxEnabled;
    }
}

