/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config;

import com.googlecode.jmeter.plugins.webdriver.config.FileDetectorOption;
import com.googlecode.jmeter.plugins.webdriver.config.RemoteCapability;
import com.googlecode.jmeter.plugins.webdriver.config.RemoteDesiredCapabilitiesFactory;
import com.googlecode.jmeter.plugins.webdriver.config.WebDriverConfig;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.UselessFileDetector;

public class RemoteDriverConfig
extends WebDriverConfig<RemoteWebDriver> {
    private static final long serialVersionUID = 100L;
    private static final String REMOTE_SELENIUM_GRID_URL = "RemoteDriverConfig.general.selenium.grid.url";
    private static final String REMOTE_CAPABILITY = "RemoteDriverConfig.general.selenium.capability";
    private static final String REMOTE_FILE_DETECTOR = "RemoteDriverConfig.general.selenium.file.detector";
    private static final String HEADLESS_ENABLED = "RemoteDriverConfig.chrome.headless_enabled";
    private static final String VNC_ENABLED = "RemoteDriverConfig.chrome.vnc_enabled";
    private static final String VIDEO_ENABLED = "RemoteDriverConfig.chrome.video_enabled";
    private static final String LOG_ENABLED = "RemoteDriverConfig.chrome.log_enabled";
    private static final String BROWSER_MAXIMIZE = "RemoteDriverConfig.chrome.browser.maximize";
    private static final Logger LOGGER = LoggingManager.getLoggerForClass();

    Capabilities createCapabilities() {
        DesiredCapabilities capabilities = RemoteDesiredCapabilitiesFactory.build(this.getCapability());
        capabilities.setCapability("proxy", (Object)this.createProxy());
        capabilities.setJavascriptEnabled(true);
        if (this.getCapability().equals((Object)RemoteCapability.CHROME) && this.isHeadlessEnabled()) {
            ChromeOptions chromeOptions = new ChromeOptions();
            chromeOptions.addArguments(new String[]{"--headless"});
            capabilities.setCapability("goog:chromeOptions", (Object)chromeOptions);
        } else if (this.getCapability().equals((Object)RemoteCapability.CHROME)) {
            ChromeOptions chromeOptions = new ChromeOptions();
            if (this.isBrowserMaximized()) {
                chromeOptions.addArguments(new String[]{"--start-maximized"});
            }
            if (this.isLogEnabled()) {
                chromeOptions.setCapability("enableLog", true);
            }
            if (this.isVideoEnabled()) {
                chromeOptions.setCapability("enableVideo", true);
            }
            if (this.isVNCEnabled()) {
                chromeOptions.setCapability("enableVNC", true);
            }
            capabilities.setCapability("goog:chromeOptions", (Object)chromeOptions);
        }
        return capabilities;
    }

    @Override
    protected RemoteWebDriver createBrowser() {
        try {
            RemoteWebDriver driver = new RemoteWebDriver(new URL(this.getSeleniumGridUrl()), this.createCapabilities());
            driver.setFileDetector(this.createFileDetector());
            LOGGER.debug("Created web driver with " + this.createFileDetector().getClass().getName());
            return driver;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setSeleniumGridUrl(String seleniumUrl) {
        this.setProperty(REMOTE_SELENIUM_GRID_URL, seleniumUrl);
    }

    public String getSeleniumGridUrl() {
        return this.getPropertyAsString(REMOTE_SELENIUM_GRID_URL);
    }

    public RemoteCapability getCapability() {
        return RemoteCapability.valueOf(this.getPropertyAsString(REMOTE_CAPABILITY));
    }

    public void setCapability(RemoteCapability selectedCapability) {
        this.setProperty(REMOTE_CAPABILITY, selectedCapability.name());
    }

    public FileDetectorOption getFileDetectorOption() {
        String fileDetectorString = this.getPropertyAsString(REMOTE_FILE_DETECTOR);
        if (StringUtils.isBlank((CharSequence)fileDetectorString)) {
            LOGGER.warn("No remote file detector configured, reverting to default of useless file detector");
            return FileDetectorOption.USELESS;
        }
        return FileDetectorOption.valueOf(fileDetectorString);
    }

    public void setFileDetectorOption(FileDetectorOption fileDetectorOption) {
        this.setProperty(REMOTE_FILE_DETECTOR, fileDetectorOption.name());
    }

    protected FileDetector createFileDetector() {
        try {
            return this.getFileDetectorOption().getClazz().newInstance();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot create a file detector of type " + this.getFileDetectorOption().getClazz().getCanonicalName() + ", reverting to default of useless file detector");
            return new UselessFileDetector();
        }
    }

    public boolean isHeadlessEnabled() {
        return this.getPropertyAsBoolean(HEADLESS_ENABLED);
    }

    public void setHeadlessEnabled(boolean enabled) {
        this.setProperty(HEADLESS_ENABLED, enabled);
    }

    public boolean isVNCEnabled() {
        return this.getPropertyAsBoolean(VNC_ENABLED);
    }

    public void setVNCEnabled(boolean enabled) {
        this.setProperty(VNC_ENABLED, enabled);
    }

    public boolean isVideoEnabled() {
        return this.getPropertyAsBoolean(VIDEO_ENABLED);
    }

    public void setVideoEnabled(boolean enabled) {
        this.setProperty(VIDEO_ENABLED, enabled);
    }

    public boolean isLogEnabled() {
        return this.getPropertyAsBoolean(LOG_ENABLED);
    }

    public void setLogEnabled(boolean enabled) {
        this.setProperty(LOG_ENABLED, enabled);
    }

    @Override
    public boolean isBrowserMaximized() {
        return this.getPropertyAsBoolean(BROWSER_MAXIMIZE);
    }

    public void setBrowserMaximize(boolean enabled) {
        this.setProperty(BROWSER_MAXIMIZE, enabled);
    }
}

