/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config;

import com.googlecode.jmeter.plugins.webdriver.config.WebDriverConfig;
import java.io.File;
import java.util.ArrayList;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.remote.DesiredCapabilities;

public class FirefoxDriverConfig
extends WebDriverConfig<FirefoxDriver> {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 100L;
    private static final String GENERAL_USERAGENT_OVERRIDE = "FirefoxDriverConfig.general.useragent.override";
    private static final String ENABLE_USERAGENT_OVERRIDE = "FirefoxDriverConfig.general.useragent.override.enabled";
    private static final String ENABLE_LEGACY = "FirefoxDriverConfig.general.legacy";
    private static final String ENABLE_ACCEPT_INSECURE_CERTS = "FirefoxDriverConfig.general.accept-insecure-certs";
    private static final String ENABLE_HEADLESS = "FirefoxDriverConfig.general.headless";
    private static final String ENABLE_NTML = "FirefoxDriverConfig.network.negotiate-auth.allow-insecure-ntlm-v1";
    private static final String EXTENSIONS_TO_LOAD = "FirefoxDriverConfig.general.extensions";
    private static final String PREFERENCES = "FirefoxDriverConfig.general.preferences";

    Capabilities createCapabilities() {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setCapability("proxy", (Object)this.createProxy());
        return capabilities;
    }

    FirefoxProfile createProfile() {
        String ntlmOverride;
        FirefoxProfile profile = new FirefoxProfile();
        profile.setPreference("app.update.enabled", false);
        String userAgentOverride = this.getUserAgentOverride();
        if (StringUtils.isNotEmpty((CharSequence)userAgentOverride)) {
            profile.setPreference("general.useragent.override", userAgentOverride);
        }
        if (StringUtils.isNotEmpty((CharSequence)(ntlmOverride = this.getNtlmSetting()))) {
            profile.setPreference("network.negotiate-auth.allow-insecure-ntlm-v1", true);
        }
        this.addExtensions(profile);
        this.setPreferences(profile);
        return profile;
    }

    private void addExtensions(FirefoxProfile profile) {
        JMeterProperty property = this.getProperty(EXTENSIONS_TO_LOAD);
        if (property instanceof NullProperty) {
            return;
        }
        CollectionProperty rows = (CollectionProperty)property;
        for (int i = 0; i < rows.size(); ++i) {
            ArrayList row = (ArrayList)rows.get(i).getObjectValue();
            String filename = ((JMeterProperty)row.get(0)).getStringValue();
            profile.addExtension(new File(filename));
        }
    }

    private void setPreferences(FirefoxProfile profile) {
        JMeterProperty property = this.getProperty(PREFERENCES);
        if (property instanceof NullProperty) {
            return;
        }
        CollectionProperty rows = (CollectionProperty)property;
        block8: for (int i = 0; i < rows.size(); ++i) {
            String value;
            ArrayList row = (ArrayList)rows.get(i).getObjectValue();
            String name = ((JMeterProperty)row.get(0)).getStringValue();
            switch (value = ((JMeterProperty)row.get(1)).getStringValue()) {
                case "true": {
                    profile.setPreference(name, true);
                    continue block8;
                }
                case "false": {
                    profile.setPreference(name, false);
                    continue block8;
                }
                default: {
                    profile.setPreference(name, value);
                }
            }
        }
    }

    @Override
    protected FirefoxDriver createBrowser() {
        FirefoxOptions desiredCapabilities = new FirefoxOptions(this.createCapabilities());
        desiredCapabilities.setCapability("firefox_profile", (Object)this.createProfile());
        desiredCapabilities.setHeadless(this.isHeadless());
        desiredCapabilities.setAcceptInsecureCerts(this.isAcceptInsecureCerts());
        desiredCapabilities.setLegacy(this.isLegacy());
        return new FirefoxDriver((GeckoDriverService)new GeckoDriverService.Builder().usingFirefoxBinary(new FirefoxBinary()).build(), desiredCapabilities);
    }

    public boolean isLegacy() {
        return this.getPropertyAsBoolean(ENABLE_LEGACY);
    }

    public void setLegacy(boolean legacy) {
        this.setProperty(ENABLE_LEGACY, legacy);
    }

    public boolean isAcceptInsecureCerts() {
        return this.getPropertyAsBoolean(ENABLE_ACCEPT_INSECURE_CERTS);
    }

    public void setAcceptInsecureCerts(boolean acceptInsecureCerts) {
        this.setProperty(ENABLE_ACCEPT_INSECURE_CERTS, acceptInsecureCerts);
    }

    public boolean isHeadless() {
        return this.getPropertyAsBoolean(ENABLE_HEADLESS);
    }

    public void setHeadless(boolean headless) {
        this.setProperty(ENABLE_HEADLESS, headless);
    }

    public void setUserAgentOverride(String userAgent) {
        this.setProperty(GENERAL_USERAGENT_OVERRIDE, userAgent);
    }

    public String getUserAgentOverride() {
        return this.getPropertyAsString(GENERAL_USERAGENT_OVERRIDE);
    }

    public boolean isUserAgentOverridden() {
        return this.getPropertyAsBoolean(ENABLE_USERAGENT_OVERRIDE);
    }

    public void setUserAgentOverridden(boolean userAgentOverridden) {
        this.setProperty(ENABLE_USERAGENT_OVERRIDE, userAgentOverridden);
    }

    public void setNtlmSetting(boolean ntlm) {
        this.setProperty(ENABLE_NTML, ntlm);
    }

    public String getNtlmSetting() {
        return this.getPropertyAsString(ENABLE_NTML);
    }

    public void setExtensions(PowerTableModel model) {
        CollectionProperty prop = JMeterPluginsUtils.tableModelRowsToCollectionProperty((PowerTableModel)model, (String)EXTENSIONS_TO_LOAD);
        this.setProperty((JMeterProperty)prop);
    }

    public void setPreferences(PowerTableModel model) {
        CollectionProperty prop = JMeterPluginsUtils.tableModelRowsToCollectionProperty((PowerTableModel)model, (String)PREFERENCES);
        this.setProperty((JMeterProperty)prop);
    }

    public JMeterProperty getExtensions() {
        return this.getProperty(EXTENSIONS_TO_LOAD);
    }

    public JMeterProperty getPreferences() {
        return this.getProperty(PREFERENCES);
    }
}

