/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config;

import com.googlecode.jmeter.plugins.webdriver.config.WebDriverConfig;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ChromeDriverConfig
extends WebDriverConfig<ChromeDriver> {
    private static final long serialVersionUID = 100L;
    private static final Logger LOGGER = LoggingManager.getLoggerForClass();
    private static final String CHROME_SERVICE_PATH = "ChromeDriverConfig.chromedriver_path";
    private static final String ANDROID_ENABLED = "ChromeDriverConfig.android_enabled";
    private static final String HEADLESS_ENABLED = "ChromeDriverConfig.headless_enabled";
    private static final String INSECURECERTS_ENABLED = "ChromeDriverConfig.insecurecerts_enabled";
    private static final String INCOGNITO_ENABLED = "ChromeDriverConfig.incognito_enabled";
    private static final String NO_SANDBOX_ENABLED = "ChromeDriverConfig.no_sandbox_enabled";
    private static final String ADDITIONAL_ARGS = "ChromeDriverConfig.additional_args";
    private static final String BINARY_PATH = "ChromeDriverConfig.binary_path";
    private static final Map<String, ChromeDriverService> services = new ConcurrentHashMap<String, ChromeDriverService>();

    public void setChromeDriverPath(String path) {
        this.setProperty(CHROME_SERVICE_PATH, path);
    }

    public String getChromeDriverPath() {
        return this.getPropertyAsString(CHROME_SERVICE_PATH);
    }

    public void setBinaryPath(String binaryPath) {
        this.setProperty(BINARY_PATH, binaryPath);
    }

    public String getBinaryPath() {
        return this.getPropertyAsString(BINARY_PATH);
    }

    Capabilities createCapabilities() {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setCapability("proxy", (Object)this.createProxy());
        LoggingPreferences logPrefs = new LoggingPreferences();
        logPrefs.enable("browser", Level.ALL);
        capabilities.setCapability("loggingPrefs", (Object)logPrefs);
        String additionalArgs = this.trimmed(this.getAdditionalArgs());
        String binaryPath = this.trimmed(this.getBinaryPath());
        if (this.isAndroidEnabled() || this.isHeadlessEnabled() || this.isIncognitoEnabled() || this.isNoSandboxEnabled() || null != additionalArgs && !additionalArgs.isEmpty() || null != binaryPath && !binaryPath.isEmpty()) {
            ChromeOptions chromeOptions = new ChromeOptions();
            if (this.isAndroidEnabled()) {
                chromeOptions.setExperimentalOption("androidPackage", (Object)"com.android.chrome");
            }
            if (this.isHeadlessEnabled()) {
                chromeOptions.addArguments(new String[]{"--headless"});
            }
            if (this.isNoSandboxEnabled()) {
                chromeOptions.addArguments(new String[]{"--no-sandbox"});
            }
            if (this.isIncognitoEnabled()) {
                chromeOptions.addArguments(new String[]{"--incognito"});
            }
            if (null != additionalArgs && !additionalArgs.isEmpty()) {
                chromeOptions.addArguments(additionalArgs.split("\\s+"));
            }
            if (null != binaryPath && !binaryPath.isEmpty()) {
                chromeOptions.setBinary(binaryPath);
            }
            capabilities.setCapability("goog:chromeOptions", (Object)chromeOptions);
        }
        if (this.isInsecureCertsEnabled()) {
            capabilities.setCapability("acceptInsecureCerts", true);
        }
        return capabilities;
    }

    private String trimmed(String str) {
        return null == str ? null : str.trim();
    }

    Map<String, ChromeDriverService> getServices() {
        return services;
    }

    @Override
    protected ChromeDriver createBrowser() {
        ChromeDriverService service = this.getThreadService();
        return service != null ? new ChromeDriver(service, this.createCapabilities()) : null;
    }

    @Override
    public void quitBrowser(ChromeDriver browser) {
        super.quitBrowser(browser);
        ChromeDriverService service = services.remove(this.currentThreadName());
        if (service != null && service.isRunning()) {
            service.stop();
        }
    }

    private ChromeDriverService getThreadService() {
        ChromeDriverService service = services.get(this.currentThreadName());
        if (service != null) {
            return service;
        }
        try {
            service = (ChromeDriverService)((ChromeDriverService.Builder)new ChromeDriverService.Builder().usingDriverExecutable(new File(this.getChromeDriverPath()))).build();
            service.start();
            services.put(this.currentThreadName(), service);
        }
        catch (IOException e) {
            LOGGER.error("Failed to start chrome service");
            service = null;
        }
        return service;
    }

    public boolean isAndroidEnabled() {
        return this.getPropertyAsBoolean(ANDROID_ENABLED);
    }

    public void setAndroidEnabled(boolean enabled) {
        this.setProperty(ANDROID_ENABLED, enabled);
    }

    public boolean isHeadlessEnabled() {
        return this.getPropertyAsBoolean(HEADLESS_ENABLED);
    }

    public void setHeadlessEnabled(boolean enabled) {
        this.setProperty(HEADLESS_ENABLED, enabled);
    }

    public boolean isInsecureCertsEnabled() {
        return this.getPropertyAsBoolean(INSECURECERTS_ENABLED);
    }

    public void setInsecureCertsEnabled(boolean enabled) {
        this.setProperty(INSECURECERTS_ENABLED, enabled);
    }

    public boolean isIncognitoEnabled() {
        return this.getPropertyAsBoolean(INCOGNITO_ENABLED);
    }

    public void setIncognitoEnabled(boolean enabled) {
        this.setProperty(INCOGNITO_ENABLED, enabled);
    }

    public boolean isNoSandboxEnabled() {
        return this.getPropertyAsBoolean(NO_SANDBOX_ENABLED);
    }

    public void setNoSandboxEnabled(boolean enabled) {
        this.setProperty(NO_SANDBOX_ENABLED, enabled);
    }

    public String getAdditionalArgs() {
        return this.getPropertyAsString(ADDITIONAL_ARGS);
    }

    public void setAdditionalArgs(String additionalArgs) {
        this.setProperty(ADDITIONAL_ARGS, additionalArgs);
    }
}

