/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.webdriver.phantomjs;

import com.googlecode.jmeter.plugins.webdriver.config.WebDriverConfig;
import org.apache.jmeter.testelement.ThreadListener;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class PhantomJSDriverConfig
extends WebDriverConfig<PhantomJSDriver>
implements ThreadListener {
    private static final long serialVersionUID = 100L;
    private static final String PHANTOMJS_EXECUTABLE_PATH_PROPERTY_KEY = "PhantomJSDriverConfig.phantomjs_path";
    private static final String PHANTOMJS_CLI_ARG_PROPERTY_KEY = "PhantomJSDriverConfig.phantomjs_cli_args";
    private static final String PHANTOMJS_GHOSTDRIVER_CLI_ARG_PROPERTY_KEY = "PhantomJSDriverConfig.phantomjs_ghostdriver_cli_args";

    public String getPhantomJsExecutablePath() {
        return this.getPropertyAsString(PHANTOMJS_EXECUTABLE_PATH_PROPERTY_KEY);
    }

    public void setPhantomJsExecutablePath(String value) {
        this.setProperty(PHANTOMJS_EXECUTABLE_PATH_PROPERTY_KEY, value);
    }

    public String getPhantomJsCliArgs() {
        return this.getPropertyAsString(PHANTOMJS_CLI_ARG_PROPERTY_KEY);
    }

    public void setPhantomJsCliArgs(String value) {
        this.setProperty(PHANTOMJS_CLI_ARG_PROPERTY_KEY, value);
    }

    public String getPhantomJsGhostdriverCliArgs() {
        return this.getPropertyAsString(PHANTOMJS_GHOSTDRIVER_CLI_ARG_PROPERTY_KEY);
    }

    public void setPhantomJsGhostdriverCliArgs(String value) {
        this.setProperty(PHANTOMJS_GHOSTDRIVER_CLI_ARG_PROPERTY_KEY, value);
    }

    @Override
    public void threadStarted() {
        if (this.hasThreadBrowser()) {
            return;
        }
        this.setThreadBrowser(this.createBrowser());
    }

    protected Capabilities createCapabilities() {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setCapability("proxy", (Object)this.createProxy());
        capabilities.setCapability("phantomjs.binary.path", this.getPhantomJsExecutablePath());
        if (this.getPhantomJsCliArgs() != null && this.getPhantomJsCliArgs().trim().length() > 0) {
            capabilities.setCapability("phantomjs.cli.args", (Object)this.cliParamsToStringArray(this.getPhantomJsCliArgs()));
        }
        if (this.getPhantomJsGhostdriverCliArgs() != null && this.getPhantomJsGhostdriverCliArgs().trim().length() > 0) {
            capabilities.setCapability("phantomjs.ghostdriver.cli.args", (Object)this.cliParamsToStringArray(this.getPhantomJsGhostdriverCliArgs()));
        }
        return capabilities;
    }

    @Override
    public void threadFinished() {
        PhantomJSDriver phantomJsDriver = (PhantomJSDriver)this.removeThreadBrowser();
        if (phantomJsDriver != null) {
            phantomJsDriver.quit();
        }
    }

    @Override
    protected PhantomJSDriver createBrowser() {
        return new PhantomJSDriver(this.createCapabilities());
    }

    private String[] cliParamsToStringArray(String params) {
        String[] sSplit = new String[]{""};
        if (params != null && params.trim().length() > 0) {
            sSplit = params.split(",");
            for (int i = 0; i < sSplit.length; ++i) {
                String s = sSplit[i];
                sSplit[i] = s = s.trim();
            }
        }
        return sSplit;
    }
}

