/*
 * Decompiled with CFR 0.152.
 */
package io.github.ningyu.jmeter.plugin.dubbo.sample;

import io.github.ningyu.jmeter.plugin.dubbo.sample.DubboSample;
import io.github.ningyu.jmeter.plugin.dubbo.sample.RegistryServerSync;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.utils.ReferenceConfigCache;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.RegistryService;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ProviderService
implements Serializable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = -750353929981409079L;
    ConcurrentMap<String, Map<String, URL>> providerUrls = null;
    private static ConcurrentMap<String, ProviderService> cache = new ConcurrentHashMap<String, ProviderService>();

    public static ProviderService get(String key) {
        ProviderService service = (ProviderService)cache.get(key);
        if (service == null) {
            cache.putIfAbsent(key, new ProviderService());
            service = (ProviderService)cache.get(key);
        }
        return service;
    }

    public Map<String, URL> findByService(String serviceName) {
        return this.providerUrls == null ? null : (Map)this.providerUrls.get(serviceName);
    }

    public List<String> getProviders(String protocol, String address, String group) throws RuntimeException {
        if (protocol.equals("zookeeper") || protocol.equals("nacos") || protocol.equals("redis")) {
            return this.executeRegistry(protocol, address, group);
        }
        throw new RuntimeException("Registry Protocol please use zookeeper or nacos or redis!");
    }

    private List<String> executeTelnet() throws RuntimeException {
        throw new RuntimeException();
    }

    private List<String> executeRegistry(String protocol, String address, String group) throws RuntimeException {
        ReferenceConfig reference = new ReferenceConfig();
        reference.setApplication(DubboSample.application);
        RegistryConfig registry = null;
        switch (protocol) {
            case "zookeeper": {
                registry = new RegistryConfig();
                registry.setProtocol("zookeeper");
                registry.setGroup(group);
                registry.setAddress(address);
                reference.setRegistry(registry);
                break;
            }
            case "nacos": {
                registry = new RegistryConfig();
                registry.setProtocol("nacos");
                registry.setGroup(group);
                registry.setAddress(address);
                reference.setRegistry(registry);
                break;
            }
            case "redis": {
                registry = new RegistryConfig();
                registry.setProtocol("redis");
                registry.setGroup(group);
                registry.setAddress(address);
                reference.setRegistry(registry);
            }
        }
        reference.setInterface("org.apache.dubbo.registry.RegistryService");
        try {
            ReferenceConfigCache cache = ReferenceConfigCache.getCache((String)(address + "_" + group), (ReferenceConfigCache.KeyGenerator)new ReferenceConfigCache.KeyGenerator(){

                public String generateKey(ReferenceConfigBase<?> referenceConfig) {
                    return referenceConfig.toString();
                }
            });
            RegistryService registryService = (RegistryService)cache.get((ReferenceConfigBase)reference);
            if (registryService == null) {
                throw new RuntimeException("Can't get the interface list, please check if the address is wrong!");
            }
            RegistryServerSync registryServerSync = RegistryServerSync.get(address + "_" + group);
            registryService.subscribe(RegistryServerSync.SUBSCRIBE, (NotifyListener)registryServerSync);
            ArrayList<String> ret = new ArrayList<String>();
            this.providerUrls = (ConcurrentMap)registryServerSync.getRegistryCache().get("providers");
            if (this.providerUrls != null) {
                ret.addAll(this.providerUrls.keySet());
            }
            registryService.unsubscribe(RegistryServerSync.SUBSCRIBE, (NotifyListener)registryServerSync);
            return ret;
        }
        catch (Exception e) {
            log.error("get provider list is error!", (Throwable)e);
            throw new RuntimeException("Can't get the interface list, please check if the address is wrong!", e);
        }
    }
}

