/*
 * Decompiled with CFR 0.152.
 */
package io.github.ningyu.jmeter.plugin.dubbo.sample;

import io.github.ningyu.jmeter.plugin.dubbo.sample.MethodArgument;
import io.github.ningyu.jmeter.plugin.util.ClassUtils;
import io.github.ningyu.jmeter.plugin.util.Constants;
import io.github.ningyu.jmeter.plugin.util.ErrorCode;
import io.github.ningyu.jmeter.plugin.util.JsonUtils;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.utils.ReferenceConfigCache;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class DubboSample
extends AbstractSampler
implements Interruptible {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = -6794913295411458705L;
    public static ApplicationConfig application = new ApplicationConfig("DubboSample");

    public SampleResult sample(Entry entry) {
        SampleResult res = new SampleResult();
        res.setSampleLabel(this.getName());
        res.setSamplerData(this.getSampleData());
        res.setResponseData(JsonUtils.toJson(this.callDubbo(res)), StandardCharsets.UTF_8.name());
        res.setDataType("text");
        return res;
    }

    private String getSampleData() {
        log.info("sample\u4e2d\u7684\u5b9e\u4f8bid" + ((Object)((Object)this)).toString() + ",element\u540d\u79f0" + this.getName());
        StringBuilder sb = new StringBuilder();
        sb.append("Registry Protocol: ").append(Constants.getRegistryProtocol((TestElement)this)).append("\n");
        sb.append("Address: ").append(Constants.getAddress((TestElement)this)).append("\n");
        sb.append("RPC Protocol: ").append(Constants.getRpcProtocol((TestElement)this)).append("\n");
        sb.append("Timeout: ").append(Constants.getTimeout((TestElement)this)).append("\n");
        sb.append("Version: ").append(Constants.getVersion((TestElement)this)).append("\n");
        sb.append("Retries: ").append(Constants.getRetries((TestElement)this)).append("\n");
        sb.append("Cluster: ").append(Constants.getCluster((TestElement)this)).append("\n");
        sb.append("Group: ").append(Constants.getGroup((TestElement)this)).append("\n");
        sb.append("Connections: ").append(Constants.getConnections((TestElement)this)).append("\n");
        sb.append("LoadBalance: ").append(Constants.getLoadbalance((TestElement)this)).append("\n");
        sb.append("Async: ").append(Constants.getAsync((TestElement)this)).append("\n");
        sb.append("Interface: ").append(Constants.getInterface((TestElement)this)).append("\n");
        sb.append("Method: ").append(Constants.getMethod((TestElement)this)).append("\n");
        sb.append("Method Args: ").append(Constants.getMethodArgs((TestElement)this).toString());
        sb.append("Attachment Args: ").append(Constants.getAttachmentArgs((TestElement)this).toString());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object callDubbo(SampleResult res) {
        GenericService genericService;
        String methodName;
        block52: {
            String interfaceName;
            ReferenceConfig reference;
            block51: {
                String async;
                String loadBalance;
                String group;
                String version;
                String cluster;
                String configCenterAddress;
                block50: {
                    String configCenterGroup;
                    block49: {
                        reference = new ReferenceConfig();
                        reference.setApplication(application);
                        String address = Constants.getAddress((TestElement)this);
                        if (StringUtils.isBlank((CharSequence)address)) {
                            this.setResponseError(res, ErrorCode.MISS_ADDRESS);
                            return ErrorCode.MISS_ADDRESS.getMessage();
                        }
                        RegistryConfig registry = null;
                        String rpcProtocol = Constants.getRpcProtocol((TestElement)this).replaceAll("://", "");
                        String protocol = Constants.getRegistryProtocol((TestElement)this);
                        String registryGroup = Constants.getRegistryGroup((TestElement)this);
                        Integer registryTimeout = null;
                        try {
                            if (!StringUtils.isBlank((CharSequence)Constants.getRegistryTimeout((TestElement)this))) {
                                registryTimeout = Integer.valueOf(Constants.getRegistryTimeout((TestElement)this));
                            }
                        }
                        catch (NumberFormatException e) {
                            this.setResponseError(res, ErrorCode.TIMEOUT_ERROR);
                            return ErrorCode.TIMEOUT_ERROR.getMessage();
                        }
                        if (StringUtils.isBlank((CharSequence)protocol) || "none".equals(protocol)) {
                            StringBuffer sb = new StringBuffer();
                            sb.append(Constants.getRpcProtocol((TestElement)this)).append(Constants.getAddress((TestElement)this)).append("/").append(Constants.getInterface((TestElement)this));
                            log.debug("rpc invoker url : " + sb.toString());
                            reference.setUrl(sb.toString());
                        } else if ("simple".equals(protocol)) {
                            registry = new RegistryConfig();
                            registry.setAddress(address);
                            reference.setProtocol(rpcProtocol);
                            reference.setRegistry(registry);
                        } else {
                            registry = new RegistryConfig();
                            registry.setProtocol(protocol);
                            registry.setGroup(registryGroup);
                            registry.setAddress(address);
                            if (registryTimeout != null) {
                                registry.setTimeout(registryTimeout);
                            }
                            reference.setProtocol(rpcProtocol);
                            reference.setRegistry(registry);
                        }
                        try {
                            String configCenterProtocol = Constants.getConfigCenterProtocol((TestElement)this);
                            if (StringUtils.isBlank((CharSequence)configCenterProtocol)) break block49;
                            configCenterGroup = Constants.getConfigCenterGroup((TestElement)this);
                            String configCenterNamespace = Constants.getConfigCenterNamespace((TestElement)this);
                            configCenterAddress = Constants.getConfigCenterAddress((TestElement)this);
                            if (StringUtils.isBlank((CharSequence)configCenterAddress)) {
                                this.setResponseError(res, ErrorCode.MISS_ADDRESS);
                                return ErrorCode.MISS_ADDRESS.getMessage();
                            }
                            Long configCenterTimeout = null;
                            try {
                                if (!StringUtils.isBlank((CharSequence)Constants.getConfigCenterTimeout((TestElement)this))) {
                                    configCenterTimeout = Long.valueOf(Constants.getConfigCenterTimeout((TestElement)this));
                                }
                            }
                            catch (NumberFormatException e) {
                                this.setResponseError(res, ErrorCode.TIMEOUT_ERROR);
                                return ErrorCode.TIMEOUT_ERROR.getMessage();
                            }
                            ConfigCenterConfig configCenter = new ConfigCenterConfig();
                            configCenter.setProtocol(configCenterProtocol);
                            configCenter.setGroup(configCenterGroup);
                            configCenter.setNamespace(configCenterNamespace);
                            configCenter.setAddress(configCenterAddress);
                            if (configCenterTimeout != null) {
                                configCenter.setTimeout(configCenterTimeout);
                            }
                            reference.setConfigCenter(configCenter);
                        }
                        catch (IllegalStateException e) {
                            this.setResponseError(res, ErrorCode.DUPLICATE_CONFIGCENTERCONFIG);
                            return ErrorCode.DUPLICATE_CONFIGCENTERCONFIG.getMessage();
                        }
                    }
                    interfaceName = Constants.getInterface((TestElement)this);
                    if (!StringUtils.isBlank((CharSequence)interfaceName)) break block50;
                    this.setResponseError(res, ErrorCode.MISS_INTERFACE);
                    configCenterGroup = ErrorCode.MISS_INTERFACE.getMessage();
                    return configCenterGroup;
                }
                reference.setInterface(interfaceName);
                Integer retries = null;
                try {
                    if (!StringUtils.isBlank((CharSequence)Constants.getRetries((TestElement)this))) {
                        retries = Integer.valueOf(Constants.getRetries((TestElement)this));
                    }
                }
                catch (NumberFormatException e) {
                    this.setResponseError(res, ErrorCode.RETRIES_ERROR);
                    configCenterAddress = ErrorCode.RETRIES_ERROR.getMessage();
                    return configCenterAddress;
                }
                if (retries != null) {
                    reference.setRetries(retries);
                }
                if (!StringUtils.isBlank((CharSequence)(cluster = Constants.getCluster((TestElement)this)))) {
                    reference.setCluster(Constants.getCluster((TestElement)this));
                }
                if (!StringUtils.isBlank((CharSequence)(version = Constants.getVersion((TestElement)this)))) {
                    reference.setVersion(version);
                }
                Integer timeout = null;
                try {
                    if (!StringUtils.isBlank((CharSequence)Constants.getTimeout((TestElement)this))) {
                        timeout = Integer.valueOf(Constants.getTimeout((TestElement)this));
                    }
                }
                catch (NumberFormatException e) {
                    this.setResponseError(res, ErrorCode.TIMEOUT_ERROR);
                    String string = ErrorCode.TIMEOUT_ERROR.getMessage();
                    return string;
                }
                if (timeout != null) {
                    reference.setTimeout(timeout);
                }
                if (!StringUtils.isBlank((CharSequence)(group = Constants.getGroup((TestElement)this)))) {
                    reference.setGroup(group);
                }
                Integer connections = null;
                try {
                    if (!StringUtils.isBlank((CharSequence)Constants.getConnections((TestElement)this))) {
                        connections = Integer.valueOf(Constants.getConnections((TestElement)this));
                    }
                }
                catch (NumberFormatException e) {
                    this.setResponseError(res, ErrorCode.CONNECTIONS_ERROR);
                    String string = ErrorCode.CONNECTIONS_ERROR.getMessage();
                    return string;
                }
                if (connections != null) {
                    reference.setConnections(connections);
                }
                if (!StringUtils.isBlank((CharSequence)(loadBalance = Constants.getLoadbalance((TestElement)this)))) {
                    reference.setLoadbalance(loadBalance);
                }
                if (!StringUtils.isBlank((CharSequence)(async = Constants.getAsync((TestElement)this)))) {
                    reference.setAsync(Boolean.valueOf("async".equals(async)));
                }
                reference.setGeneric(Boolean.valueOf(true));
                methodName = Constants.getMethod((TestElement)this);
                if (!StringUtils.isBlank((CharSequence)methodName)) break block51;
                this.setResponseError(res, ErrorCode.MISS_METHOD);
                String string = ErrorCode.MISS_METHOD.getMessage();
                return string;
            }
            ReferenceConfigCache cache = ReferenceConfigCache.getCache((String)Constants.getAddress((TestElement)this), (ReferenceConfigCache.KeyGenerator)new ReferenceConfigCache.KeyGenerator(){

                public String generateKey(ReferenceConfigBase<?> referenceConfig) {
                    return referenceConfig.toString();
                }
            });
            genericService = (GenericService)cache.get((ReferenceConfigBase)reference);
            if (genericService != null) break block52;
            this.setResponseError(res, ErrorCode.GENERIC_SERVICE_IS_NULL);
            String string = MessageFormat.format(ErrorCode.GENERIC_SERVICE_IS_NULL.getMessage(), interfaceName);
            return string;
        }
        try {
            String[] parameterTypes = null;
            Object[] parameterValues = null;
            List<MethodArgument> args = Constants.getMethodArgs((TestElement)this);
            ArrayList<String> paramterTypeList = new ArrayList<String>();
            ArrayList<Object> parameterValuesList = new ArrayList<Object>();
            for (MethodArgument arg : args) {
                ClassUtils.parseParameter(paramterTypeList, parameterValuesList, arg);
            }
            parameterTypes = paramterTypeList.toArray(new String[paramterTypeList.size()]);
            parameterValues = parameterValuesList.toArray(new Object[parameterValuesList.size()]);
            List<MethodArgument> attachmentArgs = Constants.getAttachmentArgs((TestElement)this);
            if (attachmentArgs != null && !attachmentArgs.isEmpty()) {
                RpcContext.getContext().setAttachments(attachmentArgs.stream().collect(Collectors.toMap(MethodArgument::getParamType, MethodArgument::getParamValue)));
            }
            res.sampleStart();
            Object result = null;
            try {
                result = genericService.$invoke(methodName, parameterTypes, parameterValues);
                res.setResponseOK();
            }
            catch (Exception e) {
                log.error("Exception\uff1a", (Throwable)e);
                if (e instanceof RpcException) {
                    RpcException rpcException = (RpcException)e;
                    this.setResponseError(res, String.valueOf(rpcException.getCode()), rpcException.getMessage());
                } else {
                    this.setResponseError(res, ErrorCode.UNKNOWN_EXCEPTION);
                }
                result = e;
            }
            res.sampleEnd();
            Object object = result;
            return object;
        }
        catch (Exception e) {
            log.error("UnknownException\uff1a", (Throwable)e);
            this.setResponseError(res, ErrorCode.UNKNOWN_EXCEPTION);
            Exception exception = e;
            return exception;
        }
    }

    public void setResponseError(SampleResult res, ErrorCode errorCode) {
        this.setResponseError(res, errorCode.getCode(), errorCode.getMessage());
    }

    public void setResponseError(SampleResult res, String code, String message) {
        res.setSuccessful(false);
        res.setResponseCode(code);
        res.setResponseMessage(message);
    }

    public boolean interrupt() {
        Thread.currentThread().interrupt();
        return true;
    }
}

