/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.qdrant.client.json.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.metaloom.qdrant.client.http.model.collection.schema.FullTextIndexFieldSchema;
import io.metaloom.qdrant.client.http.model.collection.schema.PayloadFieldSchema;
import io.metaloom.qdrant.client.http.model.collection.schema.PayloadIndexSchemaType;
import io.metaloom.qdrant.client.http.model.collection.schema.TokenizerType;
import java.io.IOException;

public class PayloadFieldSchemaSerializer
extends JsonSerializer<PayloadFieldSchema> {
    public void serialize(PayloadFieldSchema value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value == null) {
            gen.writeNull();
        } else if (value instanceof PayloadIndexSchemaType) {
            PayloadIndexSchemaType type = (PayloadIndexSchemaType)value;
            gen.writeString(type.getName());
        } else if (value instanceof FullTextIndexFieldSchema) {
            FullTextIndexFieldSchema schema = (FullTextIndexFieldSchema)value;
            gen.writeStartObject();
            gen.writeStringField("type", schema.getType());
            gen.writeBooleanField("lowercase", schema.getLowercase().booleanValue());
            TokenizerType tokenizer = schema.getTokenizer();
            gen.writeStringField("tokenizer", tokenizer == null ? null : tokenizer.getName());
            gen.writeNumberField("min_token_len", schema.getMinTokenLen().intValue());
            gen.writeNumberField("max_token_len", schema.getMaxTokenLen().intValue());
            gen.writeEndObject();
        } else {
            throw new RuntimeException("Encountered unknown field schema type. Got: " + value.getClass().getSimpleName());
        }
    }
}

