/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.qdrant.client.http.model.point;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.JsonNode;
import io.metaloom.qdrant.client.http.model.RestModel;
import io.metaloom.qdrant.client.http.model.point.Payload;
import io.metaloom.qdrant.client.http.model.point.PointId;
import io.metaloom.qdrant.client.http.model.point.VectorData;
import io.metaloom.qdrant.client.http.model.point.VectorDataMap;
import io.metaloom.qdrant.client.http.model.point.VectorDataPlain;
import io.metaloom.qdrant.client.json.Json;
import io.metaloom.qdrant.client.util.VectorUtil;

public class PointStruct
implements RestModel {
    @JsonProperty(value="id")
    private PointId id;
    @JsonProperty(value="vector")
    private VectorData vector;
    @JsonProperty(value="payload")
    private Payload payload;

    public PointId getId() {
        return this.id;
    }

    public PointStruct setId(PointId id) {
        this.id = id;
        return this;
    }

    public VectorData getVector() {
        return this.vector;
    }

    public PointStruct setVector(VectorData vector) {
        this.vector = vector;
        return this;
    }

    @JsonIgnore
    public PointStruct setVector(float ... vector) {
        VectorDataPlain data = new VectorDataPlain();
        data.setVector(VectorUtil.toList((float[])vector));
        this.vector = data;
        return this;
    }

    @JsonIgnore
    public PointStruct setVector(String vectorName, float ... vector) {
        VectorDataMap dataMap = new VectorDataMap();
        dataMap.put(vectorName, VectorUtil.toList((float[])vector));
        this.vector = dataMap;
        return this;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public PointStruct setPayload(Payload payload) {
        this.payload = payload;
        return this;
    }

    @JsonIgnore
    public PointStruct setPayload(JsonNode json) {
        this.payload = new Payload().setJson(json);
        return this;
    }

    @JsonIgnore
    public PointStruct setPayload(String json) throws JacksonException {
        this.setPayload(Json.toJson(json));
        return this;
    }

    @JsonIgnore
    public PointStruct setId(long id) {
        this.id = PointId.id(id);
        return this;
    }

    public static PointStruct of(String vectorName, float ... vectorComponent) {
        PointStruct p = new PointStruct();
        p.setVector(vectorName, vectorComponent);
        return p;
    }

    @JsonIgnore
    public static PointStruct of(float ... vectorComponent) {
        PointStruct p = new PointStruct();
        p.setVector(vectorComponent);
        return p;
    }
}

