/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.qdrant.client.http.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.metaloom.qdrant.client.http.QDrantBinaryResponse;
import io.metaloom.qdrant.client.http.QDrantClientRequest;
import io.metaloom.qdrant.client.http.QDrantHttpClient;
import io.metaloom.qdrant.client.http.impl.HttpErrorException;
import io.metaloom.qdrant.client.http.impl.QDrantBinaryResponseImpl;
import io.metaloom.qdrant.client.http.model.RestModel;
import io.metaloom.qdrant.client.http.model.RestRequestModel;
import io.metaloom.qdrant.client.http.model.RestResponse;
import io.metaloom.qdrant.client.http.model.query.ReadConsistencyType;
import io.metaloom.qdrant.client.http.model.query.WriteOrdering;
import io.metaloom.qdrant.client.json.Json;
import io.reactivex.rxjava3.core.Single;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QDrantClientRequestImpl<T extends RestResponse>
implements QDrantClientRequest<T> {
    public static final Logger log = LoggerFactory.getLogger(QDrantClientRequestImpl.class);
    public static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final QDrantHttpClient qdrantClient;
    private final OkHttpClient okClient;
    private final HttpUrl.Builder urlBuilder;
    private final Class<T> responseClass;
    private RequestBody body;
    private final String method;

    public QDrantClientRequestImpl(String method, String path, QDrantHttpClient qdrantClient, OkHttpClient client, RestRequestModel requestModel, Class<T> responseClass) {
        this.qdrantClient = qdrantClient;
        this.okClient = client;
        this.method = method;
        this.urlBuilder = this.createUrlBuilder(path);
        this.responseClass = responseClass;
        if (requestModel != null) {
            String bodyStr = Json.parse(requestModel);
            if (log.isDebugEnabled()) {
                log.debug("Sending request: " + method + " " + path + "\n" + bodyStr);
            }
            this.body = RequestBody.create((String)bodyStr, (MediaType)MEDIA_TYPE_JSON);
        } else if (method.equals("POST")) {
            this.body = RequestBody.create((String)"", null);
        }
    }

    private HttpUrl.Builder createUrlBuilder(String path) {
        return new HttpUrl.Builder().scheme(this.qdrantClient.getScheme()).host(this.qdrantClient.getHostname()).port(this.qdrantClient.getPort()).addPathSegments(path);
    }

    private Request build() {
        Request.Builder builder = new Request.Builder().url(this.urlBuilder.build());
        builder.method(this.method, this.body);
        return builder.build();
    }

    @Override
    public JsonNode json() throws HttpErrorException {
        return this.executeSyncJson(this.build());
    }

    @Override
    public Single<T> async() {
        return this.executeAsync(this.build());
    }

    @Override
    public QDrantClientRequest<T> addQueryParameter(String key, String value) {
        this.urlBuilder.addQueryParameter(key, value);
        return this;
    }

    @Override
    public QDrantClientRequest<T> addWait(boolean wait) {
        return this.addQueryParameter("wait", String.valueOf(wait));
    }

    @Override
    public QDrantClientRequest<T> addAnonymize(boolean anonymize) {
        return this.addQueryParameter("anonymize", String.valueOf(anonymize));
    }

    @Override
    public QDrantClientRequest<T> addWriteOrdering(WriteOrdering ordering) {
        if (ordering != null) {
            return this.addQueryParameter("ordering", ordering.getName());
        }
        return this;
    }

    @Override
    public QDrantClientRequest<T> addConsistency(ReadConsistencyType type) {
        if (type != null) {
            return this.addQueryParameter("consistency", type.getName());
        }
        return this;
    }

    @Override
    public QDrantClientRequest<T> addConsistency(int nRequests) {
        return this.addQueryParameter("consistency", String.valueOf(nRequests));
    }

    @Override
    public QDrantClientRequest<T> addTimeout(int timeout) {
        return this.addQueryParameter("timeout", String.valueOf(timeout));
    }

    @Override
    public QDrantClientRequest<T> addForce(boolean force) {
        return this.addQueryParameter("force", String.valueOf(force));
    }

    @Override
    public T sync() throws HttpErrorException {
        return this.executeSync(this.build());
    }

    private String executeSyncPlain(Request request) throws HttpErrorException {
        String string;
        block13: {
            Response response = this.okClient.newCall(request).execute();
            try {
                ResponseBody body = response.body();
                String bodyStr = "";
                if (body != null) {
                    try {
                        bodyStr = body.string();
                    }
                    catch (Exception e) {
                        throw new HttpErrorException("Error while reading body", e);
                    }
                }
                if (!response.isSuccessful()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Failed request with code {" + response.code() + "} and body:\n" + bodyStr);
                    }
                    throw new HttpErrorException("Request failed {" + response.message() + "}", response.code(), bodyStr);
                }
                string = bodyStr;
                if (response == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e1) {
                    throw new HttpErrorException("Error while excuting request", e1);
                }
            }
            response.close();
        }
        return string;
    }

    private QDrantBinaryResponse executeSyncBinary(Request request) throws HttpErrorException {
        try {
            Response response = this.okClient.newCall(request).execute();
            return new QDrantBinaryResponseImpl(response);
        }
        catch (IOException e1) {
            throw new HttpErrorException("Error while excuting request", e1);
        }
    }

    public T executeSync(Request request) throws HttpErrorException {
        if (RestModel.class.isAssignableFrom(this.responseClass)) {
            Class<T> r = this.responseClass;
            String bodyStr = this.executeSyncPlain(request);
            if (log.isDebugEnabled()) {
                log.debug("Response JSON:\n" + bodyStr);
            }
            return (T)((RestResponse)Json.parse(bodyStr, r));
        }
        if (QDrantBinaryResponse.class.equals(this.responseClass)) {
            return (T)this.executeSyncBinary(request);
        }
        throw new RuntimeException("Unsupported response class encountered. Got: " + this.responseClass.getName());
    }

    private JsonNode executeSyncJson(Request request) throws HttpErrorException {
        try {
            String bodyStr = this.executeSyncPlain(request);
            return Json.toJson(bodyStr);
        }
        catch (JsonProcessingException e) {
            throw new HttpErrorException("Error while excuting request", (Exception)((Object)e));
        }
    }

    private Single<T> executeAsync(Request request) {
        return Single.create(sub -> {
            Call call = this.okClient.newCall(request);
            sub.setCancellable(() -> ((Call)call).cancel());
            call.enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    if (!"Canceled".equals(e.getMessage())) {
                        sub.onError((Throwable)e);
                    }
                }

                public void onResponse(Call call, Response response) {
                    block17: {
                        if (QDrantBinaryResponse.class.equals(QDrantClientRequestImpl.this.responseClass)) {
                            sub.onSuccess((Object)new QDrantBinaryResponseImpl(response));
                            return;
                        }
                        try {
                            ResponseBody responseBody = response.body();
                            try {
                                ResponseBody body = response.body();
                                String bodyStr = "";
                                if (body != null) {
                                    try {
                                        bodyStr = body.string();
                                    }
                                    catch (Exception e) {
                                        sub.onError((Throwable)new HttpErrorException("Error while reading body", e));
                                        if (responseBody != null) {
                                            responseBody.close();
                                        }
                                        return;
                                    }
                                }
                                if (!response.isSuccessful()) {
                                    sub.onError((Throwable)new HttpErrorException("Request failed", response.code(), bodyStr));
                                    return;
                                }
                                if (RestModel.class.isAssignableFrom(QDrantClientRequestImpl.this.responseClass)) {
                                    Class r = QDrantClientRequestImpl.this.responseClass;
                                    sub.onSuccess((Object)((RestResponse)Json.parse(bodyStr, r)));
                                    break block17;
                                }
                                throw new RuntimeException("Unsupported response class encountered. Got: " + QDrantClientRequestImpl.this.responseClass.getName());
                            }
                            finally {
                                if (responseBody != null) {
                                    try {
                                        responseBody.close();
                                    }
                                    catch (Throwable throwable) {
                                        Throwable throwable2;
                                        throwable2.addSuppressed(throwable);
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            sub.onError((Throwable)e);
                        }
                    }
                }
            });
        });
    }
}

