/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.parser;

import io.lindstrom.m3u8.model.MediaPlaylist;
import io.lindstrom.m3u8.parser.ParserUtils;
import io.lindstrom.m3u8.parser.ParsingMode;
import io.lindstrom.m3u8.parser.PartialSegmentAttribute;
import io.lindstrom.m3u8.parser.PlaylistParserException;
import io.lindstrom.m3u8.parser.PreloadHintAttribute;
import io.lindstrom.m3u8.parser.RenditionReportAttribute;
import io.lindstrom.m3u8.parser.Tag;
import io.lindstrom.m3u8.parser.TextBuilder;
import java.util.Map;

enum MediaPlaylistEndTag implements Tag<MediaPlaylist, MediaPlaylist.Builder>
{
    EXT_X_PART{

        @Override
        public void read(MediaPlaylist.Builder builder, String attributes, ParsingMode parsingMode) throws PlaylistParserException {
        }

        @Override
        public void write(MediaPlaylist playlist, TextBuilder textBuilder) {
            playlist.partialSegments().forEach(p -> textBuilder.addTag(this.tag(), p, PartialSegmentAttribute.attributeMap));
        }
    }
    ,
    EXT_X_PRELOAD_HINT{

        @Override
        public void read(MediaPlaylist.Builder builder, String attributes, ParsingMode parsingMode) throws PlaylistParserException {
            builder.preloadHint(PreloadHintAttribute.parse(attributes, parsingMode));
        }

        @Override
        public void write(MediaPlaylist playlist, TextBuilder textBuilder) {
            playlist.preloadHint().ifPresent(v -> textBuilder.addTag(this.tag(), v, PreloadHintAttribute.attributeMap));
        }
    }
    ,
    EXT_X_RENDITION_REPORT{

        @Override
        public void read(MediaPlaylist.Builder builder, String attributes, ParsingMode parsingMode) throws PlaylistParserException {
            builder.addRenditionReports(RenditionReportAttribute.parse(attributes, parsingMode));
        }

        @Override
        public void write(MediaPlaylist playlist, TextBuilder textBuilder) {
            playlist.renditionReports().forEach(r -> textBuilder.addTag(this.tag(), r, RenditionReportAttribute.attributeMap));
        }
    }
    ,
    EXT_X_ENDLIST{

        @Override
        public void read(MediaPlaylist.Builder builder, String attributes, ParsingMode parsingMode) {
            builder.ongoing(false);
        }

        @Override
        public void write(MediaPlaylist playlist, TextBuilder textBuilder) {
            if (!playlist.ongoing()) {
                textBuilder.addTag(this.tag());
            }
        }
    };

    static final Map<String, MediaPlaylistEndTag> tags;

    static {
        tags = ParserUtils.toMap(MediaPlaylistEndTag.values(), Tag::tag);
    }
}

