/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.Resolution;
import java.util.ArrayList;
import java.util.Objects;

class ResolutionBuilder {
    private static final long INIT_BIT_WIDTH = 1L;
    private static final long INIT_BIT_HEIGHT = 2L;
    private long initBits = 3L;
    private int width;
    private int height;

    ResolutionBuilder() {
        if (!(this instanceof Resolution.Builder)) {
            throw new UnsupportedOperationException("Use: new Resolution.Builder()");
        }
    }

    public final Resolution.Builder from(Resolution instance) {
        Objects.requireNonNull(instance, "instance");
        this.width(instance.width());
        this.height(instance.height());
        return (Resolution.Builder)this;
    }

    public final Resolution.Builder width(int width) {
        this.width = width;
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return (Resolution.Builder)this;
    }

    public final Resolution.Builder height(int height) {
        this.height = height;
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return (Resolution.Builder)this;
    }

    public Resolution build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableResolution(this);
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("width");
        }
        if ((this.initBits & 2L) != 0L) {
            attributes.add("height");
        }
        return "Cannot build Resolution, some of required attributes are not set " + attributes;
    }

    private static final class ImmutableResolution
    implements Resolution {
        private final int width;
        private final int height;

        private ImmutableResolution(ResolutionBuilder builder) {
            this.width = builder.width;
            this.height = builder.height;
        }

        @Override
        public int width() {
            return this.width;
        }

        @Override
        public int height() {
            return this.height;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableResolution && this.equalTo((ImmutableResolution)another);
        }

        private boolean equalTo(ImmutableResolution another) {
            return this.width == another.width && this.height == another.height;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.width;
            h += (h << 5) + this.height;
            return h;
        }

        public String toString() {
            return "Resolution{width=" + this.width + ", height=" + this.height + "}";
        }
    }
}

