/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.StreamMessage;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ListSubscriber;
import io.lettuce.core.output.OutputFactory;
import io.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StreamReadOutput<K, V>
extends CommandOutput<K, V, List<StreamMessage<K, V>>>
implements StreamingOutput<StreamMessage<K, V>> {
    private boolean initialized;
    private StreamingOutput.Subscriber<StreamMessage<K, V>> subscriber;
    private boolean skipStreamKeyReset = false;
    private K stream;
    private K key;
    private String id;
    private Map<K, V> body;
    private Long msSinceLastDelivery;
    private Long redeliveryCount;
    private boolean bodyReceived = false;

    public StreamReadOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<StreamMessage<K, V>>)ListSubscriber.instance());
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.stream == null) {
            if (bytes == null) {
                return;
            }
            this.stream = this.codec.decodeKey(bytes);
            this.skipStreamKeyReset = true;
            return;
        }
        if (this.id == null) {
            this.id = this.decodeString(bytes);
            return;
        }
        if (this.key == null) {
            this.bodyReceived = true;
            if (bytes == null) {
                return;
            }
            this.key = this.codec.decodeKey(bytes);
            return;
        }
        if (this.body == null) {
            this.body = new LinkedHashMap();
        }
        this.body.put(this.key, bytes == null ? null : (Object)this.codec.decodeValue(bytes));
        this.key = null;
    }

    @Override
    public void set(long integer) {
        if (this.id != null && this.bodyReceived) {
            if (this.msSinceLastDelivery == null) {
                this.msSinceLastDelivery = integer;
                return;
            }
            if (this.redeliveryCount == null) {
                this.redeliveryCount = integer;
                return;
            }
        }
        super.set(integer);
    }

    @Override
    public void multi(int count) {
        if (this.id != null && this.key == null && count == -1) {
            this.bodyReceived = true;
        }
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }

    @Override
    public void complete(int depth) {
        if (depth == 2 && this.bodyReceived) {
            Map map;
            Map map2 = map = this.body == null ? Collections.emptyMap() : this.body;
            if (this.msSinceLastDelivery != null && this.redeliveryCount != null) {
                this.subscriber.onNext((Collection)this.output, new StreamMessage(this.stream, this.id, map, this.msSinceLastDelivery, this.redeliveryCount));
            } else {
                this.subscriber.onNext((Collection)this.output, new StreamMessage(this.stream, this.id, map));
            }
            this.bodyReceived = false;
            this.key = null;
            this.body = null;
            this.id = null;
            this.msSinceLastDelivery = null;
            this.redeliveryCount = null;
        }
        if (depth == 2 && this.skipStreamKeyReset) {
            this.skipStreamKeyReset = false;
        }
        if (depth == 1) {
            if (this.skipStreamKeyReset) {
                this.skipStreamKeyReset = false;
            } else {
                this.stream = null;
            }
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<StreamMessage<K, V>> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<StreamMessage<K, V>> getSubscriber() {
        return this.subscriber;
    }
}

