/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search.arguments;

import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.search.arguments.FieldArgs;
import java.util.Optional;

public class GeoshapeFieldArgs<K>
extends FieldArgs<K> {
    private Optional<CoordinateSystem> coordinateSystem = Optional.empty();

    public static <K> Builder<K> builder() {
        return new Builder();
    }

    @Override
    public String getFieldType() {
        return "GEOSHAPE";
    }

    public Optional<CoordinateSystem> getCoordinateSystem() {
        return this.coordinateSystem;
    }

    @Override
    protected void buildTypeSpecificArgs(CommandArgs<K, ?> args) {
        this.coordinateSystem.ifPresent(cs -> {
            switch (cs) {
                case FLAT: {
                    args.add(CommandKeyword.FLAT);
                    break;
                }
                case SPHERICAL: {
                    args.add(CommandKeyword.SPHERICAL);
                }
            }
        });
    }

    public static class Builder<K>
    extends FieldArgs.Builder<K, GeoshapeFieldArgs<K>, Builder<K>> {
        public Builder() {
            super(new GeoshapeFieldArgs());
        }

        public Builder<K> coordinateSystem(CoordinateSystem coordinateSystem) {
            ((GeoshapeFieldArgs)this.instance).coordinateSystem = Optional.of(coordinateSystem);
            return (Builder)this.self();
        }

        public Builder<K> flat() {
            return this.coordinateSystem(CoordinateSystem.FLAT);
        }

        public Builder<K> spherical() {
            return this.coordinateSystem(CoordinateSystem.SPHERICAL);
        }
    }

    public static enum CoordinateSystem {
        FLAT,
        SPHERICAL;

    }
}

