/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.internal.NetUtils;
import java.net.SocketAddress;

public class MaintNotificationsConfig {
    public static final boolean DEFAULT_MAINT_NOTIFICATIONS_ENABLED = true;
    public static final EndpointTypeSource DEFAULT_ENDPOINT_TYPE_SOURCE = new AutoresolveEndpointTypeSource();
    private final boolean maintNotificationsEnabled;
    private final EndpointTypeSource endpointTypeSource;

    protected MaintNotificationsConfig(Builder builder) {
        this.endpointTypeSource = builder.endpointTypeSource;
        this.maintNotificationsEnabled = builder.maintNotificationsEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MaintNotificationsConfig create() {
        return MaintNotificationsConfig.builder().build();
    }

    public static MaintNotificationsConfig disabled() {
        return MaintNotificationsConfig.builder().enableMaintNotifications(false).build();
    }

    public static MaintNotificationsConfig enabled() {
        return MaintNotificationsConfig.builder().enableMaintNotifications().autoResolveEndpointType().build();
    }

    public static MaintNotificationsConfig enabled(EndpointType endpointType) {
        return MaintNotificationsConfig.builder().enableMaintNotifications().endpointType(endpointType).build();
    }

    public boolean maintNotificationsEnabled() {
        return this.maintNotificationsEnabled;
    }

    public EndpointTypeSource getEndpointTypeSource() {
        return this.endpointTypeSource;
    }

    public static abstract class EndpointTypeSource {
        public abstract EndpointType getEndpointType(SocketAddress var1, boolean var2);
    }

    private static class AutoresolveEndpointTypeSource
    extends EndpointTypeSource {
        AutoresolveEndpointTypeSource() {
        }

        @Override
        public EndpointType getEndpointType(SocketAddress socketAddress, boolean sslEnabled) {
            if (NetUtils.isPrivateIp(socketAddress)) {
                if (sslEnabled) {
                    return EndpointType.INTERNAL_FQDN;
                }
                return EndpointType.INTERNAL_IP;
            }
            if (sslEnabled) {
                return EndpointType.EXTERNAL_FQDN;
            }
            return EndpointType.EXTERNAL_IP;
        }
    }

    private static class FixedEndpointTypeSource
    extends EndpointTypeSource {
        private final EndpointType endpointType;

        FixedEndpointTypeSource(EndpointType endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public EndpointType getEndpointType(SocketAddress socketAddress, boolean sslEnabled) {
            return this.endpointType;
        }
    }

    public static enum EndpointType {
        INTERNAL_IP,
        INTERNAL_FQDN,
        EXTERNAL_IP,
        EXTERNAL_FQDN,
        NONE;

    }

    public static class Builder {
        private boolean maintNotificationsEnabled = true;
        private EndpointTypeSource endpointTypeSource = DEFAULT_ENDPOINT_TYPE_SOURCE;

        public Builder enableMaintNotifications() {
            return this.enableMaintNotifications(true);
        }

        public Builder enableMaintNotifications(boolean enabled) {
            this.maintNotificationsEnabled = enabled;
            return this;
        }

        public Builder endpointType(EndpointType endpointType) {
            this.endpointTypeSource = new FixedEndpointTypeSource(endpointType);
            return this;
        }

        public Builder autoResolveEndpointType() {
            this.endpointTypeSource = new AutoresolveEndpointTypeSource();
            return this;
        }

        public MaintNotificationsConfig build() {
            return new MaintNotificationsConfig(this);
        }
    }
}

