/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;

public class LcsArgs
implements CompositeArgument {
    private boolean justLen;
    private int minMatchLen;
    private boolean withMatchLen;
    private boolean withIdx;
    private String[] keys;

    public LcsArgs minMatchLen(int minMatchLen) {
        this.minMatchLen = minMatchLen;
        return this;
    }

    public LcsArgs justLen() {
        this.justLen = true;
        return this;
    }

    public LcsArgs withMatchLen() {
        this.withMatchLen = true;
        return this;
    }

    public LcsArgs withIdx() {
        this.withIdx = true;
        return this;
    }

    public LcsArgs by(String ... keys) {
        LettuceAssert.notEmpty((Object[])keys, "Keys must not be empty");
        this.keys = keys;
        return this;
    }

    public boolean isWithIdx() {
        return this.withIdx;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        for (String key : this.keys) {
            args.add(key);
        }
        if (this.justLen) {
            args.add(CommandKeyword.LEN);
        }
        if (this.withIdx) {
            args.add(CommandKeyword.IDX);
        }
        if (this.minMatchLen > 0) {
            args.add(CommandKeyword.MINMATCHLEN);
            args.add(this.minMatchLen);
        }
        if (this.withMatchLen) {
            args.add(CommandKeyword.WITHMATCHLEN);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static LcsArgs keys(String ... keys) {
            return new LcsArgs().by(keys);
        }
    }
}

