/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.SocketOptions;
import io.lettuce.core.SslOptions;
import io.lettuce.core.TimeoutOptions;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.ProtocolVersion;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ClientOptions
implements Serializable {
    public static final boolean DEFAULT_PING_BEFORE_ACTIVATE_CONNECTION = true;
    public static final ProtocolVersion DEFAULT_PROTOCOL_VERSION = ProtocolVersion.newestSupported();
    public static final boolean DEFAULT_AUTO_RECONNECT = true;
    public static final boolean DEFAULT_CANCEL_CMD_RECONNECT_FAIL = false;
    public static final boolean DEFAULT_PUBLISH_ON_SCHEDULER = false;
    public static final boolean DEFAULT_SUSPEND_RECONNECT_PROTO_FAIL = false;
    public static final int DEFAULT_REQUEST_QUEUE_SIZE = Integer.MAX_VALUE;
    public static final DisconnectedBehavior DEFAULT_DISCONNECTED_BEHAVIOR = DisconnectedBehavior.DEFAULT;
    public static final Charset DEFAULT_SCRIPT_CHARSET = StandardCharsets.UTF_8;
    public static final SocketOptions DEFAULT_SOCKET_OPTIONS = SocketOptions.create();
    public static final SslOptions DEFAULT_SSL_OPTIONS = SslOptions.create();
    public static final TimeoutOptions DEFAULT_TIMEOUT_OPTIONS = TimeoutOptions.create();
    public static final int DEFAULT_BUFFER_USAGE_RATIO = 3;
    private final boolean pingBeforeActivateConnection;
    private final ProtocolVersion protocolVersion;
    private final boolean autoReconnect;
    private final boolean cancelCommandsOnReconnectFailure;
    private final boolean publishOnScheduler;
    private final boolean suspendReconnectOnProtocolFailure;
    private final int requestQueueSize;
    private final DisconnectedBehavior disconnectedBehavior;
    private final Charset scriptCharset;
    private final SocketOptions socketOptions;
    private final SslOptions sslOptions;
    private final TimeoutOptions timeoutOptions;
    private final int bufferUsageRatio;

    protected ClientOptions(Builder builder) {
        this.pingBeforeActivateConnection = builder.pingBeforeActivateConnection;
        this.protocolVersion = builder.protocolVersion;
        this.cancelCommandsOnReconnectFailure = builder.cancelCommandsOnReconnectFailure;
        this.publishOnScheduler = builder.publishOnScheduler;
        this.autoReconnect = builder.autoReconnect;
        this.suspendReconnectOnProtocolFailure = builder.suspendReconnectOnProtocolFailure;
        this.requestQueueSize = builder.requestQueueSize;
        this.disconnectedBehavior = builder.disconnectedBehavior;
        this.scriptCharset = builder.scriptCharset;
        this.socketOptions = builder.socketOptions;
        this.sslOptions = builder.sslOptions;
        this.timeoutOptions = builder.timeoutOptions;
        this.bufferUsageRatio = builder.bufferUsageRatio;
    }

    protected ClientOptions(ClientOptions original) {
        this.pingBeforeActivateConnection = original.isPingBeforeActivateConnection();
        this.protocolVersion = original.getConfiguredProtocolVersion();
        this.autoReconnect = original.isAutoReconnect();
        this.cancelCommandsOnReconnectFailure = original.isCancelCommandsOnReconnectFailure();
        this.publishOnScheduler = original.isPublishOnScheduler();
        this.suspendReconnectOnProtocolFailure = original.isSuspendReconnectOnProtocolFailure();
        this.requestQueueSize = original.getRequestQueueSize();
        this.disconnectedBehavior = original.getDisconnectedBehavior();
        this.scriptCharset = original.getScriptCharset();
        this.socketOptions = original.getSocketOptions();
        this.sslOptions = original.getSslOptions();
        this.timeoutOptions = original.getTimeoutOptions();
        this.bufferUsageRatio = original.getBufferUsageRatio();
    }

    public static ClientOptions copyOf(ClientOptions options) {
        return new ClientOptions(options);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ClientOptions create() {
        return ClientOptions.builder().build();
    }

    public Builder mutate() {
        Builder builder = new Builder();
        builder.autoReconnect(this.isAutoReconnect()).bufferUsageRatio(this.getBufferUsageRatio()).cancelCommandsOnReconnectFailure(this.isCancelCommandsOnReconnectFailure()).disconnectedBehavior(this.getDisconnectedBehavior()).scriptCharset(this.getScriptCharset()).publishOnScheduler(this.isPublishOnScheduler()).pingBeforeActivateConnection(this.isPingBeforeActivateConnection()).protocolVersion(this.getConfiguredProtocolVersion()).requestQueueSize(this.getRequestQueueSize()).socketOptions(this.getSocketOptions()).sslOptions(this.getSslOptions()).suspendReconnectOnProtocolFailure(this.isSuspendReconnectOnProtocolFailure()).timeoutOptions(this.getTimeoutOptions());
        return builder;
    }

    public boolean isPingBeforeActivateConnection() {
        return this.pingBeforeActivateConnection;
    }

    public ProtocolVersion getProtocolVersion() {
        ProtocolVersion protocolVersion = this.getConfiguredProtocolVersion();
        return protocolVersion == null ? DEFAULT_PROTOCOL_VERSION : protocolVersion;
    }

    public ProtocolVersion getConfiguredProtocolVersion() {
        return this.protocolVersion;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public boolean isCancelCommandsOnReconnectFailure() {
        return this.cancelCommandsOnReconnectFailure;
    }

    public boolean isPublishOnScheduler() {
        return this.publishOnScheduler;
    }

    public boolean isSuspendReconnectOnProtocolFailure() {
        return this.suspendReconnectOnProtocolFailure;
    }

    public int getRequestQueueSize() {
        return this.requestQueueSize;
    }

    public DisconnectedBehavior getDisconnectedBehavior() {
        return this.disconnectedBehavior;
    }

    public Charset getScriptCharset() {
        return this.scriptCharset;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public SslOptions getSslOptions() {
        return this.sslOptions;
    }

    public TimeoutOptions getTimeoutOptions() {
        return this.timeoutOptions;
    }

    public int getBufferUsageRatio() {
        return this.bufferUsageRatio;
    }

    public static enum DisconnectedBehavior {
        DEFAULT,
        ACCEPT_COMMANDS,
        REJECT_COMMANDS;

    }

    public static class Builder {
        private boolean pingBeforeActivateConnection = true;
        private ProtocolVersion protocolVersion;
        private boolean autoReconnect = true;
        private boolean cancelCommandsOnReconnectFailure = false;
        private boolean publishOnScheduler = false;
        private boolean suspendReconnectOnProtocolFailure = false;
        private int requestQueueSize = Integer.MAX_VALUE;
        private DisconnectedBehavior disconnectedBehavior = DEFAULT_DISCONNECTED_BEHAVIOR;
        private Charset scriptCharset = DEFAULT_SCRIPT_CHARSET;
        private SocketOptions socketOptions = DEFAULT_SOCKET_OPTIONS;
        private SslOptions sslOptions = DEFAULT_SSL_OPTIONS;
        private TimeoutOptions timeoutOptions = DEFAULT_TIMEOUT_OPTIONS;
        private int bufferUsageRatio = 3;

        protected Builder() {
        }

        public Builder pingBeforeActivateConnection(boolean pingBeforeActivateConnection) {
            this.pingBeforeActivateConnection = pingBeforeActivateConnection;
            return this;
        }

        public Builder protocolVersion(ProtocolVersion protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public Builder autoReconnect(boolean autoReconnect) {
            this.autoReconnect = autoReconnect;
            return this;
        }

        public Builder suspendReconnectOnProtocolFailure(boolean suspendReconnectOnProtocolFailure) {
            this.suspendReconnectOnProtocolFailure = suspendReconnectOnProtocolFailure;
            return this;
        }

        public Builder cancelCommandsOnReconnectFailure(boolean cancelCommandsOnReconnectFailure) {
            this.cancelCommandsOnReconnectFailure = cancelCommandsOnReconnectFailure;
            return this;
        }

        public Builder publishOnScheduler(boolean publishOnScheduler) {
            this.publishOnScheduler = publishOnScheduler;
            return this;
        }

        public Builder requestQueueSize(int requestQueueSize) {
            this.requestQueueSize = requestQueueSize;
            return this;
        }

        public Builder disconnectedBehavior(DisconnectedBehavior disconnectedBehavior) {
            LettuceAssert.notNull((Object)disconnectedBehavior, "DisconnectedBehavior must not be null");
            this.disconnectedBehavior = disconnectedBehavior;
            return this;
        }

        public Builder scriptCharset(Charset scriptCharset) {
            LettuceAssert.notNull((Object)scriptCharset, "ScriptCharset must not be null");
            this.scriptCharset = scriptCharset;
            return this;
        }

        public Builder socketOptions(SocketOptions socketOptions) {
            LettuceAssert.notNull((Object)socketOptions, "SocketOptions must not be null");
            this.socketOptions = socketOptions;
            return this;
        }

        public Builder sslOptions(SslOptions sslOptions) {
            LettuceAssert.notNull((Object)sslOptions, "SslOptions must not be null");
            this.sslOptions = sslOptions;
            return this;
        }

        public Builder timeoutOptions(TimeoutOptions timeoutOptions) {
            LettuceAssert.notNull((Object)timeoutOptions, "TimeoutOptions must not be null");
            this.timeoutOptions = timeoutOptions;
            return this;
        }

        public Builder bufferUsageRatio(int bufferUsageRatio) {
            LettuceAssert.isTrue(bufferUsageRatio > 0 && bufferUsageRatio < Integer.MAX_VALUE, "BufferUsageRatio must grater than 0");
            this.bufferUsageRatio = bufferUsageRatio;
            return this;
        }

        public ClientOptions build() {
            return new ClientOptions(this);
        }
    }
}

