/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.util;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.annotations.GraphQLIgnore;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Utils;
import java.lang.reflect.AnnotatedType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassFinder {
    public static final Predicate<ClassInfo> CONCRETE = info -> !info.isAbstract() && !info.isInterface();
    public static final Predicate<ClassInfo> NON_IGNORED = info -> info.getAnnotations().directOnly().stream().noneMatch(ann -> ann.getName().equals(GraphQLIgnore.class.getName()));
    public static final Predicate<ClassInfo> PUBLIC = ClassInfo::isPublic;
    public static final Predicate<ClassInfo> ALL = info -> true;
    public static final Logger log = LoggerFactory.getLogger(ClassFinder.class);
    private final Map<String, ScanResult> cache = new ConcurrentHashMap<String, ScanResult>();

    public List<AnnotatedType> findImplementations(AnnotatedType superType, Predicate<ClassInfo> filter, boolean allowMissingGenerics, String ... packages) {
        Class rawType = ClassUtils.getRawType(superType.getType());
        return this.findImplementations(rawType, filter, packages).stream().flatMap(raw -> ClassFinder.getExactSubType(superType, raw, allowMissingGenerics)).collect(Collectors.toList());
    }

    public List<Class<?>> findImplementations(Class superType, Predicate<ClassInfo> filter, String ... packages) {
        String[] scanPackages = Utils.emptyIfNull(packages);
        String cacheKey = Arrays.stream(scanPackages).sorted().collect(Collectors.joining());
        ScanResult scanResults = this.cache.computeIfAbsent(cacheKey, k -> new ClassGraph().whitelistPackages(packages).enableAllInfo().initializeLoadedClasses().scan());
        try {
            return scanResults.getAllClasses().stream().filter(impl -> superType.isInterface() ? impl.implementsInterface(superType.getName()) : impl.extendsSuperclass(superType.getName())).filter(filter == null ? info -> true : filter).flatMap(info -> ClassFinder.loadClass(info, superType)).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("Failed to auto discover the subtypes of " + superType.getName() + ". Error encountered while scanning the classpath/modulepath.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static Stream<AnnotatedType> getExactSubType(AnnotatedType superType, Class<?> subClass, boolean allowMissingGenerics) {
        AnnotatedType subType = GenericTypeReflector.getExactSubType((AnnotatedType)superType, subClass);
        if (subType == null || !allowMissingGenerics && ClassUtils.isMissingTypeParameters(subType.getType())) {
            log.warn("Auto discovered type " + subClass.getName() + " will be ignored because the exact matching sub type of " + ClassUtils.toString(superType) + " could not be determined");
            return Stream.empty();
        }
        return Stream.of(subType);
    }

    private static Stream<Class<?>> loadClass(ClassInfo classInfo, Class superType) {
        try {
            return Stream.of(Class.forName(classInfo.getName(), true, superType.getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            log.warn(String.format("Auto discovered class %s could not be loaded using the same loader that loaded %s. Trying other loaders... For details see %s", classInfo.getName(), superType.getName(), "https://github.com/leangen/graphql-spqr/wiki/Errors#class-loading-issues"));
            try {
                return Stream.of(classInfo.loadClass());
            }
            catch (Exception e2) {
                log.error("Auto discovered type " + classInfo.getName() + " failed to load and will be ignored", (Throwable)e2);
                return Stream.empty();
            }
        }
    }

    public void close() {
        try {
            this.cache.values().forEach(ScanResult::close);
            this.cache.clear();
        }
        catch (Exception e) {
            log.warn(ScanResult.class.getName() + " did not close cleanly", (Throwable)e);
        }
    }
}

