/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.module.common.jackson;

import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import graphql.language.BooleanValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.GraphQLScalarType;
import io.leangen.graphql.util.Scalars;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JacksonScalars {
    public static final GraphQLScalarType JsonTextNode = GraphQLScalarType.newScalar().name("JsonText").description("Text JSON node").coercing((Coercing)new Coercing<TextNode, String>(){

        public String serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof String) {
                return (String)dataFetcherResult;
            }
            if (dataFetcherResult instanceof TextNode) {
                return ((TextNode)dataFetcherResult).textValue();
            }
            throw Scalars.serializationException(dataFetcherResult, String.class, TextNode.class);
        }

        public TextNode parseValue(Object input) {
            if (input instanceof String) {
                return TextNode.valueOf((String)((String)input));
            }
            if (input instanceof TextNode) {
                return (TextNode)input;
            }
            throw Scalars.valueParsingException(input, String.class, TextNode.class);
        }

        public TextNode parseLiteral(Object input) {
            return TextNode.valueOf((String)Scalars.literalOrException(input, StringValue.class).getValue());
        }
    }).build();
    public static final GraphQLScalarType JsonBinaryNode = GraphQLScalarType.newScalar().name("JsonBase64Binary").description("Base64-encoded binary JSON node").coercing((Coercing)new Coercing<BinaryNode, String>(){
        private final Base64.Encoder encoder = Base64.getEncoder();
        private final Base64.Decoder decoder = Base64.getDecoder();

        public String serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof BinaryNode) {
                return this.encoder.encodeToString(((BinaryNode)dataFetcherResult).binaryValue());
            }
            if (dataFetcherResult instanceof String) {
                return (String)dataFetcherResult;
            }
            throw Scalars.serializationException(dataFetcherResult, String.class, BinaryNode.class);
        }

        public BinaryNode parseValue(Object input) {
            if (input instanceof String) {
                return BinaryNode.valueOf((byte[])this.decoder.decode(input.toString()));
            }
            if (input instanceof BinaryNode) {
                return (BinaryNode)input;
            }
            throw Scalars.valueParsingException(input, String.class, BinaryNode.class);
        }

        public BinaryNode parseLiteral(Object input) {
            return new BinaryNode(this.decoder.decode(Scalars.literalOrException(input, StringValue.class).getValue()));
        }
    }).build();
    public static final GraphQLScalarType JsonBooleanNode = GraphQLScalarType.newScalar().name("JsonBoolean").description("Boolean JSON node").coercing((Coercing)new Coercing<BooleanNode, Boolean>(){

        public Boolean serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof BooleanNode) {
                return ((BooleanNode)dataFetcherResult).booleanValue();
            }
            if (dataFetcherResult instanceof Boolean) {
                return (Boolean)dataFetcherResult;
            }
            throw Scalars.serializationException(dataFetcherResult, Boolean.class, BooleanNode.class);
        }

        public BooleanNode parseValue(Object input) {
            if (input instanceof Boolean) {
                return (Boolean)input != false ? BooleanNode.TRUE : BooleanNode.FALSE;
            }
            if (input instanceof BooleanNode) {
                return (BooleanNode)input;
            }
            throw Scalars.valueParsingException(input, Boolean.class, BooleanNode.class);
        }

        public BooleanNode parseLiteral(Object input) {
            return Scalars.literalOrException(input, BooleanValue.class).isValue() ? BooleanNode.TRUE : BooleanNode.FALSE;
        }
    }).build();
    public static final GraphQLScalarType JsonDecimalNode = GraphQLScalarType.newScalar().name("JsonNumber").description("Decimal JSON node").coercing((Coercing)new Coercing<DecimalNode, Number>(){

        public Number serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof DecimalNode) {
                return ((DecimalNode)dataFetcherResult).numberValue();
            }
            throw Scalars.serializationException(dataFetcherResult, DecimalNode.class);
        }

        public DecimalNode parseValue(Object input) {
            if (input instanceof Number || input instanceof String) {
                return (DecimalNode)JsonNodeFactory.instance.numberNode(new BigDecimal(input.toString()));
            }
            if (input instanceof DecimalNode) {
                return (DecimalNode)input;
            }
            throw Scalars.valueParsingException(input, Number.class, String.class, DecimalNode.class);
        }

        public DecimalNode parseLiteral(Object input) {
            if (input instanceof IntValue) {
                return (DecimalNode)JsonNodeFactory.instance.numberNode(((IntValue)input).getValue());
            }
            if (input instanceof FloatValue) {
                return (DecimalNode)JsonNodeFactory.instance.numberNode(((FloatValue)input).getValue());
            }
            throw new CoercingParseLiteralException(Scalars.errorMessage(input, IntValue.class, FloatValue.class));
        }
    }).build();
    public static final GraphQLScalarType JsonIntegerNode = GraphQLScalarType.newScalar().name("JsonInteger").description("Integer JSON node").coercing((Coercing)new Coercing<IntNode, Number>(){

        public Number serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof IntNode) {
                return ((IntNode)dataFetcherResult).numberValue();
            }
            throw Scalars.serializationException(dataFetcherResult, IntNode.class);
        }

        public IntNode parseValue(Object input) {
            if (input instanceof Number || input instanceof String) {
                try {
                    return IntNode.valueOf((int)new BigInteger(input.toString()).intValueExact());
                }
                catch (ArithmeticException e) {
                    throw new CoercingParseValueException(input + " does not fit into an int without a loss of precision");
                }
            }
            if (input instanceof IntNode) {
                return (IntNode)input;
            }
            throw Scalars.valueParsingException(input, Number.class, String.class, IntNode.class);
        }

        public IntNode parseLiteral(Object input) {
            if (input instanceof IntValue) {
                try {
                    return IntNode.valueOf((int)((IntValue)input).getValue().intValueExact());
                }
                catch (ArithmeticException e) {
                    throw new CoercingParseLiteralException(input + " does not fit into an int without a loss of precision");
                }
            }
            throw new CoercingParseLiteralException(Scalars.errorMessage(input, IntValue.class));
        }
    }).build();
    public static final GraphQLScalarType JsonBigIntegerNode = GraphQLScalarType.newScalar().name("JsonBigInteger").description("BigInteger JSON node").coercing((Coercing)new Coercing<BigIntegerNode, Number>(){

        public Number serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof BigIntegerNode) {
                return ((BigIntegerNode)dataFetcherResult).numberValue();
            }
            throw Scalars.serializationException(dataFetcherResult, BigIntegerNode.class);
        }

        public BigIntegerNode parseValue(Object input) {
            if (input instanceof Number || input instanceof String) {
                return BigIntegerNode.valueOf((BigInteger)new BigInteger(input.toString()));
            }
            if (input instanceof BigIntegerNode) {
                return (BigIntegerNode)input;
            }
            throw Scalars.valueParsingException(input, Number.class, String.class, BigIntegerNode.class);
        }

        public BigIntegerNode parseLiteral(Object input) {
            if (input instanceof IntValue) {
                return BigIntegerNode.valueOf((BigInteger)((IntValue)input).getValue());
            }
            throw new CoercingParseLiteralException(Scalars.errorMessage(input, IntValue.class));
        }
    }).build();
    public static final GraphQLScalarType JsonShortNode = GraphQLScalarType.newScalar().name("JsonShort").description("Short JSON node").coercing((Coercing)new Coercing<ShortNode, Number>(){

        public Number serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof ShortNode) {
                return ((ShortNode)dataFetcherResult).numberValue();
            }
            throw Scalars.serializationException(dataFetcherResult, ShortNode.class);
        }

        public ShortNode parseValue(Object input) {
            if (input instanceof Number || input instanceof String) {
                try {
                    return ShortNode.valueOf((short)new BigInteger(input.toString()).shortValueExact());
                }
                catch (ArithmeticException e) {
                    throw new CoercingParseValueException(input + " does not fit into a short without a loss of precision");
                }
            }
            if (input instanceof ShortNode) {
                return (ShortNode)input;
            }
            throw Scalars.valueParsingException(input, Number.class, String.class, ShortNode.class);
        }

        public ShortNode parseLiteral(Object input) {
            if (input instanceof IntValue) {
                try {
                    return ShortNode.valueOf((short)((IntValue)input).getValue().shortValueExact());
                }
                catch (ArithmeticException e) {
                    throw new CoercingParseLiteralException(input + " does not fit into a short without a loss of precision");
                }
            }
            throw new CoercingParseLiteralException(Scalars.errorMessage(input, IntValue.class));
        }
    }).build();
    public static final GraphQLScalarType JsonFloatNode = GraphQLScalarType.newScalar().name("JsonFloat").description("Float JSON node").coercing((Coercing)new Coercing<FloatNode, Number>(){

        public Number serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof FloatNode) {
                return ((FloatNode)dataFetcherResult).numberValue();
            }
            throw Scalars.serializationException(dataFetcherResult, FloatNode.class);
        }

        public FloatNode parseValue(Object input) {
            if (input instanceof Number || input instanceof String) {
                return FloatNode.valueOf((float)new BigDecimal(input.toString()).floatValue());
            }
            if (input instanceof FloatNode) {
                return (FloatNode)input;
            }
            throw Scalars.valueParsingException(input, Number.class, String.class, FloatNode.class);
        }

        public FloatNode parseLiteral(Object input) {
            if (input instanceof IntValue) {
                return FloatNode.valueOf((float)((IntValue)input).getValue().floatValue());
            }
            if (input instanceof FloatValue) {
                return FloatNode.valueOf((float)((FloatValue)input).getValue().floatValue());
            }
            throw new CoercingParseLiteralException(Scalars.errorMessage(input, IntValue.class, FloatValue.class));
        }
    }).build();
    public static final GraphQLScalarType JsonDoubleNode = GraphQLScalarType.newScalar().name("JsonDouble").description("Double JSON node").coercing((Coercing)new Coercing<DoubleNode, Number>(){

        public Number serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof DoubleNode) {
                return ((DoubleNode)dataFetcherResult).numberValue();
            }
            throw Scalars.serializationException(dataFetcherResult, DoubleNode.class);
        }

        public DoubleNode parseValue(Object input) {
            if (input instanceof Number || input instanceof String) {
                return DoubleNode.valueOf((double)new BigDecimal(input.toString()).doubleValue());
            }
            if (input instanceof DoubleNode) {
                return (DoubleNode)input;
            }
            throw Scalars.valueParsingException(input, Number.class, String.class, DoubleNode.class);
        }

        public DoubleNode parseLiteral(Object input) {
            if (input instanceof IntValue) {
                return DoubleNode.valueOf((double)((IntValue)input).getValue().doubleValue());
            }
            if (input instanceof FloatValue) {
                return DoubleNode.valueOf((double)((FloatValue)input).getValue().doubleValue());
            }
            throw new CoercingParseLiteralException(Scalars.errorMessage(input, IntValue.class, FloatValue.class));
        }
    }).build();
    private static final Map<Type, GraphQLScalarType> SCALAR_MAPPING = JacksonScalars.getScalarMapping();

    public static boolean isScalar(Type javaType) {
        return SCALAR_MAPPING.containsKey(javaType);
    }

    public static GraphQLScalarType toGraphQLScalarType(Type javaType) {
        return SCALAR_MAPPING.get(javaType);
    }

    private static Map<Type, GraphQLScalarType> getScalarMapping() {
        HashMap<Class, GraphQLScalarType> scalarMapping = new HashMap<Class, GraphQLScalarType>();
        scalarMapping.put(TextNode.class, JsonTextNode);
        scalarMapping.put(BooleanNode.class, JsonBooleanNode);
        scalarMapping.put(BinaryNode.class, JsonBinaryNode);
        scalarMapping.put(BigIntegerNode.class, JsonBigIntegerNode);
        scalarMapping.put(IntNode.class, JsonIntegerNode);
        scalarMapping.put(ShortNode.class, JsonShortNode);
        scalarMapping.put(DecimalNode.class, JsonDecimalNode);
        scalarMapping.put(FloatNode.class, JsonFloatNode);
        scalarMapping.put(DoubleNode.class, JsonDoubleNode);
        scalarMapping.put(NumericNode.class, JsonDecimalNode);
        return Collections.unmodifiableMap(scalarMapping);
    }
}

