/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.apimachinery;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import io.kubernetes.client.common.KubernetesObject;

public class GroupVersion {
    private final String group;
    private final String version;

    public static GroupVersion parse(String apiVersion) {
        if (Strings.isNullOrEmpty((String)apiVersion)) {
            throw new IllegalArgumentException("No apiVersion found on object");
        }
        if ("v1".equals(apiVersion)) {
            return new GroupVersion("", "v1");
        }
        String[] parts = apiVersion.split("/");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid apiVersion found on object: " + apiVersion);
        }
        return new GroupVersion(parts[0], parts[1]);
    }

    public static GroupVersion parse(KubernetesObject obj) {
        return GroupVersion.parse(obj.getApiVersion());
    }

    public GroupVersion(String group, String version) {
        if (group == null) {
            throw new IllegalArgumentException("group must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("version must not be null");
        }
        this.group = group;
        this.version = version;
    }

    public String getGroup() {
        return this.group;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupVersion that = (GroupVersion)o;
        return Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.version, (Object)that.version);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.group, this.version});
    }
}

