/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1beta2DeploymentCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="DeploymentStatus is the most recently observed status of the Deployment.")
public class V1beta2DeploymentStatus {
    public static final String SERIALIZED_NAME_AVAILABLE_REPLICAS = "availableReplicas";
    @SerializedName(value="availableReplicas")
    private Integer availableReplicas;
    public static final String SERIALIZED_NAME_COLLISION_COUNT = "collisionCount";
    @SerializedName(value="collisionCount")
    private Integer collisionCount;
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1beta2DeploymentCondition> conditions = null;
    public static final String SERIALIZED_NAME_OBSERVED_GENERATION = "observedGeneration";
    @SerializedName(value="observedGeneration")
    private Long observedGeneration;
    public static final String SERIALIZED_NAME_READY_REPLICAS = "readyReplicas";
    @SerializedName(value="readyReplicas")
    private Integer readyReplicas;
    public static final String SERIALIZED_NAME_REPLICAS = "replicas";
    @SerializedName(value="replicas")
    private Integer replicas;
    public static final String SERIALIZED_NAME_UNAVAILABLE_REPLICAS = "unavailableReplicas";
    @SerializedName(value="unavailableReplicas")
    private Integer unavailableReplicas;
    public static final String SERIALIZED_NAME_UPDATED_REPLICAS = "updatedReplicas";
    @SerializedName(value="updatedReplicas")
    private Integer updatedReplicas;

    public V1beta2DeploymentStatus availableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.")
    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    public void setAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
    }

    public V1beta2DeploymentStatus collisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.")
    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    public void setCollisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
    }

    public V1beta2DeploymentStatus conditions(List<V1beta2DeploymentCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1beta2DeploymentStatus addConditionsItem(V1beta2DeploymentCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1beta2DeploymentCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the latest available observations of a deployment's current state.")
    public List<V1beta2DeploymentCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1beta2DeploymentCondition> conditions) {
        this.conditions = conditions;
    }

    public V1beta2DeploymentStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The generation observed by the deployment controller.")
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public V1beta2DeploymentStatus readyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of ready pods targeted by this deployment.")
    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public void setReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
    }

    public V1beta2DeploymentStatus replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of non-terminated pods targeted by this deployment (their labels match the selector).")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public V1beta2DeploymentStatus unavailableReplicas(Integer unavailableReplicas) {
        this.unavailableReplicas = unavailableReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.")
    public Integer getUnavailableReplicas() {
        return this.unavailableReplicas;
    }

    public void setUnavailableReplicas(Integer unavailableReplicas) {
        this.unavailableReplicas = unavailableReplicas;
    }

    public V1beta2DeploymentStatus updatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of non-terminated pods targeted by this deployment that have the desired template spec.")
    public Integer getUpdatedReplicas() {
        return this.updatedReplicas;
    }

    public void setUpdatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2DeploymentStatus v1beta2DeploymentStatus = (V1beta2DeploymentStatus)o;
        return Objects.equals(this.availableReplicas, v1beta2DeploymentStatus.availableReplicas) && Objects.equals(this.collisionCount, v1beta2DeploymentStatus.collisionCount) && Objects.equals(this.conditions, v1beta2DeploymentStatus.conditions) && Objects.equals(this.observedGeneration, v1beta2DeploymentStatus.observedGeneration) && Objects.equals(this.readyReplicas, v1beta2DeploymentStatus.readyReplicas) && Objects.equals(this.replicas, v1beta2DeploymentStatus.replicas) && Objects.equals(this.unavailableReplicas, v1beta2DeploymentStatus.unavailableReplicas) && Objects.equals(this.updatedReplicas, v1beta2DeploymentStatus.updatedReplicas);
    }

    public int hashCode() {
        return Objects.hash(this.availableReplicas, this.collisionCount, this.conditions, this.observedGeneration, this.readyReplicas, this.replicas, this.unavailableReplicas, this.updatedReplicas);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta2DeploymentStatus {\n");
        sb.append("    availableReplicas: ").append(this.toIndentedString(this.availableReplicas)).append("\n");
        sb.append("    collisionCount: ").append(this.toIndentedString(this.collisionCount)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("    readyReplicas: ").append(this.toIndentedString(this.readyReplicas)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    unavailableReplicas: ").append(this.toIndentedString(this.unavailableReplicas)).append("\n");
        sb.append("    updatedReplicas: ").append(this.toIndentedString(this.updatedReplicas)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

