/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1alpha1FlowDistinguisherMethod;
import io.kubernetes.client.openapi.models.V1alpha1PolicyRulesWithSubjects;
import io.kubernetes.client.openapi.models.V1alpha1PriorityLevelConfigurationReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="FlowSchemaSpec describes how the FlowSchema's specification looks like.")
public class V1alpha1FlowSchemaSpec {
    public static final String SERIALIZED_NAME_DISTINGUISHER_METHOD = "distinguisherMethod";
    @SerializedName(value="distinguisherMethod")
    private V1alpha1FlowDistinguisherMethod distinguisherMethod;
    public static final String SERIALIZED_NAME_MATCHING_PRECEDENCE = "matchingPrecedence";
    @SerializedName(value="matchingPrecedence")
    private Integer matchingPrecedence;
    public static final String SERIALIZED_NAME_PRIORITY_LEVEL_CONFIGURATION = "priorityLevelConfiguration";
    @SerializedName(value="priorityLevelConfiguration")
    private V1alpha1PriorityLevelConfigurationReference priorityLevelConfiguration;
    public static final String SERIALIZED_NAME_RULES = "rules";
    @SerializedName(value="rules")
    private List<V1alpha1PolicyRulesWithSubjects> rules = null;

    public V1alpha1FlowSchemaSpec distinguisherMethod(V1alpha1FlowDistinguisherMethod distinguisherMethod) {
        this.distinguisherMethod = distinguisherMethod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha1FlowDistinguisherMethod getDistinguisherMethod() {
        return this.distinguisherMethod;
    }

    public void setDistinguisherMethod(V1alpha1FlowDistinguisherMethod distinguisherMethod) {
        this.distinguisherMethod = distinguisherMethod;
    }

    public V1alpha1FlowSchemaSpec matchingPrecedence(Integer matchingPrecedence) {
        this.matchingPrecedence = matchingPrecedence;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`matchingPrecedence` is used to choose among the FlowSchemas that match a given request. The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence.  Each MatchingPrecedence value must be non-negative. Note that if the precedence is not specified or zero, it will be set to 1000 as default.")
    public Integer getMatchingPrecedence() {
        return this.matchingPrecedence;
    }

    public void setMatchingPrecedence(Integer matchingPrecedence) {
        this.matchingPrecedence = matchingPrecedence;
    }

    public V1alpha1FlowSchemaSpec priorityLevelConfiguration(V1alpha1PriorityLevelConfigurationReference priorityLevelConfiguration) {
        this.priorityLevelConfiguration = priorityLevelConfiguration;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1alpha1PriorityLevelConfigurationReference getPriorityLevelConfiguration() {
        return this.priorityLevelConfiguration;
    }

    public void setPriorityLevelConfiguration(V1alpha1PriorityLevelConfigurationReference priorityLevelConfiguration) {
        this.priorityLevelConfiguration = priorityLevelConfiguration;
    }

    public V1alpha1FlowSchemaSpec rules(List<V1alpha1PolicyRulesWithSubjects> rules) {
        this.rules = rules;
        return this;
    }

    public V1alpha1FlowSchemaSpec addRulesItem(V1alpha1PolicyRulesWithSubjects rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1alpha1PolicyRulesWithSubjects>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`rules` describes which requests will match this flow schema. This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.")
    public List<V1alpha1PolicyRulesWithSubjects> getRules() {
        return this.rules;
    }

    public void setRules(List<V1alpha1PolicyRulesWithSubjects> rules) {
        this.rules = rules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1FlowSchemaSpec v1alpha1FlowSchemaSpec = (V1alpha1FlowSchemaSpec)o;
        return Objects.equals(this.distinguisherMethod, v1alpha1FlowSchemaSpec.distinguisherMethod) && Objects.equals(this.matchingPrecedence, v1alpha1FlowSchemaSpec.matchingPrecedence) && Objects.equals(this.priorityLevelConfiguration, v1alpha1FlowSchemaSpec.priorityLevelConfiguration) && Objects.equals(this.rules, v1alpha1FlowSchemaSpec.rules);
    }

    public int hashCode() {
        return Objects.hash(this.distinguisherMethod, this.matchingPrecedence, this.priorityLevelConfiguration, this.rules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1FlowSchemaSpec {\n");
        sb.append("    distinguisherMethod: ").append(this.toIndentedString(this.distinguisherMethod)).append("\n");
        sb.append("    matchingPrecedence: ").append(this.toIndentedString(this.matchingPrecedence)).append("\n");
        sb.append("    priorityLevelConfiguration: ").append(this.toIndentedString(this.priorityLevelConfiguration)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

