package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta2ReplicaSetListBuilder extends V1beta2ReplicaSetListFluentImpl<V1beta2ReplicaSetListBuilder> implements VisitableBuilder<V1beta2ReplicaSetList,V1beta2ReplicaSetListBuilder>{

    V1beta2ReplicaSetListFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta2ReplicaSetListBuilder(){
            this(true);
    }
    public V1beta2ReplicaSetListBuilder(Boolean validationEnabled){
            this(new V1beta2ReplicaSetList(), validationEnabled);
    }
    public V1beta2ReplicaSetListBuilder(V1beta2ReplicaSetListFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta2ReplicaSetListBuilder(V1beta2ReplicaSetListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta2ReplicaSetList(), validationEnabled);
    }
    public V1beta2ReplicaSetListBuilder(V1beta2ReplicaSetListFluent<?> fluent,V1beta2ReplicaSetList instance){
            this(fluent, instance, true);
    }
    public V1beta2ReplicaSetListBuilder(V1beta2ReplicaSetListFluent<?> fluent,V1beta2ReplicaSetList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta2ReplicaSetListBuilder(V1beta2ReplicaSetList instance){
            this(instance,true);
    }
    public V1beta2ReplicaSetListBuilder(V1beta2ReplicaSetList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta2ReplicaSetList build(){
            V1beta2ReplicaSetList buildable = new V1beta2ReplicaSetList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2ReplicaSetListBuilder that = (V1beta2ReplicaSetListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
