package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class V1beta1VolumeAttachmentStatusFluentImpl<A extends V1beta1VolumeAttachmentStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1VolumeAttachmentStatusFluent<A>{

    private V1beta1VolumeErrorBuilder attachError;
    private Boolean attached;
    private Map<String,String> attachmentMetadata;
    private V1beta1VolumeErrorBuilder detachError;

    public V1beta1VolumeAttachmentStatusFluentImpl(){
    }
    public V1beta1VolumeAttachmentStatusFluentImpl(V1beta1VolumeAttachmentStatus instance){
            this.withAttachError(instance.getAttachError());

            this.withAttached(instance.getAttached());

            this.withAttachmentMetadata(instance.getAttachmentMetadata());

            this.withDetachError(instance.getDetachError());

    }

    
/**
 * This method has been deprecated, please use method buildAttachError instead.
 * @return The buildable object.
 */
@Deprecated public V1beta1VolumeError getAttachError(){
            return this.attachError!=null?this.attachError.build():null;
    }

    public V1beta1VolumeError buildAttachError(){
            return this.attachError!=null?this.attachError.build():null;
    }

    public A withAttachError(V1beta1VolumeError attachError){
            _visitables.get("attachError").remove(this.attachError);
            if (attachError!=null){ this.attachError= new V1beta1VolumeErrorBuilder(attachError); _visitables.get("attachError").add(this.attachError);} return (A) this;
    }

    public Boolean hasAttachError(){
            return this.attachError != null;
    }

    public V1beta1VolumeAttachmentStatusFluent.AttachErrorNested<A> withNewAttachError(){
            return new AttachErrorNestedImpl();
    }

    public V1beta1VolumeAttachmentStatusFluent.AttachErrorNested<A> withNewAttachErrorLike(V1beta1VolumeError item){
            return new AttachErrorNestedImpl(item);
    }

    public V1beta1VolumeAttachmentStatusFluent.AttachErrorNested<A> editAttachError(){
            return withNewAttachErrorLike(getAttachError());
    }

    public V1beta1VolumeAttachmentStatusFluent.AttachErrorNested<A> editOrNewAttachError(){
            return withNewAttachErrorLike(getAttachError() != null ? getAttachError(): new V1beta1VolumeErrorBuilder().build());
    }

    public V1beta1VolumeAttachmentStatusFluent.AttachErrorNested<A> editOrNewAttachErrorLike(V1beta1VolumeError item){
            return withNewAttachErrorLike(getAttachError() != null ? getAttachError(): item);
    }

    public Boolean isAttached(){
            return this.attached;
    }

    public A withAttached(Boolean attached){
            this.attached=attached; return (A) this;
    }

    public Boolean hasAttached(){
            return this.attached != null;
    }

    public A withNewAttached(String arg1){
            return (A)withAttached(new Boolean(arg1));
    }

    public A withNewAttached(boolean arg1){
            return (A)withAttached(new Boolean(arg1));
    }

    public A addToAttachmentMetadata(String key,String value){
            if(this.attachmentMetadata == null && key != null && value != null) { this.attachmentMetadata = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.attachmentMetadata.put(key, value);} return (A)this;
    }

    public A addToAttachmentMetadata(Map<String,String> map){
            if(this.attachmentMetadata == null && map != null) { this.attachmentMetadata = new LinkedHashMap<String,String>(); }
            if(map != null) { this.attachmentMetadata.putAll(map);} return (A)this;
    }

    public A removeFromAttachmentMetadata(String key){
            if(this.attachmentMetadata == null) { return (A) this; }
            if(key != null && this.attachmentMetadata != null) {this.attachmentMetadata.remove(key);} return (A)this;
    }

    public A removeFromAttachmentMetadata(Map<String,String> map){
            if(this.attachmentMetadata == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.attachmentMetadata != null){this.attachmentMetadata.remove(key);}}} return (A)this;
    }

    public Map<String,String> getAttachmentMetadata(){
            return this.attachmentMetadata;
    }

    public A withAttachmentMetadata(Map<String,String> attachmentMetadata){
            if (attachmentMetadata == null) { this.attachmentMetadata =  null;} else {this.attachmentMetadata = new LinkedHashMap<String,String>(attachmentMetadata);} return (A) this;
    }

    public Boolean hasAttachmentMetadata(){
            return this.attachmentMetadata != null;
    }

    
/**
 * This method has been deprecated, please use method buildDetachError instead.
 * @return The buildable object.
 */
@Deprecated public V1beta1VolumeError getDetachError(){
            return this.detachError!=null?this.detachError.build():null;
    }

    public V1beta1VolumeError buildDetachError(){
            return this.detachError!=null?this.detachError.build():null;
    }

    public A withDetachError(V1beta1VolumeError detachError){
            _visitables.get("detachError").remove(this.detachError);
            if (detachError!=null){ this.detachError= new V1beta1VolumeErrorBuilder(detachError); _visitables.get("detachError").add(this.detachError);} return (A) this;
    }

    public Boolean hasDetachError(){
            return this.detachError != null;
    }

    public V1beta1VolumeAttachmentStatusFluent.DetachErrorNested<A> withNewDetachError(){
            return new DetachErrorNestedImpl();
    }

    public V1beta1VolumeAttachmentStatusFluent.DetachErrorNested<A> withNewDetachErrorLike(V1beta1VolumeError item){
            return new DetachErrorNestedImpl(item);
    }

    public V1beta1VolumeAttachmentStatusFluent.DetachErrorNested<A> editDetachError(){
            return withNewDetachErrorLike(getDetachError());
    }

    public V1beta1VolumeAttachmentStatusFluent.DetachErrorNested<A> editOrNewDetachError(){
            return withNewDetachErrorLike(getDetachError() != null ? getDetachError(): new V1beta1VolumeErrorBuilder().build());
    }

    public V1beta1VolumeAttachmentStatusFluent.DetachErrorNested<A> editOrNewDetachErrorLike(V1beta1VolumeError item){
            return withNewDetachErrorLike(getDetachError() != null ? getDetachError(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1beta1VolumeAttachmentStatusFluentImpl that = (V1beta1VolumeAttachmentStatusFluentImpl) o;
            if (attachError != null ? !attachError.equals(that.attachError) :that.attachError != null) return false;
            if (attached != null ? !attached.equals(that.attached) :that.attached != null) return false;
            if (attachmentMetadata != null ? !attachmentMetadata.equals(that.attachmentMetadata) :that.attachmentMetadata != null) return false;
            if (detachError != null ? !detachError.equals(that.detachError) :that.detachError != null) return false;
            return true;
    }


    public class AttachErrorNestedImpl<N> extends V1beta1VolumeErrorFluentImpl<V1beta1VolumeAttachmentStatusFluent.AttachErrorNested<N>> implements V1beta1VolumeAttachmentStatusFluent.AttachErrorNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1VolumeErrorBuilder builder;
    
            AttachErrorNestedImpl(V1beta1VolumeError item){
                    this.builder = new V1beta1VolumeErrorBuilder(this, item);
            }
            AttachErrorNestedImpl(){
                    this.builder = new V1beta1VolumeErrorBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1VolumeAttachmentStatusFluentImpl.this.withAttachError(builder.build());
    }
    public N endAttachError(){
            return and();
    }

}
    public class DetachErrorNestedImpl<N> extends V1beta1VolumeErrorFluentImpl<V1beta1VolumeAttachmentStatusFluent.DetachErrorNested<N>> implements V1beta1VolumeAttachmentStatusFluent.DetachErrorNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1VolumeErrorBuilder builder;
    
            DetachErrorNestedImpl(V1beta1VolumeError item){
                    this.builder = new V1beta1VolumeErrorBuilder(this, item);
            }
            DetachErrorNestedImpl(){
                    this.builder = new V1beta1VolumeErrorBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1VolumeAttachmentStatusFluentImpl.this.withDetachError(builder.build());
    }
    public N endDetachError(){
            return and();
    }

}


}
